/*
 * Decompiled with CFR 0.152.
 */
package com.simba.server.commands.sto;

import com.simba.common.command.ICommand;
import com.simba.common.database.DbOperator;
import com.simba.server.components.SorterProtocolCreator;
import com.simba.server.components.data.SortInfo;
import java.sql.Timestamp;
import org.json.JSONObject;

public class STOPacketOnCmd
implements ICommand {
    private final SortInfo sortInfo;
    private final String sql = "insert into tt_sto_packet_on(barcode,platId,carId,workerNo,platMode,packetOnTime) values(?,?,?,?,?,?);";

    public STOPacketOnCmd(SortInfo sortInfo) {
        this.sortInfo = sortInfo;
    }

    @Override
    public String getName() {
        return "STOPacketOn";
    }

    @Override
    public Boolean run(Object params) {
        Boolean ret = false;
        if (!(params instanceof DbOperator)) {
            return ret;
        }
        try {
            DbOperator dbOperator = (DbOperator)params;
            dbOperator.prepareStatement(this.sql);
            String barcode = this.sortInfo.getBarcode();
            if (barcode == null || barcode.equals("")) {
                barcode = "none";
            }
            dbOperator.setString(1, barcode);
            String platId = String.valueOf(this.sortInfo.getPlcPlatID());
            if (platId == null || platId.equals("")) {
                platId = "none";
            }
            dbOperator.setString(2, platId);
            String carId = this.sortInfo.getCarId();
            if (carId == null || carId.equals("")) {
                carId = "0";
            }
            if (carId.contains("-")) {
                carId = carId.substring(carId.indexOf("-") + 1);
            }
            dbOperator.setString(3, carId);
            JSONObject dataObj = this.sortInfo.getDataObj();
            String strWorkerNumber = dataObj.getString("workerNumber");
            if (strWorkerNumber == null) {
                strWorkerNumber = "";
            }
            dbOperator.setString(4, strWorkerNumber);
            String platMode = this.sortInfo.getPlatMode();
            if (platMode == null || platMode.equals("")) {
                platMode = "0";
            }
            dbOperator.setString(5, platMode);
            Timestamp packetOnTime = this.sortInfo.getTimestampPacketOn();
            if (packetOnTime == null) {
                packetOnTime = SorterProtocolCreator.getInstance().createCurrentTimeStamp();
            }
            String packetOnTimeContent = packetOnTime.toString();
            dbOperator.setString(6, packetOnTimeContent);
            int res = dbOperator.executeUpdate();
            ret = res <= 0 ? Boolean.valueOf(false) : Boolean.valueOf(true);
        }
        catch (Exception ex) {
            ret = false;
        }
        return ret;
    }
}

