/*
 * Decompiled with CFR 0.152.
 */
package com.simba.server.commands.sto;

import com.simba.common.command.ICommand;
import com.simba.common.database.DbOperator;
import com.simba.common.log.Log4jLogger;
import com.simba.common.log.LogTask;
import com.simba.common.log.LoggerExecutor;
import com.simba.server.components.SorterProtocolCreator;
import com.simba.server.components.data.SortInfo;
import com.simba.server.controllers.sto.data.STOSlotManager;
import java.sql.Timestamp;
import org.apache.log4j.Logger;
import org.json.JSONObject;

public class STOPacketOffHistoryCmd
implements ICommand {
    private static final Logger logger = Logger.getLogger(STOPacketOffHistoryCmd.class);
    private final SortInfo sortInfo;
    private final String sql = "insert into tt_sto_packet_off_history(barcode,carId,platId,plcId,slotsContent,droppedSlot,sortingId,packCode,turnNumber,stoMode,Code1,Code2,Code3,destValue,packetOffTime) values(?,?,?,?,?,?,?,?,?,?,?,?,?,?,?);";

    public STOPacketOffHistoryCmd(SortInfo sortInfo) {
        this.sortInfo = sortInfo;
    }

    @Override
    public String getName() {
        return "STOPacketOffHistory";
    }

    @Override
    public Boolean run(Object params) {
        Boolean ret = false;
        if (!(params instanceof DbOperator)) {
            return ret;
        }
        try {
            DbOperator dbOperator = (DbOperator)params;
            dbOperator.prepareStatement(this.sql);
            String barcode = this.sortInfo.getBarcode();
            if (barcode == null || barcode.equals("")) {
                barcode = "none";
            }
            dbOperator.setString(1, barcode);
            String carId = this.sortInfo.getCarId();
            if (carId == null || carId.equals("")) {
                carId = "0";
            }
            if (carId.contains("-")) {
                carId = carId.substring(carId.indexOf("-") + 1);
            }
            dbOperator.setString(2, carId);
            String platId = String.valueOf(this.sortInfo.getPlatId());
            if (platId == null || platId.equals("")) {
                platId = "none";
            }
            dbOperator.setString(3, platId);
            String plcId = this.sortInfo.getPlcId();
            if (plcId == null || plcId.equals("")) {
                plcId = "none";
            }
            dbOperator.setString(4, plcId);
            StringBuilder slotsContent = new StringBuilder();
            int slotNum = this.sortInfo.getSlotsList().size();
            for (int i = 0; i < slotNum; ++i) {
                if (i != slotNum - 1) {
                    slotsContent.append(String.valueOf(this.sortInfo.getSlotsList().get(i)));
                    slotsContent.append(",");
                    continue;
                }
                slotsContent.append(String.valueOf(this.sortInfo.getSlotsList().get(i)));
            }
            String subSlotcontents = slotsContent.toString();
            if (subSlotcontents.length() > 100) {
                subSlotcontents = subSlotcontents.substring(0, 100);
            }
            dbOperator.setString(5, subSlotcontents);
            int droppedSlot = this.sortInfo.getDroppedSlotId();
            dbOperator.setInt(6, droppedSlot);
            String sortingId = this.sortInfo.getSortingId();
            if (sortingId == null || sortingId.equals("")) {
                sortingId = "none";
            }
            if (sortingId.length() > 16) {
                sortingId = sortingId.substring(0, 16);
            }
            dbOperator.setString(7, sortingId);
            String packCode = this.sortInfo.getPackCode();
            JSONObject dataObj = this.sortInfo.getDataObj();
            String stoMode = "none";
            if (dataObj.has("stoMode")) {
                stoMode = dataObj.getString("stoMode");
            }
            if (packCode == null || packCode.equals("")) {
                packCode = "none";
            }
            String strCurPack = packCode;
            if (dataObj.has("sto-pckcode")) {
                String strPackList = dataObj.getString("sto-pckcode");
                strCurPack = STOSlotManager.getInstance().getPackCodeBySlot(strPackList, String.valueOf(droppedSlot));
                this.sortInfo.setPackCode(strCurPack);
            }
            dbOperator.setString(8, strCurPack);
            int turnNumber = this.sortInfo.getTurnNumber();
            dbOperator.setInt(9, turnNumber);
            dbOperator.setString(10, stoMode);
            String code1 = "none";
            if (dataObj.has("Code1")) {
                code1 = dataObj.getString("Code1");
            }
            dbOperator.setString(11, code1);
            String code2 = "none";
            if (dataObj.has("Code2")) {
                code2 = dataObj.getString("Code2");
            }
            dbOperator.setString(12, code2);
            String code3 = "none";
            if (dataObj.has("Code3")) {
                code3 = dataObj.getString("Code3");
            }
            dbOperator.setString(13, code3);
            int SlotId = this.sortInfo.getDroppedSlotId();
            String nextStaCode = "none";
            nextStaCode = STOSlotManager.getInstance().getNextStaCodeBySlot(this.sortInfo, SlotId);
            if (nextStaCode == null) {
                nextStaCode = "none";
            }
            dbOperator.setString(14, nextStaCode);
            Timestamp packetOffTime = this.sortInfo.getTimestampPacketOff();
            if (packetOffTime == null) {
                packetOffTime = SorterProtocolCreator.getInstance().createCurrentTimeStamp();
            }
            String packetOffTimeContent = packetOffTime.toString();
            dbOperator.setString(15, packetOffTimeContent);
            int res = dbOperator.executeUpdate();
            ret = res <= 0 ? Boolean.valueOf(false) : Boolean.valueOf(true);
        }
        catch (Exception ex) {
            LoggerExecutor.getInstance().execute(new LogTask(new Log4jLogger(logger), "Handle Sto Packet Off History Message In STOPacketOffHistory Handler Error -- Exception : " + ex, 2));
            ret = false;
        }
        return ret;
    }
}

