/*
 * Decompiled with CFR 0.152.
 */
package com.simba.server.commands.sto;

import com.simba.common.command.ICommand;
import com.simba.common.database.DbOperator;
import com.simba.server.components.SlotManager;
import com.simba.server.components.SorterProtocolCreator;
import com.simba.server.components.data.SortInfo;
import com.simba.server.controllers.sto.data.STOSlotManager;
import java.sql.Timestamp;
import java.util.LinkedList;
import java.util.UUID;
import org.json.JSONObject;

public class STOPackResultHistoryCmd
implements ICommand {
    private final SortInfo sortInfo;
    private final String sql = "insert into tt_sto_package_result(packageCode,billCode,weight,stoMode,siteCode,nextStaCode,workNumber,uuid,slotsContent,droppedSlot,platId,dropErrorCode,serverErrorCode,serverErrorReason,carId,Code1,Code2,Code3,scanTime) values(?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?);";

    public STOPackResultHistoryCmd(SortInfo sortInfo) {
        this.sortInfo = sortInfo;
    }

    @Override
    public String getName() {
        return "STOPackResultHistory";
    }

    @Override
    public Boolean run(Object params) {
        Boolean ret = false;
        if (!(params instanceof DbOperator)) {
            return ret;
        }
        try {
            String packCode;
            String workNumber;
            DbOperator dbOperator = (DbOperator)params;
            UUID uuid = UUID.randomUUID();
            String strUUID = uuid.toString().replace("-", "");
            dbOperator.prepareStatement(this.sql);
            JSONObject dataObj = this.sortInfo.getDataObj();
            String stoMode = "none";
            if (dataObj.has("stoMode")) {
                stoMode = dataObj.getString("stoMode");
            }
            if ((workNumber = dataObj.getString("workerNumber")) == null) {
                workNumber = "";
            }
            if ((packCode = this.sortInfo.getPackCode()) == null || packCode.equals("")) {
                packCode = "none";
            }
            String strCurPack = packCode;
            if (dataObj.has("sto-pckcode")) {
                String strPackList = dataObj.getString("sto-pckcode");
                strCurPack = STOSlotManager.getInstance().getPackCodeBySlot(strPackList, String.valueOf(this.sortInfo.getDroppedSlotId()));
                this.sortInfo.setPackCode(strCurPack);
            }
            dbOperator.setString(1, strCurPack);
            String barcode = this.sortInfo.getBarcode();
            if (barcode == null || barcode.equals("")) {
                barcode = "none";
            }
            dbOperator.setString(2, barcode);
            String weight = this.sortInfo.getWeight();
            if (weight == null || weight.equals("")) {
                weight = "0";
            }
            dbOperator.setFloat(3, Float.valueOf(weight).floatValue());
            dbOperator.setString(4, stoMode);
            String siteCode = "none";
            if (!this.sortInfo.getSiteCode().equalsIgnoreCase("")) {
                siteCode = this.sortInfo.getSiteCode();
            }
            dbOperator.setString(5, siteCode);
            int SlotId = this.sortInfo.getDroppedSlotId();
            String nextStaCode = "none";
            nextStaCode = STOSlotManager.getInstance().getNextStaCodeBySlot(this.sortInfo, SlotId);
            if (nextStaCode == null) {
                nextStaCode = "none";
            }
            if (stoMode.contains("arr") && STOSlotManager.getInstance().canSlotPack(stoMode, this.sortInfo, SlotId).booleanValue()) {
                stoMode = "departure";
                dbOperator.setString(4, stoMode);
            }
            dbOperator.setString(6, nextStaCode);
            dbOperator.setString(7, workNumber);
            dbOperator.setString(8, strUUID);
            StringBuilder slotsContent = new StringBuilder();
            int slotNum = this.sortInfo.getSlotsList().size();
            LinkedList<String> slotsListAppend = new LinkedList<String>();
            for (int i = 0; i < slotNum; ++i) {
                String strSlot = String.valueOf(this.sortInfo.getSlotsList().get(i));
                if (slotsListAppend.contains(strSlot)) continue;
                if (i != slotNum - 1) {
                    slotsContent.append(strSlot);
                    slotsContent.append(",");
                } else {
                    slotsContent.append(strSlot);
                }
                slotsListAppend.add(strSlot);
            }
            String subSlotcontents = slotsContent.toString();
            if (subSlotcontents.length() > 100) {
                subSlotcontents = subSlotcontents.substring(0, 100);
            }
            dbOperator.setString(9, subSlotcontents);
            int droppedSlot = this.sortInfo.getDroppedSlotId();
            dbOperator.setInt(10, droppedSlot);
            String platId = String.valueOf(this.sortInfo.getPlatId());
            if (platId == null || platId.equals("")) {
                platId = "none";
            }
            dbOperator.setString(11, platId);
            int errorCode = this.sortInfo.getDroppedErrorCode();
            dbOperator.setInt(12, errorCode);
            int serverCode = this.sortInfo.getServerErrorCode();
            boolean isOverTimeSlot = SlotManager.getInstance().isSlotOverTime(String.valueOf(droppedSlot), subSlotcontents);
            if (isOverTimeSlot) {
                serverCode = 4;
            }
            dbOperator.setInt(13, serverCode);
            String serverErrorDes = SlotManager.getInstance().getServerReason(serverCode);
            dbOperator.setString(14, serverErrorDes);
            String carId = this.sortInfo.getCarId();
            if (carId == null || carId.equals("")) {
                carId = "0";
            }
            dbOperator.setString(15, carId);
            String code1 = "none";
            if (dataObj.has("Code1")) {
                code1 = dataObj.getString("Code1");
            }
            dbOperator.setString(16, code1);
            String code2 = "none";
            if (dataObj.has("Code2")) {
                code2 = dataObj.getString("Code2");
            }
            dbOperator.setString(17, code2);
            String code3 = "none";
            if (dataObj.has("Code3")) {
                code3 = dataObj.getString("Code3");
            }
            dbOperator.setString(18, code3);
            Timestamp scannedTime = this.sortInfo.getTimestampScanned();
            if (scannedTime == null) {
                scannedTime = SorterProtocolCreator.getInstance().createCurrentTimeStamp();
            }
            String scannedTimeContent = scannedTime.toString();
            dbOperator.setString(19, scannedTimeContent);
            int res = dbOperator.executeUpdate();
            ret = res <= 0 ? Boolean.valueOf(false) : Boolean.valueOf(true);
        }
        catch (Exception ex) {
            ret = false;
        }
        return ret;
    }
}

