/*
 * Decompiled with CFR 0.152.
 */
package com.simba.server.commands.sto;

import com.simba.common.command.ICommand;
import com.simba.common.database.DbOperator;
import com.simba.common.log.Log4jLogger;
import com.simba.common.log.LogTask;
import com.simba.common.log.LoggerExecutor;
import com.simba.server.controllers.sto.STOCommonParams;
import com.simba.server.controllers.sto.data.STOSlotManager;
import java.sql.ResultSet;
import java.sql.Timestamp;
import org.apache.log4j.Logger;

public class STONotSortedCmd
implements ICommand {
    private static final Logger logger = Logger.getLogger(STONotSortedCmd.class);
    private final String barcode;

    public STONotSortedCmd(String barcode) {
        this.barcode = barcode;
    }

    @Override
    public String getName() {
        return "STONotSorted";
    }

    @Override
    public Boolean run(Object params) {
        Boolean ret = true;
        if (!(params instanceof DbOperator)) {
            return ret;
        }
        long millseconds = STOCommonParams.getInstance().getNextSortInterceptHour() * 60 * 60 * 1000;
        Timestamp scanTimestamp = new Timestamp(System.currentTimeMillis() - millseconds);
        DbOperator dbOperator = (DbOperator)params;
        String sql = "select * from tt_sto_scanned_info  where barcode=? and recordDate<? and sortInfoMode='arrival'";
        try {
            dbOperator.prepareStatement(sql);
            dbOperator.setString(1, this.barcode);
            dbOperator.setTimestamp(2, scanTimestamp);
            ResultSet rs = dbOperator.executeQuery();
            if (rs.next()) {
                ret = false;
            }
            if (STOCommonParams.getInstance().getSiteName().equalsIgnoreCase("JiaDing")) {
                ret = true;
            }
            if (STOSlotManager.getInstance().getBarcodeIntercept().containsKey(this.barcode)) {
                ret = false;
            }
        }
        catch (Exception ex) {
            LoggerExecutor.getInstance().execute(new LogTask(new Log4jLogger(logger), "Catch exception when query sorted info : " + ex.getMessage(), 2));
            ret = false;
        }
        return ret;
    }
}

