/*
 * Decompiled with CFR 0.152.
 */
package com.simba.server.commands.sto;

import com.simba.common.command.ICommand;
import com.simba.common.database.DbOperator;
import com.simba.server.components.SlotManager;
import java.sql.ResultSet;

public class STOFetchSlotWorkNumCmd
implements ICommand {
    private final String sql = "select * from tt_sto_slot_workNum;";

    @Override
    public String getName() {
        return "STOFetchSlotWorkNum";
    }

    @Override
    public Boolean run(Object params) {
        Boolean ret = false;
        if (!(params instanceof DbOperator)) {
            return ret;
        }
        try {
            DbOperator dbOperator = (DbOperator)params;
            dbOperator.prepareStatement(this.sql);
            ResultSet rs = dbOperator.executeQuery();
            while (rs.next()) {
                String workNum = rs.getString("workNum");
                int slot = rs.getInt("slot");
                String sortMode = rs.getString("sortMode");
                if (sortMode.equalsIgnoreCase("arrival")) {
                    SlotManager.getInstance().getArrivalSlotWorkNumMap().put(slot, workNum);
                } else {
                    SlotManager.getInstance().getDepartureSlotWorkNumMap().put(slot, workNum);
                }
                ret = true;
            }
        }
        catch (Exception ex) {
            ret = false;
        }
        return ret;
    }
}

