/*
 * Decompiled with CFR 0.152.
 */
package com.simba.server.commands.sto;

import com.simba.common.command.ICommand;
import com.simba.common.database.DbOperator;
import com.simba.server.components.data.PlcInfo;
import com.simba.server.controllers.sto.STOCommonParams;
import java.sql.ResultSet;
import java.util.HashMap;

public class STOFetchPlcConfigCmd
implements ICommand {
    private final String sql = "select * from tt_sto_plc_config;";
    private final HashMap<String, PlcInfo> stoPlcMap;

    public STOFetchPlcConfigCmd(HashMap plcMap) {
        this.stoPlcMap = plcMap;
    }

    @Override
    public String getName() {
        return "STOFetchPlcConfig";
    }

    @Override
    public Boolean run(Object params) {
        Boolean ret = false;
        if (!(params instanceof DbOperator)) {
            return ret;
        }
        try {
            DbOperator dbOperator = (DbOperator)params;
            dbOperator.prepareStatement(this.sql);
            ResultSet rs = dbOperator.executeQuery();
            while (rs.next()) {
                String pipLine = rs.getString("pipLine");
                String plcAddr = rs.getString("plcAddr");
                String carFlag = rs.getString("carFlag");
                int slotCanLock = rs.getInt("slotCanLock");
                int minPlatID = rs.getInt("minPlatID");
                int maxPlatID = rs.getInt("maxPlatID");
                int adjustPlatNumber = rs.getInt("adjustPlatNumber");
                int adjustSlotNumber = rs.getInt("adjustSlotNumber");
                int platNum = rs.getInt("platNum");
                STOCommonParams.getInstance().setEachLayerPlatNums(platNum);
                PlcInfo plcInfo = new PlcInfo();
                plcInfo.setPipLine(pipLine);
                plcInfo.setPlcAddr(plcAddr);
                plcInfo.setCarFlag(pipLine + carFlag);
                plcInfo.setMinPlatID(minPlatID);
                plcInfo.setMaxPlatID(maxPlatID);
                plcInfo.setSlotCanLock(slotCanLock);
                plcInfo.setAdjustPlatNumber(adjustPlatNumber);
                plcInfo.setAdjustSlotNumber(adjustSlotNumber);
                if (!this.stoPlcMap.containsKey(plcAddr)) {
                    this.stoPlcMap.put(plcAddr, plcInfo);
                }
                float speed = rs.getFloat("speed");
                int layer = rs.getInt("layer");
                plcInfo.setLayer(layer);
                if (speed < 1.0f) {
                    speed = 2.0f;
                }
                STOCommonParams.getInstance().setSpeed(speed);
                ret = true;
            }
        }
        catch (Exception ex) {
            ret = false;
        }
        return ret;
    }
}

