/*
 * Decompiled with CFR 0.152.
 */
package com.simba.server;

import com.simba.GlobalParam;
import com.simba.common.command.CommandParams;
import com.simba.common.command.SQLCommandExecutor;
import com.simba.common.database.DbPool;
import com.simba.common.database.DbPoolInterface;
import com.simba.common.frameserver.FrameChannelHandler;
import com.simba.common.frameserver.FrameChannelManager;
import com.simba.common.frameserver.OneBFrameServer;
import com.simba.common.httpserver.HttpChannelHandler;
import com.simba.common.httpserver.HttpChannelManager;
import com.simba.common.httpserver.HttpServer;
import com.simba.common.jsonserver.JsonChannelHandler;
import com.simba.common.jsonserver.JsonChannelManager;
import com.simba.common.jsonserver.JsonServer;
import com.simba.common.log.Log4jLogger;
import com.simba.common.log.LogHelper;
import com.simba.common.log.LogTask;
import com.simba.common.log.LoggerExecutor;
import com.simba.common.processor.FrameProcessor;
import com.simba.common.processor.HttpProcessor;
import com.simba.common.processor.JsonProcessor;
import com.simba.server.ServerParam;
import com.simba.server.components.PlatInstanceManager;
import com.simba.server.components.SlotManager;
import com.simba.server.components.SortControllerManager;
import com.simba.server.components.SorterCommonParams;
import com.simba.server.components.SorterProtocolCreator;
import com.simba.server.components.task.DataUploadCheckTask;
import com.simba.server.components.task.SortResultStaticTask;
import com.simba.server.components.task.SorterStatusTask;
import com.simba.server.components.task.SynTimeTask;
import com.simba.server.controllers.sto.data.STOSlotManager;
import com.simba.server.framedecoder.FrameDecoderManager;
import com.simba.server.httpservice.HttpServiceManager;
import com.simba.server.jsonservice.JsonServiceManager;
import com.simba.server.netclient.DefaultBootstrapManager;
import com.simba.server.netclient.DefaultClientManager;
import java.io.File;
import java.text.SimpleDateFormat;
import java.util.LinkedList;
import java.util.List;
import org.apache.log4j.Logger;
import org.jdom2.Document;
import org.jdom2.Element;
import org.jdom2.input.SAXBuilder;
import org.jdom2.input.sax.XMLReaderSAX2Factory;

public class ServerManager {
    private static final String CLIENT_CONFIG_FILE = "simba-client-config.xml";
    private static ServerManager instance = new ServerManager();
    private static final String LOG_HEADERS_CONFIG_FILE = "simba-header-config.xml";
    private static final String LOG4J_CONFIG_FILE_DEBUG = "simba-log4j-debug.xml";
    private static final String LOG4J_CONFIG_FILE_VERBOSE = "simba-log4j-verbose.xml";
    private static final Logger logger = Logger.getLogger(ServerManager.class);
    private static final String MYSQL_DATABASE_CONFIG_FILE = "simba-mysql-config.xml";
    private static final String MYSQL_STO_DATABASE_CONFIG_FILE = "sto-mysql-config.xml";
    private static final String PLAT_CONFIG_FILE = "simba-plat-config.xml";
    private final SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
    private OneBFrameServer frameServer;
    private HttpServer httpServer;
    private JsonServer jsonServer;
    private final DbPoolInterface mysqlDbPool = new DbPool("simba-mysql-config.xml", "mysql");
    private final DbPoolInterface stoMysqlDbPool = new DbPool("sto-mysql-config.xml", "mysql");
    private String runMode;
    private int serialNumber;
    private final SorterStatusTask sorterStatusTask = new SorterStatusTask();
    private final SortResultStaticTask sortResultStaticTask = new SortResultStaticTask();
    public final DataUploadCheckTask dataUploadCheckTask = new DataUploadCheckTask();
    public final SynTimeTask synTimeTask = new SynTimeTask();
    private final List<String> logHeaders = new LinkedList<String>();

    public static ServerManager getInstance() {
        return instance;
    }

    private ServerManager() {
    }

    public SimpleDateFormat getDateformat() {
        return this.dateFormat;
    }

    public OneBFrameServer getFrameServer() {
        return this.frameServer;
    }

    public String getRunMode() {
        return this.runMode;
    }

    public int getSerialNumber() {
        return this.serialNumber;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Document getXmlDocFromFile(File fp) throws Exception {
        Document xmlDoc = null;
        try {
            SAXBuilder builder = null;
            String driver = "org.apache.crimson.parser.XMLReaderImpl";
            builder = new SAXBuilder(new XMLReaderSAX2Factory(false, driver));
            xmlDoc = builder.build(fp);
        }
        catch (Exception ex) {
            if (xmlDoc == null) {
                throw ex;
            }
        }
        return xmlDoc;
    }

    public void init() {
        this.initParam();
        this.initDatabase();
        this.initServerInstance();
        this.buildAllServers();
        this.startSingleThreadTasks();
        ServerParam.printStartedInfo();
        this.postInitProcess();
    }

    public void setFrameMessageServer(OneBFrameServer frameSorterServer) {
        this.frameServer = frameSorterServer;
    }

    public void setRunMode(String runMode) {
        this.runMode = runMode;
    }

    public void setSerialNumber(int serialNumber) {
        this.serialNumber = serialNumber;
    }

    protected void buildAllServers() {
        this.buildFrameServer();
        this.buildHttpServer();
        this.buildJsonServer();
    }

    protected void initDbPool() {
        this.mysqlDbPool.init(true);
        SQLCommandExecutor.getInstance().setDbPool(this.mysqlDbPool);
        this.stoMysqlDbPool.init(true);
        SlotManager.getInstance().stoRemoteDbSQLCommandExecutor.setDbPool(this.stoMysqlDbPool);
    }

    protected void initParam() {
        System.setProperty("java.net.preferIPv4Stack", "true");
        if (this.runMode.equals("debug")) {
            ServerParam.initRootLogger(LOG4J_CONFIG_FILE_DEBUG);
        } else {
            ServerParam.initRootLogger(LOG4J_CONFIG_FILE_VERBOSE);
        }
        ServerParam.initGlobalConfiguration();
    }

    private void buildFrameServer() {
        System.out.println("\u3010Server Init\u3011 Starting the tcp server of frame message ...");
        try {
            FrameProcessor frameMessageProcessor = new FrameProcessor(FrameDecoderManager.getInstance(), FrameChannelManager.getInstance());
            FrameChannelHandler handler = new FrameChannelHandler(frameMessageProcessor);
            this.setFrameMessageServer(new OneBFrameServer(ServerParam.getServerInfo().getDefaultServerAddress(), ServerParam.getServerInfo().getDefaultServerPort(), ServerParam.IO_THREAD_POOL_SIZE, ServerParam.EVENT_THREAD_POOL_SIZE, handler));
            frameMessageProcessor.setLogHeaders(this.logHeaders);
            this.getFrameServer().start();
            String printInfo = "\u3010Server Init\u3011Starting the frame sorter server on: " + this.getFrameServer().getInetSocketAddress().toString();
            LoggerExecutor.getInstance().execute(new LogTask(new Log4jLogger(logger), printInfo, 1));
            System.out.println(printInfo);
        }
        catch (Exception e) {
            LogHelper.error(e.toString());
        }
    }

    private void buildHttpServer() {
        System.out.println("\u3010Server Init\u3011 Starting the http server for http-json-data ...");
        try {
            HttpProcessor httpMessageProcessor = new HttpProcessor(HttpServiceManager.getInstance(), HttpChannelManager.getInstance());
            HttpChannelHandler handler = new HttpChannelHandler(httpMessageProcessor);
            this.httpServer = new HttpServer(ServerParam.getServerInfo().getHttpServerAddress(), ServerParam.getServerInfo().getHttpServerPort(), ServerParam.IO_THREAD_POOL_SIZE, ServerParam.EVENT_THREAD_POOL_SIZE, handler);
            this.httpServer.start();
            String printInfo = "\u3010Server Init\u3011Starting the http server on: " + this.httpServer.getInetSocketAddress().toString();
            LoggerExecutor.getInstance().execute(new LogTask(new Log4jLogger(logger), printInfo, 1));
            System.out.println(printInfo);
        }
        catch (Exception e) {
            LogHelper.error(e.toString());
        }
    }

    private void buildJsonServer() {
        System.out.println("\u3010Server Init\u3011 Starting the json server for service ...");
        try {
            JsonProcessor jsonMessageProcessor = new JsonProcessor(JsonServiceManager.getInstance(), JsonChannelManager.getInstance());
            JsonChannelHandler handler = new JsonChannelHandler(jsonMessageProcessor);
            this.jsonServer = new JsonServer(ServerParam.getServerInfo().getJsonServerAddress(), ServerParam.getServerInfo().getJsonServerPort(), ServerParam.IO_THREAD_POOL_SIZE, ServerParam.EVENT_THREAD_POOL_SIZE, handler);
            this.jsonServer.start();
            String printInfo = "\u3010Server Init\u3011Starting the json server on: " + this.jsonServer.getInetSocketAddress().toString();
            LoggerExecutor.getInstance().execute(new LogTask(new Log4jLogger(logger), printInfo, 1));
            System.out.println(printInfo);
        }
        catch (Exception e) {
            LogHelper.error(e.toString());
        }
    }

    private void initClientBootstrap() {
        DefaultBootstrapManager.getInstance().init();
    }

    private void initClientManager() {
        DefaultClientManager.getInstance().init(CLIENT_CONFIG_FILE);
    }

    private void initCommandParams() {
        CommandParams.getInstance().init();
    }

    private void initDatabase() {
        this.initDbPool();
    }

    private void initFrameDecodeManager() {
        FrameDecoderManager.getInstance().init();
    }

    private void initHttpServiceManager() {
        HttpServiceManager.getInstance().init();
    }

    private void initJsonServiceManager() {
        JsonServiceManager.getInstance().init();
    }

    private void initPlatInstanceManager() {
        PlatInstanceManager.getInstance().init(PLAT_CONFIG_FILE);
    }

    private void initSendHeaders() {
        try {
            Document rootDoc = ServerManager.getInstance().getXmlDocFromFile(new File("etc" + GlobalParam.PATH_SEP + LOG_HEADERS_CONFIG_FILE));
            Element root = rootDoc.getRootElement();
            Element headersElement = root.getChild("Headers");
            List<Element> headers = headersElement.getChildren();
            for (Element element : headers) {
                String value = element.getAttributeValue("value");
                FrameChannelManager.getInstance().addHeader(value);
                this.logHeaders.add(value);
            }
        }
        catch (Exception ex) {
            LoggerExecutor.getInstance().execute(new LogTask(new Log4jLogger(logger), "Send headers init error : " + ex.getMessage(), 2));
        }
    }

    private void initServerInstance() {
        this.initFrameDecodeManager();
        this.initJsonServiceManager();
        this.initHttpServiceManager();
        this.initCommandParams();
        this.initPlatInstanceManager();
        this.initSlotManager();
        this.initSortControllerManager();
        this.initSortCommandManager();
        this.initClientBootstrap();
        this.initClientManager();
        this.initSendHeaders();
        this.initSorterParameters();
    }

    private void initSlotManager() {
        SlotManager.getInstance().init();
    }

    private void initSortCommandManager() {
        SorterProtocolCreator.getInstance().init();
    }

    private void initSortControllerManager() {
        SortControllerManager.getInstance().init();
    }

    private void initSorterParameters() {
        SorterCommonParams.getInstance().init();
    }

    private void postInitProcess() {
        FrameDecoderManager.getInstance().postInitProcess();
        JsonServiceManager.getInstance().postInitProcess();
        PlatInstanceManager.getInstance().postInitProcess();
        SlotManager.getInstance().postInitProcess();
        this.whenInitProcessEnd();
        STOSlotManager.getInstance().InitLastPackOffTime();
    }

    private void startSingleThreadTasks() {
        this.sorterStatusTask.start();
        this.sortResultStaticTask.start();
        this.dataUploadCheckTask.start();
        this.synTimeTask.start();
    }

    private void whenInitProcessEnd() {
    }

    public SortResultStaticTask getSortResultStaticTask() {
        return this.sortResultStaticTask;
    }
}

