/*
 * Decompiled with CFR 0.152.
 */
package com.simba.common.websocket;

import com.simba.common.log.Log4jLogger;
import com.simba.common.log.LogTask;
import com.simba.common.log.LoggerExecutor;
import com.simba.common.processor.MessageProcessor;
import org.apache.log4j.Logger;
import org.jboss.netty.channel.Channel;
import org.jboss.netty.channel.ChannelHandlerContext;
import org.jboss.netty.channel.ChannelStateEvent;
import org.jboss.netty.channel.ExceptionEvent;
import org.jboss.netty.channel.MessageEvent;
import org.jboss.netty.handler.codec.http.HttpRequest;
import org.jboss.netty.handler.codec.http.websocketx.CloseWebSocketFrame;
import org.jboss.netty.handler.codec.http.websocketx.WebSocketFrame;
import org.jboss.netty.handler.codec.http.websocketx.WebSocketServerHandshaker;
import org.jboss.netty.handler.codec.http.websocketx.WebSocketServerHandshakerFactory;
import org.jboss.netty.handler.timeout.IdleStateAwareChannelHandler;

public class WebSocketChannelHandler
extends IdleStateAwareChannelHandler {
    protected static final Logger logger = Logger.getLogger(WebSocketChannelHandler.class);
    private static final String WEBSOCKET_PATH = "/websocket";
    private final MessageProcessor messageProcessor;

    private static String getWebSocketLocation(HttpRequest req) {
        return "ws://" + req.getHeader("HOST") + WEBSOCKET_PATH;
    }

    public WebSocketChannelHandler(MessageProcessor messageProcessor) {
        this.messageProcessor = messageProcessor;
    }

    @Override
    public void channelClosed(ChannelHandlerContext ctx, ChannelStateEvent e) throws Exception {
        Channel connection = this.getChannel(ctx);
        if (connection != null) {
            this.messageProcessor.onChannelDisconnected(connection);
        } else {
            e.getChannel().close();
        }
    }

    @Override
    public void channelOpen(ChannelHandlerContext ctx, ChannelStateEvent e) throws Exception {
        Channel connection = this.getChannel(ctx);
        if (connection != null) {
            this.messageProcessor.onChannelConnected(connection);
        }
    }

    @Override
    public void exceptionCaught(ChannelHandlerContext ctx, ExceptionEvent e) throws Exception {
        try {
            Channel channel = this.getChannel(ctx);
            if (channel != null) {
                this.messageProcessor.onExceptionCaught(channel, e.getCause());
            } else {
                channel = e.getChannel();
            }
            channel.close();
        }
        catch (Exception ex) {
            LoggerExecutor.getInstance().execute(new LogTask(new Log4jLogger(logger), "WebSocket exception : -- " + ex.getMessage(), 2));
        }
    }

    @Override
    public void messageReceived(ChannelHandlerContext ctx, MessageEvent e) throws Exception {
        try {
            Object msg = e.getMessage();
            String receivedMsg = msg.toString();
            receivedMsg = receivedMsg.substring(receivedMsg.indexOf(40) + 1, receivedMsg.indexOf(41));
            String[] RealMsg = receivedMsg.split(":");
            if (!RealMsg[1].trim().equals("")) {
                if (msg instanceof HttpRequest) {
                    this.handleHttpRequest(ctx, (HttpRequest)msg);
                } else if (msg instanceof WebSocketFrame) {
                    this.handleWebSocketFrame(ctx, (WebSocketFrame)msg);
                }
            }
        }
        catch (Exception ex) {
            LoggerExecutor.getInstance().execute(new LogTask(new Log4jLogger(logger), "WebSocket Message received exception : -- " + ex.getMessage(), 2));
        }
    }

    protected Channel getChannel(ChannelHandlerContext ctx) {
        Channel channel = ctx.getChannel();
        return channel;
    }

    private void handleHttpRequest(ChannelHandlerContext ctx, HttpRequest request) throws Exception {
        try {
            String webSocketLocation = WebSocketChannelHandler.getWebSocketLocation(request);
            WebSocketServerHandshakerFactory wsHandshakerFactory = new WebSocketServerHandshakerFactory(webSocketLocation, null, false);
            WebSocketServerHandshaker handShaker = wsHandshakerFactory.newHandshaker(request);
            if (handShaker == null) {
                wsHandshakerFactory.sendUnsupportedWebSocketVersionResponse(ctx.getChannel());
            } else {
                handShaker.handshake(ctx.getChannel(), request).addListener(WebSocketServerHandshaker.HANDSHAKE_LISTENER);
                ctx.setAttachment(handShaker);
            }
        }
        catch (Exception ex) {
            LoggerExecutor.getInstance().execute(new LogTask(new Log4jLogger(logger), "WebSocket Handle Http Request received exception : -- " + ex.getMessage(), 3));
        }
    }

    private void handleWebSocketFrame(ChannelHandlerContext ctx, WebSocketFrame frame) {
        if (frame instanceof CloseWebSocketFrame) {
            WebSocketServerHandshaker handShaker = (WebSocketServerHandshaker)ctx.getAttachment();
            if (handShaker == null) {
                return;
            }
            handShaker.close(ctx.getChannel(), (CloseWebSocketFrame)frame);
            return;
        }
        Channel channel = ctx.getChannel();
        try {
            this.messageProcessor.onMessageReceived(channel, frame);
        }
        catch (Exception e) {
            LoggerExecutor.getInstance().execute(new LogTask(new Log4jLogger(logger), "WebSocket Handle Web Socket Frame exception : -- " + e.getMessage(), 3));
        }
    }
}

