/*
 * Decompiled with CFR 0.152.
 */
package com.simba.common.processor;

import com.simba.GlobalParam;
import com.simba.common.ChannelManager;
import com.simba.common.RequestHandler;
import com.simba.common.log.Log4jLogger;
import com.simba.common.log.LogTask;
import com.simba.common.log.LogUtil;
import com.simba.common.log.LoggerExecutor;
import com.simba.common.processor.BaseProcessor;
import com.simba.common.processor.ProcessorAttachInfo;
import com.simba.common.utils.StringUtil;
import java.io.IOException;
import java.util.LinkedList;
import java.util.List;
import org.jboss.netty.channel.Channel;
import org.jboss.netty.handler.timeout.IdleStateEvent;

public class FrameProcessor
extends BaseProcessor {
    private final ChannelManager channelManager;
    private final RequestHandler frameContentDecoder;
    private final List<String> headerFilters = new LinkedList<String>();

    public FrameProcessor(RequestHandler requestHandler, ChannelManager chManager) {
        this.frameContentDecoder = requestHandler;
        this.channelManager = chManager;
    }

    @Override
    public void onChannelConnected(Channel channel) throws Exception {
        long connectedTime = System.currentTimeMillis();
        ProcessorAttachInfo attachInfo = new ProcessorAttachInfo();
        attachInfo.setConnectedTime(connectedTime);
        attachInfo.setProcessorType("FrameProcessor");
        channel.setAttachment(attachInfo);
        this.addChannel(channel);
        this.logOnChannelConnected(channel);
        String content = "Welcome to connect to the server";
        this.channelManager.commitResponse(channel, content.getBytes(), false);
        this.frameContentDecoder.onChannelConnected(channel);
    }

    @Override
    public void onChannelDisconnected(Channel channel) throws Exception {
        this.removeChannel(channel);
        this.logOnChannelDisconnected(channel);
        this.frameContentDecoder.onChannelDisconnected(channel);
    }

    @Override
    public void onChannelIdle(Channel channel, IdleStateEvent e) throws Exception {
        this.logOnChannelIdel(channel, e);
    }

    @Override
    public void onExceptionCaught(Channel channel, Throwable cause) throws Exception {
        if (cause instanceof IOException) {
            this.logOnIOExceptionCaught(channel, cause);
        } else {
            this.logOnExceptionCaught(channel, cause);
            if (!channel.isConnected()) {
                this.removeChannel(channel);
            }
        }
    }

    @Override
    public void onMessageReceived(Channel channel, Object message) throws Exception {
        byte[] contentMsg = (byte[])message;
        this.logOnMessageReceived(channel, contentMsg);
        if (this.frameContentDecoder != null) {
            this.frameContentDecoder.handleRequest(channel, message);
        }
    }

    @Override
    public void onWriteComplete(Channel channel) throws Exception {
    }

    public void setLogHeaders(List<String> toHeaderFilters) {
        try {
            if (toHeaderFilters != null && toHeaderFilters.size() > 0) {
                this.headerFilters.addAll(toHeaderFilters);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Override
    protected void addChannel(Channel channel) {
        this.channelManager.addChannel(channel);
    }

    @Override
    protected void logOnChannelConnected(Channel channel) {
        LoggerExecutor.getInstance().execute(new LogTask(new Log4jLogger(BaseProcessor.LOG), "[FrameProcessor.logOnChannelConnected] Connection opened [" + channel.getRemoteAddress() + "], Current frame content connection count is : " + String.valueOf(this.channelManager.getChannelCount()), 3));
    }

    @Override
    protected void logOnMessageReceived(Channel channel, Object message) {
        try {
            if (GlobalParam.LOG_MODE != 3) {
                byte[] content = (byte[])message;
                String contentStr = StringUtil.byteToHexString(content);
                Boolean checkHeader = false;
                for (String header : this.headerFilters) {
                    if (!contentStr.startsWith(header)) continue;
                    checkHeader = true;
                    break;
                }
                if (checkHeader.booleanValue()) {
                    String info = "[FrameProcessor] Received from [ip:" + channel.getRemoteAddress() + "] -- " + contentStr;
                    LogUtil.LogDebug(BaseProcessor.LOG, info);
                }
            }
        }
        catch (Exception e) {
            LoggerExecutor.getInstance().execute(new LogTask(new Log4jLogger(BaseProcessor.LOG), "[FrameProcessor.logOnMessageReceived] Message received from [ip:" + channel.getRemoteAddress() + "] -- " + e.toString(), 2));
        }
        super.logOnMessageReceived(channel, message);
    }

    @Override
    protected void removeChannel(Channel channel) {
        String id = String.valueOf(channel.getId());
        this.channelManager.removeChannel(id);
    }
}

