/*
 * Decompiled with CFR 0.152.
 */
package com.simba.common.processor;

import com.simba.GlobalParam;
import com.simba.common.log.Log4jLogger;
import com.simba.common.log.LogTask;
import com.simba.common.log.LoggerExecutor;
import com.simba.common.processor.MessageProcessor;
import org.apache.log4j.Logger;
import org.jboss.netty.channel.Channel;
import org.jboss.netty.handler.timeout.IdleStateEvent;

public abstract class BaseProcessor
implements MessageProcessor {
    public static final String PROCESSOR_TYPE_DELIMITER = "DelimiterProcessor";
    public static final String PROCESSOR_TYPE_FRAME = "FrameProcessor";
    public static final String PROCESSOR_TYPE_HTTP = "HttpProcessor";
    public static final String PROCESSOR_TYPE_JSON = "JsonProcessor";
    public static final String PROCESSOR_TYPE_WEBSOCK = "WebSockProcessor";
    protected static final Logger LOG = Logger.getLogger(BaseProcessor.class);

    protected abstract void addChannel(Channel var1);

    protected void logOnChannelConnected(Channel channel) {
    }

    protected void logOnChannelDisconnected(Channel channel) {
        if (GlobalParam.LOG_MODE != 3) {
            LoggerExecutor.getInstance().execute(new LogTask(new Log4jLogger(LOG), "[BaseProcessor.logOnChannelDisconnected] Connection closed [" + channel.getRemoteAddress() + "]", 3));
        }
    }

    protected void logOnChannelIdel(Channel channel, IdleStateEvent e) {
        LoggerExecutor.getInstance().execute(new LogTask(new Log4jLogger(LOG), "[BaseProcessor.logOnChannelIdel] Connection idle [" + channel.getRemoteAddress() + "]", 2));
    }

    protected void logOnExceptionCaught(Channel channel, Throwable cause) {
        LoggerExecutor.getInstance().execute(new LogTask(new Log4jLogger(LOG), "[BaseProcessor.logOnExceptionCaught] Connection exception caught [" + channel.getRemoteAddress() + "] -- " + cause, 2));
    }

    protected void logOnIOExceptionCaught(Channel channel, Throwable cause) {
        if (GlobalParam.LOG_MODE != 3) {
            LoggerExecutor.getInstance().execute(new LogTask(new Log4jLogger(LOG), "[BaseProcessor.logOnIOExceptionCaught] Connection exception caught [" + channel.getRemoteAddress() + "] -- " + cause, 2));
        }
    }

    protected void logOnMessageReceived(Channel channel, Object message) {
    }

    protected abstract void removeChannel(Channel var1);
}

