#!/bin/bash

# output variables:
# SRS_AUTO_HEADERS_H: the auto generated header file.

SRS_AUTO_HEADERS_H="${SRS_OBJS}/srs_auto_headers.hpp"

# write user options to headers
echo "// auto generated by configure" > $SRS_AUTO_HEADERS_H
echo "#ifndef SRS_AUTO_HEADER_HPP" >> $SRS_AUTO_HEADERS_H
echo "#define SRS_AUTO_HEADER_HPP" >> $SRS_AUTO_HEADERS_H
echo "" >> $SRS_AUTO_HEADERS_H

echo "#define SRS_AUTO_BUILD_TS \"`date +%s`\"" >> $SRS_AUTO_HEADERS_H
echo "#define SRS_AUTO_BUILD_DATE \"`date \"+%Y-%m-%d %H:%M:%S\"`\"" >> $SRS_AUTO_HEADERS_H
echo "#define SRS_AUTO_UNAME \"`uname -a`\"" >> $SRS_AUTO_HEADERS_H
echo "#define SRS_AUTO_USER_CONFIGURE \"${SRS_AUTO_USER_CONFIGURE}\"" >> $SRS_AUTO_HEADERS_H
echo "#define SRS_AUTO_CONFIGURE \"${SRS_AUTO_CONFIGURE}\"" >> $SRS_AUTO_HEADERS_H
echo "" >> $SRS_AUTO_HEADERS_H

# export the preset.
if [ $SRS_OSX = YES ]; then
    echo "#define SRS_OSX" >> $SRS_AUTO_HEADERS_H
fi
if [ $SRS_X86_X64 = YES ]; then
    echo "#define SRS_X86_X64" >> $SRS_AUTO_HEADERS_H
fi
if [ $SRS_ARM_UBUNTU12 = YES ]; then
    echo "#define SRS_ARM_UBUNTU12" >> $SRS_AUTO_HEADERS_H
fi
if [ $SRS_MIPS_UBUNTU12 = YES ]; then
    echo "#define SRS_MIPS_UBUNTU12" >> $SRS_AUTO_HEADERS_H
fi
if [ $SRS_PI = YES ]; then
    echo "#define SRS_PI" >> $SRS_AUTO_HEADERS_H
fi
if [ $SRS_CUBIE = YES ]; then
    echo "#define SRS_CUBIE" >> $SRS_AUTO_HEADERS_H
fi
if [ $SRS_EXPORT_LIBRTMP_PROJECT != NO ]; then
    echo "#define SRS_EXPORT_LIBRTMP" >> $SRS_AUTO_HEADERS_H
else
    echo "#undef SRS_EXPORT_LIBRTMP" >> $SRS_AUTO_HEADERS_H
fi

echo "" >> $SRS_AUTO_HEADERS_H

#####################################################################################
# generate auto headers file, depends on the finished of options.sh
#####################################################################################
# write to source file
if [ $SRS_CROSS_BUILD = YES ]; then
    echo "cc=$SrsArmCC gcc=$SrsArmGCC g++=$SrsArmCXX ar=$SrsArmAR ld=$SrsArmLD randlib=$SrsArmRANDLIB"
    echo "#define SRS_AUTO_EMBEDED_TOOL_CHAIN \"cc=$SrsArmCC gcc=$SrsArmGCC g++=$SrsArmCXX ar=$SrsArmAR ld=$SrsArmLD randlib=$SrsArmRANDLIB\"" >> $SRS_AUTO_HEADERS_H
else
    echo "#define SRS_AUTO_EMBEDED_TOOL_CHAIN \"normal x86/x64 gcc\"" >> $SRS_AUTO_HEADERS_H
fi
echo "" >> $SRS_AUTO_HEADERS_H

# auto headers in depends.
if [ $SRS_HTTP_CORE = YES ]; then
    echo "#define SRS_AUTO_HTTP_CORE" >> $SRS_AUTO_HEADERS_H
else
    echo "#undef SRS_AUTO_HTTP_CORE" >> $SRS_AUTO_HEADERS_H
fi

if [ $SRS_HTTP_SERVER = YES ]; then
    echo "#define SRS_AUTO_HTTP_SERVER" >> $SRS_AUTO_HEADERS_H
else
    echo "#undef SRS_AUTO_HTTP_SERVER" >> $SRS_AUTO_HEADERS_H
fi

if [ $SRS_STREAM_CASTER = YES ]; then
    echo "#define SRS_AUTO_STREAM_CASTER" >> $SRS_AUTO_HEADERS_H
else
    echo "#undef SRS_AUTO_STREAM_CASTER" >> $SRS_AUTO_HEADERS_H
fi

if [ $SRS_HTTP_API = YES ]; then
    echo "#define SRS_AUTO_HTTP_API" >> $SRS_AUTO_HEADERS_H
else
    echo "#undef SRS_AUTO_HTTP_API" >> $SRS_AUTO_HEADERS_H
fi

if [ $SRS_NGINX = YES ]; then
    echo "#define SRS_AUTO_NGINX" >> $SRS_AUTO_HEADERS_H
else
    echo "#undef SRS_AUTO_NGINX" >> $SRS_AUTO_HEADERS_H
fi

if [ $SRS_DVR = YES ]; then
    echo "#define SRS_AUTO_DVR" >> $SRS_AUTO_HEADERS_H
else
    echo "#undef SRS_AUTO_DVR" >> $SRS_AUTO_HEADERS_H
fi

if [ $SRS_HLS = YES ]; then
    echo "#define SRS_AUTO_HLS" >> $SRS_AUTO_HEADERS_H
else
    echo "#undef SRS_AUTO_HLS" >> $SRS_AUTO_HEADERS_H
fi

if [ $SRS_HDS = YES ]; then
    echo "#define SRS_AUTO_HDS" >> $SRS_AUTO_HEADERS_H
else
    echo "#undef SRS_AUTO_HDS" >> $SRS_AUTO_HEADERS_H
fi

if [ $SRS_HTTP_CALLBACK = YES ]; then
    echo "#define SRS_AUTO_HTTP_CALLBACK" >> $SRS_AUTO_HEADERS_H
else
    echo "#undef SRS_AUTO_HTTP_CALLBACK" >> $SRS_AUTO_HEADERS_H
fi

if [ $SRS_SSL = YES ]; then
    echo "#define SRS_AUTO_SSL" >> $SRS_AUTO_HEADERS_H
else
    echo "#undef SRS_AUTO_SSL" >> $SRS_AUTO_HEADERS_H
fi

if [ $SRS_MEM_WATCH = YES ]; then
    echo "#define SRS_AUTO_MEM_WATCH" >> $SRS_AUTO_HEADERS_H
else
    echo "#undef SRS_AUTO_MEM_WATCH" >> $SRS_AUTO_HEADERS_H
fi

# whether compile ffmpeg tool
if [ $SRS_FFMPEG_TOOL = YES ]; then
    echo "#define SRS_AUTO_FFMPEG_TOOL" >> $SRS_AUTO_HEADERS_H
else
    echo "#undef SRS_AUTO_FFMPEG_TOOL" >> $SRS_AUTO_HEADERS_H
fi

# whatever the FFMPEG tools, if transcode and ingest specified,
# srs always compile the FFMPEG tool stub which used to start the FFMPEG process.
if [ $SRS_FFMPEG_STUB = YES ]; then
    echo "#define SRS_AUTO_FFMPEG_STUB" >> $SRS_AUTO_HEADERS_H
else
    echo "#undef SRS_AUTO_FFMPEG_STUB" >> $SRS_AUTO_HEADERS_H
fi

if [ $SRS_TRANSCODE = YES ]; then
    echo "#define SRS_AUTO_TRANSCODE" >> $SRS_AUTO_HEADERS_H
else
    echo "#undef SRS_AUTO_TRANSCODE" >> $SRS_AUTO_HEADERS_H
fi

if [ $SRS_INGEST = YES ]; then
    echo "#define SRS_AUTO_INGEST" >> $SRS_AUTO_HEADERS_H
else
    echo "#undef SRS_AUTO_INGEST" >> $SRS_AUTO_HEADERS_H
fi

# for statistic.
if [ $SRS_STAT = YES ]; then
    echo "#define SRS_AUTO_STAT" >> $SRS_AUTO_HEADERS_H
else
    echo "#undef SRS_AUTO_STAT" >> $SRS_AUTO_HEADERS_H
fi

if [ $SRS_GPERF = YES ]; then
    echo "#define SRS_AUTO_GPERF" >> $SRS_AUTO_HEADERS_H
else
    echo "#undef SRS_AUTO_GPERF" >> $SRS_AUTO_HEADERS_H
fi
if [ $SRS_GPERF_MC = YES ]; then
    echo "#define SRS_AUTO_GPERF_MC" >> $SRS_AUTO_HEADERS_H
else
    echo "#undef SRS_AUTO_GPERF_MC" >> $SRS_AUTO_HEADERS_H
fi
if [ $SRS_GPERF_MP = YES ]; then
    echo "#define SRS_AUTO_GPERF_MP" >> $SRS_AUTO_HEADERS_H
else
    echo "#undef SRS_AUTO_GPERF_MP" >> $SRS_AUTO_HEADERS_H
fi
if [ $SRS_GPERF_CP = YES ]; then
    echo "#define SRS_AUTO_GPERF_CP" >> $SRS_AUTO_HEADERS_H
else
    echo "#undef SRS_AUTO_GPERF_CP" >> $SRS_AUTO_HEADERS_H
fi

#####################################################################################
# for embeded.
#####################################################################################
if [ $SRS_CROSS_BUILD = YES ]; then
    echo "#define SRS_AUTO_EMBEDED_CPU" >> $SRS_AUTO_HEADERS_H
else
    echo "#undef SRS_AUTO_EMBEDED_CPU" >> $SRS_AUTO_HEADERS_H
fi

# arm
if [ $SRS_ARM_UBUNTU12 = YES ]; then
    echo "#define SRS_AUTO_ARM_UBUNTU12" >> $SRS_AUTO_HEADERS_H
else
    echo "#undef SRS_AUTO_ARM_UBUNTU12" >> $SRS_AUTO_HEADERS_H
fi

# mips
if [ $SRS_MIPS_UBUNTU12 = YES ]; then
    echo "#define SRS_AUTO_MIPS_UBUNTU12" >> $SRS_AUTO_HEADERS_H
else
    echo "#undef SRS_AUTO_MIPS_UBUNTU12" >> $SRS_AUTO_HEADERS_H
fi

echo "" >> $SRS_AUTO_HEADERS_H
# for log level compile settings
if [ $SRS_LOG_VERBOSE = YES ]; then
    echo "#define SRS_AUTO_VERBOSE" >> $SRS_AUTO_HEADERS_H
else
    echo "#undef SRS_AUTO_VERBOSE" >> $SRS_AUTO_HEADERS_H
fi
if [ $SRS_LOG_INFO = YES ]; then
    echo "#define SRS_AUTO_INFO" >> $SRS_AUTO_HEADERS_H
else
    echo "#undef SRS_AUTO_INFO" >> $SRS_AUTO_HEADERS_H
fi
if [ $SRS_LOG_TRACE = YES ]; then
    echo "#define SRS_AUTO_TRACE" >> $SRS_AUTO_HEADERS_H
else
    echo "#undef SRS_AUTO_TRACE" >> $SRS_AUTO_HEADERS_H
fi

# prefix
echo "" >> $SRS_AUTO_HEADERS_H
echo "#define SRS_AUTO_PREFIX \"${SRS_PREFIX}\"" >> $SRS_AUTO_HEADERS_H

echo "" >> $SRS_AUTO_HEADERS_H

#####################################################################################
# generated the contributors from AUTHORS.txt
#####################################################################################
SRS_CONSTRIBUTORS=`cat ../AUTHORS.txt|grep "*"|awk '{print $2}'`
echo "#define SRS_AUTO_CONSTRIBUTORS \"\\" >> $SRS_AUTO_HEADERS_H
for CONTRIBUTOR in $SRS_CONSTRIBUTORS; do
    echo "${CONTRIBUTOR} \\" >> $SRS_AUTO_HEADERS_H
done
echo "\"" >> $SRS_AUTO_HEADERS_H

# new empty line to auto headers file.
echo "" >> $SRS_AUTO_HEADERS_H

# auto header EOF.
echo "#endif" >> $SRS_AUTO_HEADERS_H
echo "" >> $SRS_AUTO_HEADERS_H

