#!/bin/bash
DIR="$( cd "$( dirname "$0"  )" && pwd  )"
cd $DIR

PORT=23333
WEBDIR="dist"
PARAM=$1

if [ "${PARAM}x" != "x" ];then
	WEBDIR=${PARAM}
	echo "USING USER SPECIFIED DIR:${WEBDIR}"
fi


if [ "`lsof -t -i:${PORT}`x" != "x" ];then
	echo "##########################"
        echo "#                        #"
        echo "#   Service is running   #"
        echo "#                        #"
        echo "##########################"
else
	echo "#########################"
	echo "#                       #"
	echo "#   Start Web Service   #"
	echo "#                       #"
	echo "#########################"
	#echo "${DIR}/${WEBDIR}"
	nohup serve -p ${PORT} -S ${DIR}/${WEBDIR} >> ${DIR}/logs/web_log.log 2>&1  &
fi

