/*
 * Decompiled with CFR 0.152.
 */
package com.simba.services.module.util;

import java.security.SecureRandom;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.UUID;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UUIDUtils {
    private static final Logger log = LoggerFactory.getLogger(UUIDUtils.class);
    private static final String LETTERS = "ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz";
    private static final SecureRandom random = new SecureRandom();

    public static String generate(int length) {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < length; ++i) {
            int index = random.nextInt(LETTERS.length());
            sb.append(LETTERS.charAt(index));
        }
        return sb.toString();
    }

    public static String createTimeUUID() {
        String timeUUID = "";
        try {
            String uuidStr = UUID.randomUUID().toString().substring(0, 8).toUpperCase();
            String currentTime = new SimpleDateFormat("yyyyMMddHHmmssSSS").format(new Date());
            timeUUID = currentTime + "-" + uuidStr;
        }
        catch (Exception e) {
            timeUUID = UUID.randomUUID().toString().toUpperCase().replace("-", "");
            log.error("catch Exception:{}", (Object)e.toString());
        }
        return timeUUID;
    }
}

