/*
 * Decompiled with CFR 0.152.
 */
package com.simba.services.module.util;

import com.simba.services.common.utils.DateUtils;
import com.simba.services.module.util.SimpleHttpBatchService;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.CountDownLatch;
import javax.annotation.Resource;
import okhttp3.Call;
import okhttp3.Callback;
import okhttp3.MediaType;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.RequestBody;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class SimpleHttpBatchService {
    private static final Logger log = LoggerFactory.getLogger(SimpleHttpBatchService.class);
    private static final MediaType JSON = MediaType.get((String)"application/json");
    @Resource
    private OkHttpClient httpClient;

    public BatchResult executeBatch(String httpUrl, List<String> bodies, int maxRetries, boolean isPrintLog) {
        String strRequest = bodies.toString();
        String requestTime = DateUtils.getCurrentTime();
        List validationErrors = this.validateParameters(httpUrl, bodies, maxRetries);
        if (!validationErrors.isEmpty()) {
            return this.createValidationErrorResult(bodies, validationErrors);
        }
        int requestCount = bodies.size();
        CopyOnWriteArrayList<Object> results = new CopyOnWriteArrayList<Object>(Collections.nCopies(requestCount, null));
        CountDownLatch completionLatch = new CountDownLatch(requestCount);
        ArrayList systemErrorLog = new ArrayList();
        for (int requestIndex = 0; requestIndex < requestCount; ++requestIndex) {
            this.processSingleRequest(httpUrl, bodies.get(requestIndex), requestIndex, results, completionLatch, systemErrorLog, maxRetries);
        }
        this.awaitCompletion(completionLatch, systemErrorLog);
        String responseTime = DateUtils.getCurrentTime();
        BatchResult batchResult = new BatchResult(results, systemErrorLog);
        if (isPrintLog) {
            log.info("[executeBatchPost] requestTime[{}], responseTime[{}], httpUrl[{}], request[{}], response[{}]", new Object[]{requestTime, responseTime, httpUrl, strRequest, batchResult});
        }
        return batchResult;
    }

    private void processSingleRequest(String url, String requestBody, int requestIndex, List<RequestResult> results, CountDownLatch latch, List<String> errorCollector, int maxRetries) {
        try {
            Request request = this.buildHttpRequest(url, requestBody);
            this.executeAsyncWithRetry(request, requestIndex, results, latch, errorCollector, maxRetries);
        }
        catch (IllegalArgumentException e) {
            this.handleRequestBuildFailure(requestIndex, results, latch, errorCollector, (Exception)e);
        }
    }

    private Request buildHttpRequest(String url, String body) {
        return new Request.Builder().url(url).post(RequestBody.create((MediaType)JSON, (String)body)).build();
    }

    private void executeAsyncWithRetry(Request request, int requestIndex, List<RequestResult> results, CountDownLatch latch, List<String> errorCollector, int maxRetries) {
        Call[] currentCall = new Call[]{this.httpClient.newCall(request)};
        currentCall[0].enqueue((Callback)new /* Unavailable Anonymous Inner Class!! */);
    }

    private List<String> validateParameters(String url, List<String> bodies, int maxRetries) {
        ArrayList<String> errors = new ArrayList<String>(3);
        if (url == null || url.isEmpty()) {
            errors.add("URL is required");
        }
        if (bodies == null) {
            errors.add("Request bodies cannot be null");
        }
        if (maxRetries < 0) {
            errors.add("Retry count cannot be negative");
        }
        return errors;
    }

    private BatchResult createValidationErrorResult(List<String> bodies, List<String> errors) {
        int size = bodies != null ? bodies.size() : 0;
        ArrayList<RequestResult> errorResults = new ArrayList<RequestResult>(size);
        String errorMessage = "Parameter validation failed: " + String.join((CharSequence)", ", errors);
        for (int i = 0; i < size; ++i) {
            errorResults.add(new RequestResult(i, false, null, errorMessage, 0));
        }
        return new BatchResult(errorResults, errors);
    }

    private void handleRequestBuildFailure(int index, List<RequestResult> results, CountDownLatch latch, List<String> errorCollector, Exception cause) {
        results.set(index, new RequestResult(index, false, null, "Request construction failed: " + cause.getMessage(), 0));
        latch.countDown();
        errorCollector.add("Request " + index + " initialization failed");
    }

    private void awaitCompletion(CountDownLatch latch, List<String> errorCollector) {
        try {
            latch.await();
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            errorCollector.add("Processing interrupted: " + e.getMessage());
        }
    }

    static /* synthetic */ OkHttpClient access$000(SimpleHttpBatchService x0) {
        return x0.httpClient;
    }
}

