/*
 * Decompiled with CFR 0.152.
 */
package com.simba.services.module.util;

import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.data.redis.core.Cursor;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.data.redis.core.ScanOptions;
import org.springframework.stereotype.Component;

@Component
public class RedisServices {
    private static final Logger log = LoggerFactory.getLogger(RedisServices.class);
    @Resource
    private RedisTemplate<String, Object> redisTemplate;
    private static final long timeout = 24L;
    private static final int count = 1000;
    private static final TimeUnit timeUnit = TimeUnit.HOURS;

    public Set<String> getKeysByPatternUsingScan(String pattern) {
        return this.getKeysByPatternUsingScan(pattern, 1000);
    }

    public Set<String> getKeysByPatternUsingScan(String pattern, int count) {
        HashSet<String> keys = new HashSet<String>();
        ScanOptions options = ScanOptions.scanOptions().match(pattern).count((long)count).build();
        this.redisTemplate.execute(connection -> {
            try (Cursor cursor = connection.scan(options);){
                while (cursor.hasNext()) {
                    keys.add(new String((byte[])cursor.next()));
                }
            }
            return null;
        });
        return keys;
    }

    public Object getKey(String key) {
        if (key == null || key.isEmpty()) {
            return null;
        }
        return this.redisTemplate.opsForValue().get((Object)key);
    }

    public boolean isKey(String key) {
        if (key == null || key.isEmpty()) {
            return false;
        }
        return Boolean.TRUE.equals(this.redisTemplate.hasKey((Object)key));
    }

    public void setValue(String key, String value) {
        this.redisTemplate.opsForValue().set((Object)key, (Object)value);
    }

    public boolean setValue(String key, String value, long timeout, TimeUnit timeUnit) {
        try {
            this.redisTemplate.opsForValue().set((Object)key, (Object)value, timeout, timeUnit);
            return true;
        }
        catch (Exception e) {
            log.error("[RedisServices] Redis\u4fdd\u5b58\u6570\u636e\u5931\u8d25, key: {}", (Object)key, (Object)e);
            return false;
        }
    }

    public void setValueByTimeOut(String key, String value) {
        this.redisTemplate.opsForValue().set((Object)key, (Object)value, 24L, timeUnit);
    }

    public void removeKey(String key) {
        if (key == null || key.isEmpty()) {
            return;
        }
        this.redisTemplate.delete((Object)key);
    }
}

