/*
 * Decompiled with CFR 0.152.
 */
package com.simba.services.module.util;

import java.util.UUID;
import org.springframework.stereotype.Component;

@Component
public class RedisKeyTools {
    private static final String PACKET_OFF_KEY = "simba:jt:packet-infos:";
    private static final String UPLOAD_KEY = "simba:jt:upload:";
    private static final String CACHE_UPLOAD_KEY = "simba:jt:cache:";

    public String createPacketOffKey(String key) {
        if (key == null || key.isEmpty()) {
            return "simba:jt:packet-infos:Auto:" + UUID.randomUUID().toString().replace("-", "");
        }
        return PACKET_OFF_KEY + key;
    }

    public String createUploadKey(String key) {
        if (key == null || key.isEmpty()) {
            return "simba:jt:upload:Auto:" + UUID.randomUUID().toString().replace("-", "");
        }
        return UPLOAD_KEY + key;
    }

    public String createCacheUploadKey(String key) {
        if (key == null || key.isEmpty()) {
            return "simba:jt:cache:Auto:" + UUID.randomUUID().toString().replace("-", "");
        }
        return CACHE_UPLOAD_KEY + key;
    }

    public String getUploadKey() {
        return UPLOAD_KEY;
    }
}

