/*
 * Decompiled with CFR 0.152.
 */
package com.simba.services.module.handler.task;

import com.simba.services.common.utils.spring.SpringUtils;
import com.simba.services.module.business.config.BasicConfigManger;
import com.simba.services.module.business.database.ConfigBasic.entity.ConfigBasicEntity;
import com.simba.services.module.business.database.ConfigSoterBasic.entity.ConfigSorterBasicEntity;
import com.simba.services.module.business.database.DatabaseManagerByBasicConfig;
import com.simba.services.module.business.database.DatabaseManagerBySorterBasicConfig;
import java.util.List;
import java.util.Objects;
import java.util.function.Consumer;
import java.util.function.Supplier;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.annotation.Configuration;
import org.springframework.scheduling.annotation.EnableScheduling;
import org.springframework.scheduling.annotation.Scheduled;

@Configuration
@EnableScheduling
public class SyncBasicConfigTask {
    private static final Logger log = LoggerFactory.getLogger(SyncBasicConfigTask.class);

    @Scheduled(initialDelay=1000L, fixedDelay=5000L)
    public void doHandle() {
        try {
            try {
                this.doSyncBasicConfig();
                this.doSyncSorterBasicConfig();
            }
            catch (Exception e) {
                log.error("[SyncBasicConfigTask.doHandle] Catch on exception:{}", (Object)e.getMessage());
            }
        }
        catch (Exception e) {
            log.error("[SyncBasicConfigTask] Catch on exception:{}", (Object)e.getMessage());
        }
    }

    private void doSyncSorterBasicConfig() {
        List list = ((DatabaseManagerBySorterBasicConfig)SpringUtils.getBean(DatabaseManagerBySorterBasicConfig.class)).queryBasicConfigInfo(null);
        BasicConfigManger configManager = (BasicConfigManger)SpringUtils.getBean(BasicConfigManger.class);
        for (ConfigSorterBasicEntity entity : list) {
            switch (entity.getBasicKey()) {
                case "sortPlanCode": {
                    this.syncStringConfig(entity.getBasicValue(), () -> ((BasicConfigManger)configManager).getSortPlanCode(), arg_0 -> ((BasicConfigManger)configManager).setSortPlanCode(arg_0), entity.getBasicKey());
                    break;
                }
            }
        }
    }

    private void doSyncBasicConfig() {
        List list = ((DatabaseManagerByBasicConfig)SpringUtils.getBean(DatabaseManagerByBasicConfig.class)).queryBasicConfigInfo(null);
        BasicConfigManger configManager = (BasicConfigManger)SpringUtils.getBean(BasicConfigManger.class);
        for (ConfigBasicEntity entity : list) {
            String basicKey = entity.getBasicKey();
            String basicValue = entity.getBasicValue();
            if (basicValue == null || basicKey.equals("none")) continue;
            switch (basicKey) {
                case "random_param": {
                    this.syncStringConfig(basicValue, () -> ((BasicConfigManger)configManager).getRandom_param(), arg_0 -> ((BasicConfigManger)configManager).setRandom_param(arg_0), basicKey);
                    break;
                }
                case "http_request_print_switch": {
                    this.syncBooleanConfig(basicValue, () -> ((BasicConfigManger)configManager).isHttp_request_print_switch(), arg_0 -> ((BasicConfigManger)configManager).setHttp_request_print_switch(arg_0), basicKey);
                    break;
                }
                case "appKey": {
                    this.syncStringConfig(basicValue, () -> ((BasicConfigManger)configManager).getAppKey(), arg_0 -> ((BasicConfigManger)configManager).setAppKey(arg_0), basicKey);
                    break;
                }
                case "appSecret": {
                    this.syncStringConfig(basicValue, () -> ((BasicConfigManger)configManager).getAppSecret(), arg_0 -> ((BasicConfigManger)configManager).setAppSecret(arg_0), basicKey);
                    break;
                }
                case "small_data_upload_url": {
                    this.syncStringConfig(basicValue, () -> ((BasicConfigManger)configManager).getSmallDataUploadUrl(), arg_0 -> ((BasicConfigManger)configManager).setSmallDataUploadUrl(arg_0), basicKey);
                    break;
                }
                case "retry_number": {
                    this.syncIntConfig(basicValue, () -> ((BasicConfigManger)configManager).getRetryNumber(), arg_0 -> ((BasicConfigManger)configManager).setRetryNumber(arg_0), basicKey);
                    break;
                }
                case "network_code": {
                    this.syncStringConfig(basicValue, () -> ((BasicConfigManger)configManager).getNetworkCode(), arg_0 -> ((BasicConfigManger)configManager).setNetworkCode(arg_0), basicKey);
                    break;
                }
                case "account": {
                    this.syncStringConfig(basicValue, () -> ((BasicConfigManger)configManager).getAccount(), arg_0 -> ((BasicConfigManger)configManager).setAccount(arg_0), basicKey);
                    break;
                }
                case "cross_mac": {
                    this.syncStringConfig(basicValue, () -> ((BasicConfigManger)configManager).getCrossMac(), arg_0 -> ((BasicConfigManger)configManager).setCrossMac(arg_0), basicKey);
                    break;
                }
                case "machine_code": {
                    this.syncStringConfig(basicValue, () -> ((BasicConfigManger)configManager).getMachineCode(), arg_0 -> ((BasicConfigManger)configManager).setMachineCode(arg_0), basicKey);
                    break;
                }
                case "upload_limit": {
                    this.syncIntConfig(basicValue, () -> ((BasicConfigManger)configManager).getUploadLimit(), arg_0 -> ((BasicConfigManger)configManager).setUploadLimit(arg_0), basicKey);
                    break;
                }
                case "is_data_upload": {
                    this.syncBooleanConfig(basicValue, () -> ((BasicConfigManger)configManager).isDataUpload(), arg_0 -> ((BasicConfigManger)configManager).setDataUpload(arg_0), basicKey);
                    break;
                }
            }
        }
    }

    private void syncStringConfig(String newValue, Supplier<String> getter, Consumer<String> setter, String configName) {
        try {
            String currentValue = getter.get();
            if (!Objects.equals(currentValue, newValue)) {
                log.info("[SyncBasicConfigTask] String value:{} Change.[current:{}]", (Object)configName, (Object)newValue);
                setter.accept(newValue);
            }
        }
        catch (Exception e) {
            log.error("[SyncBasicConfigTask] Invalid String value for {}: {}", (Object)configName, (Object)newValue);
        }
    }

    private void syncBooleanConfig(String newValue, Supplier<Boolean> getter, Consumer<Boolean> setter, String configName) {
        try {
            boolean boolValue = "true".equals(newValue);
            boolean currentValue = getter.get();
            if (currentValue != boolValue) {
                log.info("[SyncBasicConfigTask] Boolean value:{} Change.[current:{}]", (Object)configName, (Object)boolValue);
                setter.accept(boolValue);
            }
        }
        catch (Exception e) {
            log.error("[SyncBasicConfigTask] Invalid Boolean value for {}: {}", (Object)configName, (Object)newValue);
        }
    }

    private void syncIntConfig(String newValue, Supplier<Integer> getter, Consumer<Integer> setter, String configName) {
        try {
            int intValue = Integer.parseInt(newValue);
            int currentValue = getter.get();
            if (currentValue != intValue) {
                log.info("[SyncBasicConfigTask] int value: {} Change.[current:{}]", (Object)configName, (Object)intValue);
                setter.accept(intValue);
            }
        }
        catch (NumberFormatException e) {
            log.error("[SyncBasicConfigTask] Invalid integer value for {}: {}", (Object)configName, (Object)newValue);
        }
    }
}

