/*
 * Decompiled with CFR 0.152.
 */
package com.simba.services.module.handler.manager;

import com.alibaba.fastjson2.JSONObject;
import com.github.pagehelper.util.StringUtil;
import com.simba.services.common.utils.DateUtils;
import com.simba.services.common.utils.spring.SpringUtils;
import com.simba.services.module.business.config.BasicConfigManger;
import com.simba.services.module.business.database.DatabaseManagerByRecordPacketResult;
import com.simba.services.module.business.database.RecordPacketResult.entity.RecordPacketResultEntity;
import com.simba.services.module.handler.manager.PlatManager;
import com.simba.services.module.handler.web.RequestToJt;
import com.simba.services.module.util.MD5Util;
import java.math.BigDecimal;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import javax.annotation.PostConstruct;
import javax.annotation.Resource;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeansException;
import org.springframework.stereotype.Component;

@Component
public class UploadDataManager {
    private static final Logger log = LoggerFactory.getLogger(UploadDataManager.class);
    private final ConcurrentHashMap<String, String> dataUploadHashMap = new ConcurrentHashMap();
    @Resource
    private BasicConfigManger basicConfigManger;
    @Resource
    private PlatManager platManager;
    @Resource
    private DatabaseManagerByRecordPacketResult databaseManagerByRecordPacketResult;

    @PostConstruct
    private void init() {
    }

    public void uploadData() {
        block16: {
            try {
                String uploadJsonStr;
                boolean isDataUpload = ((BasicConfigManger)SpringUtils.getBean(BasicConfigManger.class)).isDataUpload();
                if (!isDataUpload) {
                    log.info("[UploadDataManager.uploadData] Data upload is disabled!");
                    return;
                }
                String upload = "0";
                Integer retryNumber = this.basicConfigManger.getRetryNumber();
                List list = this.databaseManagerByRecordPacketResult.queryPacketResult(upload, retryNumber);
                ArrayList<Long> errorList = new ArrayList<Long>();
                ArrayList<Long> normalList = new ArrayList<Long>();
                ArrayList<Long> renewList = new ArrayList<Long>();
                ConcurrentHashMap<String, RecordPacketResultEntity> uploadData = new ConcurrentHashMap<String, RecordPacketResultEntity>();
                for (RecordPacketResultEntity entity : list) {
                    String billCode = entity.getBillCode();
                    if (billCode == null || billCode.isEmpty()) {
                        errorList.add(entity.getId());
                        continue;
                    }
                    normalList.add(entity.getId());
                    uploadData.put(billCode, entity);
                }
                if (!errorList.isEmpty()) {
                    this.databaseManagerByRecordPacketResult.updateStatusByIds(errorList, Integer.valueOf(-1));
                }
                if (uploadData.isEmpty() || (uploadJsonStr = this.handleData(uploadData)) == null || uploadJsonStr.isEmpty()) break block16;
                String appKey = ((BasicConfigManger)SpringUtils.getBean(BasicConfigManger.class)).getAppKey();
                String appSecret = ((BasicConfigManger)SpringUtils.getBean(BasicConfigManger.class)).getAppSecret();
                String timestamp = String.valueOf(System.currentTimeMillis());
                String token = this.getToken(timestamp, appKey, appSecret, uploadJsonStr);
                HashMap<String, String> headMap = new HashMap<String, String>();
                headMap.put("timestamp", timestamp);
                headMap.put("appKey", appKey);
                headMap.put("token", token);
                String arrivalUploadUrl = ((BasicConfigManger)SpringUtils.getBean(BasicConfigManger.class)).getSmallDataUploadUrl();
                String response = ((RequestToJt)SpringUtils.getBean(RequestToJt.class)).requestJtData(arrivalUploadUrl, uploadJsonStr, headMap, true);
                if (response == null || response.isEmpty()) {
                    log.error("[UploadDataManager.uploadData] Request Data fail!");
                    break block16;
                }
                try {
                    JSONObject parseObject = JSONObject.parseObject((String)response);
                    if (parseObject == null) {
                        log.error("[UploadDataManager.uploadData] Parse Object fail!");
                        return;
                    }
                    int code = parseObject.getInteger("code");
                    if (code == 1) {
                        boolean status = this.databaseManagerByRecordPacketResult.updateStatusByIds(normalList, Integer.valueOf(1));
                        if (!status) {
                            log.error("[UploadDataManager.uploadData] Update Status fail!");
                        }
                    } else {
                        JSONObject msg = parseObject.getJSONObject("msg");
                        for (String key : msg.keySet()) {
                            RecordPacketResultEntity entity;
                            if (key == null || key.isEmpty() || (entity = (RecordPacketResultEntity)uploadData.get(key)) == null) continue;
                            Long id = entity.getId();
                            renewList.add(id);
                            normalList.remove(id);
                        }
                        if (!renewList.isEmpty()) {
                            this.databaseManagerByRecordPacketResult.updateStatusByIds(renewList, Integer.valueOf(0));
                        }
                        if (!normalList.isEmpty()) {
                            this.databaseManagerByRecordPacketResult.updateStatusByIds(normalList, Integer.valueOf(1));
                        }
                    }
                }
                catch (Exception e) {
                    log.error("[UploadDataManager.uploadData] Parse Object! Catch on exception:{}", (Object)e.getMessage());
                }
            }
            catch (BeansException e) {
                log.error("[UploadDataManager.uploadData] Catch on exception:{}", (Object)e.getMessage());
            }
        }
    }

    private String getToken(String timestamp, String appKey, String appSecret, String uploadJsonStr) {
        String input = appSecret + timestamp + uploadJsonStr;
        return MD5Util.md5AndBase64((String)input);
    }

    private String handleData(ConcurrentHashMap<String, RecordPacketResultEntity> uploadData) {
        LinkedList<JSONObject> packageCodes = new LinkedList<JSONObject>();
        for (RecordPacketResultEntity entity : uploadData.values()) {
            JSONObject packObjs = new JSONObject();
            packObjs.put((Object)"waybillNo", (Object)entity.getBillCode());
            packObjs.put((Object)"networkCode", (Object)this.basicConfigManger.getNetworkCode());
            packObjs.put((Object)"scanTime", (Object)DateUtils.dateTimeSS((Date)entity.getScanTime()));
            packObjs.put((Object)"userNum", (Object)this.basicConfigManger.getAccount());
            int serverErrorCode = entity.getServerErrorCode();
            int uploadResult = serverErrorCode == 0 || serverErrorCode == 111 || serverErrorCode == 997 ? 1 : 2;
            packObjs.put((Object)"uploadResult", (Object)uploadResult);
            packObjs.put((Object)"crossBeltMac", (Object)this.basicConfigManger.getCrossMac());
            String platId = entity.getPlatId();
            packObjs.put((Object)"supplyDeskCode", (Object)this.getPlatCode(platId, entity.getLayer()));
            packObjs.put((Object)"supplyDeskMac", (Object)this.platManager.getPlatMac(platId));
            String time = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").format(new Date().getTime());
            packObjs.put((Object)"uploadTime", (Object)time);
            if (entity.getPlanCode() != null && entity.getPlanCode().length() > 4) {
                packObjs.put((Object)"sortingPlanCode", (Object)entity.getPlanCode());
            } else {
                packObjs.put((Object)"sortingPlanCode", (Object)this.basicConfigManger.getSortPlanCode());
            }
            if (entity.getStoMode().contains("dep")) {
                packObjs.put((Object)"operateType", (Object)1);
            } else {
                packObjs.put((Object)"operateType", (Object)0);
            }
            packObjs.put((Object)"equipmentCode", (Object)this.basicConfigManger.getMachineCode());
            packObjs.put((Object)"equipmentLayer", (Object)entity.getLayer());
            packObjs.put((Object)"gridNo", (Object)entity.getDroppedSlot());
            packObjs.put((Object)"packageNo", (Object)entity.getPackageCode());
            packObjs.put((Object)"fallTime", (Object)DateUtils.dateTimeSS((Date)entity.getRecordDate()));
            packObjs.put((Object)"nextStation", (Object)entity.getSiteCode());
            packObjs.put((Object)"cyclesNum", (Object)BigDecimal.valueOf(entity.getTurnNumber().floatValue()));
            packObjs.put((Object)"carNum", (Object)entity.getCarId());
            packObjs.put((Object)"gridCode", (Object)entity.getGridCode());
            String weight = StringUtil.isEmpty((String)String.valueOf(entity.getWeight())) ? "0" : String.valueOf(entity.getWeight());
            packObjs.put((Object)"weight", (Object)weight);
            packageCodes.add(packObjs);
        }
        return ((Object)packageCodes).toString();
    }

    public String getPlatCode(String platId, int layer) {
        String res = "GJ-";
        if (platId.length() == 1) {
            platId = "0" + platId;
        }
        res = res + this.basicConfigManger.getNetworkCode() + "-" + this.basicConfigManger.getMachineCode() + "-" + layer + "-" + platId;
        return res;
    }

    private String processScanTime(String scanTime) {
        if (StringUtils.isBlank((CharSequence)scanTime)) {
            return DateUtils.getTime();
        }
        if (scanTime.length() > 19 && scanTime.contains(".")) {
            return scanTime.substring(0, 19);
        }
        return scanTime;
    }
}

