/*
 * Decompiled with CFR 0.152.
 */
package com.simba.services.module.handler.manager;

import com.simba.services.module.business.config.SorterConfiguration;
import java.util.concurrent.ConcurrentSkipListMap;
import javax.annotation.PostConstruct;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class PlatManager {
    private static final Logger log = LoggerFactory.getLogger(PlatManager.class);
    private final ConcurrentSkipListMap<String, String> platMacMap = new ConcurrentSkipListMap();
    @Resource
    private SorterConfiguration sorterConfiguration;

    @PostConstruct
    private void init() {
        try {
            this.initPlatConfig();
        }
        catch (Exception e) {
            log.error("[PlatManager.init] : {}", (Object)e.getMessage());
        }
    }

    private void initPlatConfig() {
        for (SorterConfiguration.plat platValue : this.sorterConfiguration.getPlats()) {
            String id = platValue.getId();
            String platId = platValue.getPlatId();
            String platMac = platValue.getPlatMac();
            this.platMacMap.put(platId, platMac);
        }
        String info = "[PlatManager.init] Current plat number : [" + this.platMacMap.size() + "]";
        log.debug(info);
        log.info(info);
    }

    public String getPlatMac(String platId) {
        if (platId == null) {
            return "";
        }
        return (String)this.platMacMap.get(platId);
    }
}

