/*
 * Decompiled with CFR 0.152.
 */
package com.simba.services.module.business.database;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.simba.services.module.business.database.RecordPacketResult.entity.RecordPacketResultEntity;
import com.simba.services.module.business.database.RecordPacketResult.services.IRecordPacketResultService;
import java.time.LocalDateTime;
import java.util.List;
import javax.annotation.Resource;
import org.springframework.stereotype.Component;

@Component
public class DatabaseManagerByRecordPacketResult {
    @Resource
    private IRecordPacketResultService iRecordPacketResultService;

    public List<RecordPacketResultEntity> queryPacketResult(String upload, Integer retryCount) {
        LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
        if (upload != null && !upload.isEmpty()) {
            queryWrapper.eq(RecordPacketResultEntity::getUpload, (Object)upload);
        }
        queryWrapper.lt(RecordPacketResultEntity::getTryCount, (Object)retryCount);
        LocalDateTime oneDayAgo = LocalDateTime.now().minusDays(1L);
        queryWrapper.ge(RecordPacketResultEntity::getRecordDate, (Object)oneDayAgo);
        LocalDateTime fiveMinutesAgo = LocalDateTime.now().minusMinutes(5L);
        queryWrapper.le(RecordPacketResultEntity::getRecordDate, (Object)fiveMinutesAgo);
        queryWrapper.orderByDesc(RecordPacketResultEntity::getId);
        queryWrapper.last(" limit 50");
        return this.iRecordPacketResultService.list((Wrapper)queryWrapper);
    }

    public boolean updateStatusByIds(List<Long> ids, Integer upload) {
        if (ids == null || ids.isEmpty()) {
            return false;
        }
        LambdaUpdateWrapper updateWrapper = new LambdaUpdateWrapper();
        ((LambdaUpdateWrapper)((LambdaUpdateWrapper)updateWrapper.in(RecordPacketResultEntity::getId, ids)).set(RecordPacketResultEntity::getUpload, (Object)upload)).setSql("tryCount = COALESCE(tryCount, 0) + 1");
        return this.iRecordPacketResultService.update((Wrapper)updateWrapper);
    }
}

