/*
 * Decompiled with CFR 0.152.
 */
package com.simba.services.service.translator;

import com.simba.services.service.IStatusTranslator;
import com.simba.services.service.translator.FaultInfo;
import java.util.HashMap;
import java.util.Map;

public abstract class AbstractStatusTranslator
implements IStatusTranslator {
    private String deviceType;
    protected Map<Integer, String> stateMap;
    protected Map<Integer, FaultInfo> faultMap;

    public AbstractStatusTranslator(String deviceType) {
        this.deviceType = deviceType;
        this.stateMap = new HashMap();
        this.faultMap = new HashMap();
    }

    public String translate(String type, int code) {
        if ("1".equals(type)) {
            return this.translateStatus(code);
        }
        if ("2".equals(type)) {
            return this.translateFault(code).getFaultStatus();
        }
        return "";
    }

    public String translateStatus(int code) {
        if (!this.stateMap.containsKey(code)) {
            return "";
        }
        return "SHXB.SHDJ." + (String)this.stateMap.get(code);
    }

    public FaultInfo translateFault(int code) {
        if (!this.faultMap.containsKey(code)) {
            return FaultInfo.DEFAULT;
        }
        return (FaultInfo)this.faultMap.get(code);
    }

    public String getDeviceType() {
        return this.deviceType;
    }
}

