/*
 * Decompiled with CFR 0.152.
 */
package com.simba.services.service.impl;

import cn.hutool.core.util.StrUtil;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.simba.services.bean.domain.DeviceConfig;
import com.simba.services.bean.domain.MachineConfig;
import com.simba.services.bean.domain.SorterConfig;
import com.simba.services.bean.domain.Statistics;
import com.simba.services.bean.statistics.Counter;
import com.simba.services.bean.statistics.CounterExt;
import com.simba.services.bean.statistics.ObrCounter;
import com.simba.services.bean.statistics.TableSpaceInfo;
import com.simba.services.common.utils.DateUtils;
import com.simba.services.mapper.sorter.StatisticsMapper;
import com.simba.services.service.DeviceConfigService;
import com.simba.services.service.SorterConfigService;
import com.simba.services.service.StatisticsService;
import com.simba.services.upload.data.CarrierMsg;
import com.simba.services.upload.data.InductMsg;
import com.simba.services.upload.data.LinesMsg;
import com.simba.services.upload.data.ObrMsg;
import com.simba.services.upload.data.PhysicalPosMsg;
import com.simba.services.upload.data.SorterMsg;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class StatisticsServiceImpl
extends ServiceImpl<StatisticsMapper, Statistics>
implements StatisticsService {
    private static final Logger log = LoggerFactory.getLogger(StatisticsServiceImpl.class);
    private StatisticsMapper statisticsMapper;
    @Resource
    private SorterConfigService sorterConfigService;
    @Resource
    private DeviceConfigService deviceConfigService;

    public Statistics findTmStatisticsById(Long id) {
        return (Statistics)this.statisticsMapper.selectById((Serializable)id);
    }

    public List<Statistics> findTmStatisticsList(Statistics findParams) {
        LambdaQueryWrapper wrapper = new LambdaQueryWrapper();
        wrapper.eq(StrUtil.isNotBlank((CharSequence)findParams.getBasickey()), Statistics::getBasickey, (Object)findParams.getBasickey());
        wrapper.eq(StrUtil.isNotBlank((CharSequence)findParams.getBasicvalue()), Statistics::getBasicvalue, (Object)findParams.getBasicvalue());
        wrapper.eq(StrUtil.isNotBlank((CharSequence)findParams.getBasicdesc()), Statistics::getBasicdesc, (Object)findParams.getBasicdesc());
        return this.statisticsMapper.selectList((Wrapper)wrapper);
    }

    public int saveTmStatistics(Statistics addParams) {
        Statistics tmStatistics = new Statistics();
        tmStatistics.setId(addParams.getId());
        tmStatistics.setBasickey(addParams.getBasickey());
        tmStatistics.setBasicvalue(addParams.getBasicvalue());
        tmStatistics.setBasicdesc(addParams.getBasicdesc());
        tmStatistics.setCreateTime(DateUtils.getNowDate());
        tmStatistics.setCreateTime(addParams.getCreateTime());
        tmStatistics.setUpdateTime(addParams.getUpdateTime());
        return this.statisticsMapper.insert((Object)tmStatistics);
    }

    public int editTmStatistics(Statistics tmStatistics) {
        tmStatistics.setUpdateTime(DateUtils.getNowDate());
        return this.statisticsMapper.updateById((Object)tmStatistics);
    }

    public int removeTmStatisticsByIds(Long[] ids) {
        return this.statisticsMapper.deleteTmStatisticsByIds(ids);
    }

    public int removeTmStatisticsById(Long id) {
        return this.statisticsMapper.deleteById((Serializable)id);
    }

    public List<SorterMsg> listSorterSortDataByMachine(MachineConfig machine, Date lastTime, int slotCount1, int slotCount2, boolean isBalanceWheel) {
        ArrayList<SorterMsg> list = new ArrayList();
        long intervalSeconds = machine.getDataSendingInterval();
        if (isBalanceWheel) {
            log.debug("TODO:machine.getExtraReferenceSchemas()" + machine.getExtraReferenceSchemas());
            String schema = machine.getExtraReferenceSchemas().split(",")[0];
            log.debug("TODO:schema: " + schema);
            list.addAll(this.forListSorterSortDataByMachine(machine, schema, lastTime, intervalSeconds, slotCount1, "IL"));
            schema = machine.getReferenceSchema();
            list.addAll(this.forListSorterSortDataByMachine(machine, schema, lastTime, intervalSeconds, slotCount2, "SL"));
        } else {
            list = this.forListSorterSortDataByMachine(machine, machine.getReferenceSchema(), lastTime, intervalSeconds, slotCount1, null);
        }
        return list;
    }

    private List<SorterMsg> forListSorterSortDataByMachine(MachineConfig machine, String schema, Date lastTime, long intervalSeconds, int slotCount, String lineType) {
        ArrayList packetCounterInMinuteList;
        List fallCounterList;
        ArrayList passCounterList;
        ArrayList<SorterMsg> list = new ArrayList<SorterMsg>();
        Date endTime = new Date(lastTime.getTime() + intervalSeconds * 1000L);
        boolean isBalanceWheel = true;
        if (StringUtils.isEmpty((CharSequence)lineType)) {
            isBalanceWheel = false;
        }
        if (isBalanceWheel) {
            passCounterList = this.statisticsMapper.listSorterPassSortDataForWheel(schema, lastTime, endTime);
            log.debug("passCounterList.size=" + passCounterList.size());
        } else {
            passCounterList = this.statisticsMapper.listSorterPassSortData(schema, lastTime, endTime);
        }
        if (CollectionUtils.isEmpty((Collection)passCounterList)) {
            log.debug("\u65e0\u4e0a\u4ef6\u90ae\u4ef6");
            passCounterList = new ArrayList();
        }
        if (CollectionUtils.isEmpty((Collection)(fallCounterList = isBalanceWheel ? this.statisticsMapper.listSorterFallSortDataForWheel(schema, lastTime, endTime) : this.statisticsMapper.listSorterFallSortData(schema, lastTime, endTime)))) {
            log.debug("\u65e0\u843d\u683c\u90ae\u4ef6");
            fallCounterList = new ArrayList();
        }
        SorterMsg sorterMsg = new SorterMsg();
        if (isBalanceWheel) {
            sorterMsg.setDevId(lineType);
            if ("IL".equals(lineType)) {
                sorterMsg.setName("\u521d\u5206\u7ebf");
            } else {
                sorterMsg.setName("\u7ec6\u5206\u7ebf");
            }
        } else {
            sorterMsg.setDevId("ST01");
            sorterMsg.setName("\u5355\u5c42\u5206\u62e3\u673a");
        }
        int passCount = 0;
        for (Object counter : passCounterList) {
            log.debug("TODO id={}, pass count={}", (Object)counter.getId(), (Object)counter.getCount());
            passCount += counter.getCount().intValue();
        }
        int fallCount = 0;
        for (Counter counter : fallCounterList) {
            log.debug("TODO id={}, fall count={}", (Object)counter.getId(), (Object)counter.getCount());
            fallCount += counter.getCount().intValue();
        }
        sorterMsg.setPassItemCount(Integer.valueOf(passCount));
        sorterMsg.setFallItemCount(Integer.valueOf(fallCount));
        if (!isBalanceWheel) {
            ArrayList fallHalfCounterList = this.statisticsMapper.listSorterFallHalfSortData(schema, lastTime, endTime);
            if (CollectionUtils.isEmpty((Collection)fallHalfCounterList)) {
                fallHalfCounterList = new ArrayList();
            }
            int fallHalfCount = 0;
            for (Object counter : fallHalfCounterList) {
                fallHalfCount += counter.getCount().intValue();
            }
            sorterMsg.setFallHalfCount(Integer.valueOf(fallHalfCount));
        }
        sorterMsg.setPosTotalCount(Integer.valueOf(slotCount));
        int obrPassPacketCount = 0;
        if (isBalanceWheel) {
            ArrayList obrPassPacketCounterList = this.statisticsMapper.listSorterObrPassSortData(schema, lastTime, endTime);
            if (CollectionUtils.isEmpty((Collection)obrPassPacketCounterList)) {
                obrPassPacketCounterList = new ArrayList();
            }
            for (Object counter : obrPassPacketCounterList) {
                obrPassPacketCount += counter.getCount().intValue();
            }
        }
        sorterMsg.setObrPassCount(Integer.valueOf(obrPassPacketCount));
        int obrRecognizedPacketCount = 0;
        if (isBalanceWheel) {
            ArrayList obrRecognizedPacketCounterList = this.statisticsMapper.listSorterObrRecognizedSortData(schema, lastTime, endTime);
            if (CollectionUtils.isEmpty((Collection)obrRecognizedPacketCounterList)) {
                obrRecognizedPacketCounterList = new ArrayList();
            }
            for (Object counter : obrRecognizedPacketCounterList) {
                obrRecognizedPacketCount += counter.getCount().intValue();
            }
        }
        sorterMsg.setObrReadCount(Integer.valueOf(obrRecognizedPacketCount));
        int obrRejectedPacketCount = 0;
        if (isBalanceWheel) {
            ArrayList obrRejectPacketCounterList = this.statisticsMapper.listSorterObrRejectedSortData(schema, lastTime, endTime);
            if (CollectionUtils.isEmpty((Collection)obrRejectPacketCounterList)) {
                obrRejectPacketCounterList = new ArrayList();
            }
            for (Counter counter : obrRejectPacketCounterList) {
                obrRejectedPacketCount += counter.getCount().intValue();
            }
        }
        sorterMsg.setAcceptUnreadCount(Integer.valueOf(obrRejectedPacketCount));
        int trashPacketCount = 0;
        int noInfoPacketCount = 0;
        int noPhysicalPacketCount = 0;
        int maxCirclePacketCount = 0;
        int otherTrashPacketCount = 0;
        int lostPacketCount = 0;
        ArrayList packetCounterList = this.statisticsMapper.listPacketOffSortData(schema, lastTime, endTime);
        if (CollectionUtils.isEmpty((Collection)packetCounterList)) {
            packetCounterList = new ArrayList();
        }
        for (Counter counter : packetCounterList) {
            Integer id = counter.getId();
            if (id == null || id == 0) continue;
            trashPacketCount += counter.getCount().intValue();
            if (id.equals(1)) {
                noInfoPacketCount = counter.getCount();
                continue;
            }
            if (id.equals(5)) {
                maxCirclePacketCount = counter.getCount();
                continue;
            }
            if (id.equals(11)) {
                noPhysicalPacketCount = counter.getCount();
                continue;
            }
            if (id.equals(6)) {
                lostPacketCount = counter.getCount();
                continue;
            }
            otherTrashPacketCount += counter.getCount().intValue();
        }
        sorterMsg.setAcceptItemCount(Integer.valueOf(trashPacketCount));
        sorterMsg.setAcceptNoinfoCount(Integer.valueOf(noInfoPacketCount));
        sorterMsg.setAcceptNoposCount(Integer.valueOf(noPhysicalPacketCount));
        sorterMsg.setAcceptOtherCount(Integer.valueOf(otherTrashPacketCount));
        sorterMsg.setAcceptTolockCount(Integer.valueOf(maxCirclePacketCount));
        sorterMsg.setLostItemCount(Integer.valueOf(lostPacketCount));
        int lastOps = this.statisticsMapper.getMachineLastOps(machine.getReferenceSchema());
        Date startedTime = null;
        if (lastOps == 1) {
            startedTime = this.statisticsMapper.getMachineStartedTimePro(machine.getReferenceSchema(), Integer.valueOf(1));
        }
        if (CollectionUtils.isEmpty((Collection)(packetCounterInMinuteList = this.statisticsMapper.listPacketOffInMinuteSortData(schema, lastTime, endTime)))) {
            packetCounterInMinuteList = new ArrayList();
        }
        int maxPacketCount = 0;
        for (CounterExt counter : packetCounterInMinuteList) {
            maxPacketCount = Math.max(counter.getCount(), maxPacketCount);
        }
        if (startedTime == null) {
            sorterMsg.setRunningTime(Integer.valueOf(0));
        } else {
            sorterMsg.setRunningTime(Integer.valueOf(machine.getDataSendingInterval().intValue()));
        }
        int seconds = packetCounterInMinuteList.size() * 60;
        if (seconds > sorterMsg.getRunningTime()) {
            seconds = sorterMsg.getRunningTime();
        }
        if (startedTime == null) {
            sorterMsg.setEffectiveRunningTime(Integer.valueOf(0));
        } else {
            sorterMsg.setEffectiveRunningTime(Integer.valueOf(seconds));
        }
        if (passCount == 0 || seconds == 0) {
            sorterMsg.setAverageEfficiency(Integer.valueOf(0));
        } else {
            sorterMsg.setAverageEfficiency(Integer.valueOf((int)(3600L * (long)passCount / (long)seconds)));
        }
        int maxPeakEfficiency = maxPacketCount * 60;
        sorterMsg.setMaxPeakEfficiency(Integer.valueOf(maxPeakEfficiency));
        list.add(sorterMsg);
        return list;
    }

    public List<LinesMsg> listLinesSortDataByMachine(MachineConfig machine, Date lastTime) {
        ArrayList<LinesMsg> list = new ArrayList<LinesMsg>();
        list.addAll(this.forListLinesSortDataByMachine(machine, lastTime, machine.getExtraReferenceSchemas().split(",")[0], "IL"));
        list.addAll(this.forListLinesSortDataByMachine(machine, lastTime, machine.getReferenceSchema(), "SL"));
        return list;
    }

    private List<LinesMsg> forListLinesSortDataByMachine(MachineConfig machine, Date lastTime, String schema, String lineType) {
        ArrayList<LinesMsg> list = new ArrayList<LinesMsg>();
        List sorterList = this.sorterConfigService.listSorter(machine.getMachineId(), lineType);
        if (CollectionUtils.isEmpty((Collection)sorterList)) {
            log.error("\u6ca1\u6709\u914d\u7f6e\u5206\u62e3\u673a\uff08\u77e9\u9635\u7ebf\u4f53\uff09\u3002\u5206\u62e3\u673a\u7f16\u7801: {}\u3002", (Object)machine.getMachineId());
            return list;
        }
        Date endTime = new Date(lastTime.getTime() + machine.getDataSendingInterval() * 1000L);
        ArrayList passCounterList = this.statisticsMapper.listSorterPassSortDataForWheel(schema, lastTime, endTime);
        if (CollectionUtils.isEmpty((Collection)passCounterList)) {
            passCounterList = new ArrayList();
        }
        HashMap<Integer, Counter> counterMap = new HashMap<Integer, Counter>();
        for (Counter counter : passCounterList) {
            counterMap.put(counter.getId(), counter);
        }
        int lastOps = this.statisticsMapper.getMachineLastOps(machine.getReferenceSchema());
        Date startedTime = null;
        if (lastOps == 1) {
            startedTime = this.statisticsMapper.getMachineStartedTime(machine.getReferenceSchema());
        }
        for (SorterConfig sorter : sorterList) {
            LinesMsg sorterMsg = new LinesMsg();
            sorterMsg.setDevId(sorter.getSorterId());
            sorterMsg.setName(sorter.getSorterName());
            sorterMsg.setType(lineType);
            int passCount = 0;
            Counter counter = (Counter)counterMap.get(sorter.getSeqNo());
            if (counter != null) {
                passCount = counter.getCount();
            }
            sorterMsg.setSortItemCount(Integer.valueOf(passCount));
            if (startedTime == null) {
                sorterMsg.setRunningTime(Long.valueOf(0L));
            } else {
                sorterMsg.setRunningTime(machine.getDataSendingInterval());
            }
            if (startedTime == null) {
                sorterMsg.setEffectiveRunningTime(Long.valueOf(0L));
            } else {
                sorterMsg.setEffectiveRunningTime(machine.getDataSendingInterval());
            }
            list.add(sorterMsg);
        }
        return list;
    }

    public List<CarrierMsg> listCarrierSortDataByMachine(MachineConfig machine, Date lastTime) {
        ArrayList<CarrierMsg> list = new ArrayList<CarrierMsg>();
        List carrierList = this.deviceConfigService.listCarrier(machine);
        if (CollectionUtils.isEmpty((Collection)carrierList)) {
            log.error("\u6ca1\u6709\u914d\u7f6e\u5c0f\u8f66\u3002\u5206\u62e3\u673a\u7f16\u7801: {}\u3002", (Object)machine.getMachineId());
            return list;
        }
        Date endTime = new Date(lastTime.getTime() + machine.getDataSendingInterval() * 1000L);
        ArrayList counterList = this.statisticsMapper.listCarrierSortData(machine.getReferenceSchema(), lastTime, endTime);
        if (CollectionUtils.isEmpty((Collection)counterList)) {
            counterList = new ArrayList();
        }
        HashMap<Integer, Counter> counterMap = new HashMap<Integer, Counter>();
        for (Counter counter : counterList) {
            counterMap.put(counter.getId(), counter);
        }
        for (DeviceConfig carrier : carrierList) {
            CarrierMsg carrierMsg = new CarrierMsg();
            carrierMsg.setDevId(carrier.getDevId());
            carrierMsg.setName(carrier.getDevName());
            int count = 0;
            Counter counter = (Counter)counterMap.get(carrier.getExtraSeqNo());
            if (counter != null) {
                count = counter.getCount();
            }
            carrierMsg.setPassItemCount(Integer.valueOf(count));
            list.add(carrierMsg);
        }
        return list;
    }

    public List<PhysicalPosMsg> listSlotSortDataByMachine(MachineConfig machine, Date lastTime) {
        ArrayList<PhysicalPosMsg> allList = new ArrayList<PhysicalPosMsg>();
        List list = this.forListSlotSortDataByMachine(machine, machine.getReferenceSchema(), lastTime);
        if (CollectionUtils.isNotEmpty((Collection)list)) {
            allList.addAll(list);
        }
        if (!"Sorter".equals(machine.getType()) && CollectionUtils.isNotEmpty((Collection)(list = this.forListSlotSortDataByMachine(machine, machine.getExtraReferenceSchemas(), lastTime)))) {
            allList.addAll(list);
        }
        return allList;
    }

    private List<PhysicalPosMsg> forListSlotSortDataByMachine(MachineConfig machine, String schema, Date lastTime) {
        ArrayList<PhysicalPosMsg> allList = new ArrayList<PhysicalPosMsg>();
        List sorterList = this.sorterConfigService.listSorter(machine.getMachineId());
        if (CollectionUtils.isEmpty((Collection)sorterList)) {
            log.error("\u6ca1\u6709\u914d\u7f6e\u5206\u62e3\u673a\u3002\u5206\u62e3\u673a\u7f16\u7801: {}\u3002", (Object)machine.getMachineId());
            return allList;
        }
        log.debug("\u5206\u62e3\u673a\u6570\u91cf\u4e3a: {}", (Object)sorterList.size());
        for (SorterConfig sorter : sorterList) {
            List list = this.forListSlotSortDataBySorter(machine, schema, sorter, lastTime);
            if (CollectionUtils.isEmpty((Collection)list)) {
                log.debug("\u683c\u53e3\u5206\u62e3\u6570\u636e\u7edf\u8ba1\u7ed3\u679c\u4e3a\u7a7a\u3002\u5206\u62e3\u673a\u7f16\u7801: {}, \u5206\u62e3\u673aid: {}\u3002", (Object)machine.getMachineId(), (Object)sorter.getSeqNo());
                continue;
            }
            allList.addAll(list);
        }
        return allList;
    }

    private List<PhysicalPosMsg> forListSlotSortDataBySorter(MachineConfig machine, String schema, SorterConfig sorter, Date lastTime) {
        ArrayList<PhysicalPosMsg> list = new ArrayList<PhysicalPosMsg>();
        List slotList = this.deviceConfigService.listSlot(sorter);
        if (CollectionUtils.isEmpty((Collection)slotList)) {
            log.error("\u6ca1\u6709\u914d\u7f6e\u683c\u53e3\u3002\u5206\u62e3\u673a\u7f16\u7801: {}, \u5206\u62e3\u673aid: {}\u3002", (Object)machine.getMachineId(), (Object)sorter.getSorterId());
            return list;
        }
        log.debug("slotList.size=" + slotList.size());
        Date endTime = new Date(lastTime.getTime() + machine.getDataSendingInterval() * 1000L);
        ArrayList counterList = this.statisticsMapper.listSlotSortData(schema, lastTime, endTime);
        if (CollectionUtils.isEmpty((Collection)counterList)) {
            counterList = new ArrayList();
        }
        log.debug("counterList.size=" + counterList.size());
        HashMap<Integer, Counter> counterMap = new HashMap<Integer, Counter>();
        for (Counter counter : counterList) {
            counterMap.put(counter.getId(), counter);
        }
        for (DeviceConfig slot : slotList) {
            PhysicalPosMsg slotMsg = new PhysicalPosMsg();
            slotMsg.setDevId(slot.getDevId());
            slotMsg.setName(slot.getDevName());
            int count = 0;
            Counter counter = (Counter)counterMap.get(slot.getExtraSeqNo());
            if (counter != null) {
                count = counter.getCount();
            }
            slotMsg.setFallItemCount(Integer.valueOf(count));
            list.add(slotMsg);
        }
        return list;
    }

    public List<InductMsg> listInductSortDataByMachine(MachineConfig machine, Date lastTime) {
        ArrayList<InductMsg> list = new ArrayList<InductMsg>();
        List inductList = this.deviceConfigService.listInduct(machine);
        if (CollectionUtils.isEmpty((Collection)inductList)) {
            log.error("\u6ca1\u6709\u914d\u7f6e\u4f9b\u4ef6\u53f0\u3002\u5206\u62e3\u673a\u7f16\u7801: {}\u3002", (Object)machine.getMachineId());
            return list;
        }
        Date endTime = new Date(lastTime.getTime() + machine.getDataSendingInterval() * 1000L);
        ArrayList counterList = this.statisticsMapper.listInductSortData(machine.getReferenceSchema(), lastTime, endTime);
        if (CollectionUtils.isEmpty((Collection)counterList)) {
            counterList = new ArrayList();
        }
        HashMap<Integer, Counter> counterMap = new HashMap<Integer, Counter>();
        for (Counter counter : counterList) {
            counterMap.put(counter.getId(), counter);
        }
        for (DeviceConfig induct : inductList) {
            InductMsg inductMsg = new InductMsg();
            inductMsg.setDevId(induct.getDevId());
            inductMsg.setName(induct.getDevName());
            int count = 0;
            Counter counter = (Counter)counterMap.get(induct.getExtraSeqNo());
            if (counter != null) {
                count = counter.getCount();
            }
            inductMsg.setInductItemCount(Integer.valueOf(count));
            Integer inductTime = 0;
            if (count > 0) {
                inductTime = (int)machine.getDataSendingInterval().longValue();
            }
            inductMsg.setInductTime(inductTime);
            Integer inductRate = 0;
            if (count > 0) {
                if (inductTime > 0) {
                    inductRate = 3600 * count / inductTime;
                } else {
                    log.error("\u6548\u7387\u7edf\u8ba1\u5f02\u5e38\u3002\u5206\u62e3\u673a\u7f16\u7801:{}, \u4f9b\u4ef6\u53f0\u53f7: {}, \u5f00\u59cb\u65f6\u95f4: {}, \u7ed3\u675f\u65f6\u95f4: {}", new Object[]{machine.getMachineId(), induct.getDevId(), lastTime, endTime});
                }
            }
            inductMsg.setInductRate(inductRate);
            list.add(inductMsg);
        }
        return list;
    }

    public List<ObrMsg> listObrSortDataByMachine(MachineConfig machine, Date lastTime) {
        ArrayList<ObrMsg> allList = new ArrayList<ObrMsg>();
        log.debug("machine.getReferenceSchema()=" + machine.getReferenceSchema());
        List list = this.forListObrSortDataByMachine(machine, machine.getReferenceSchema(), lastTime);
        if (CollectionUtils.isNotEmpty((Collection)list)) {
            allList.addAll(list);
        }
        if ("BalanceWheel".equals(machine.getType()) && CollectionUtils.isNotEmpty((Collection)(list = this.forListObrSortDataByMachine(machine, machine.getExtraReferenceSchemas(), lastTime)))) {
            allList.addAll(list);
        }
        return allList;
    }

    private List<ObrMsg> forListObrSortDataByMachine(MachineConfig machine, String schema, Date lastTime) {
        ArrayList<ObrMsg> list = new ArrayList<ObrMsg>();
        List obrList = this.deviceConfigService.listObr(machine);
        if (CollectionUtils.isEmpty((Collection)obrList)) {
            log.error("\u6ca1\u6709\u914d\u7f6eOBR\u3002\u5206\u62e3\u673a\u7f16\u7801: {}\u3002", (Object)machine.getMachineId());
            return list;
        }
        Date endTime = new Date(lastTime.getTime() + machine.getDataSendingInterval() * 1000L);
        List counterList = "BalanceWheel".equals(machine.getType()) ? this.statisticsMapper.listObrPassSortDataForBalanceWheel(schema, lastTime, endTime) : this.statisticsMapper.listObrPassSortDataForSorter(schema, lastTime, endTime);
        HashMap<String, ObrCounter> counterMap = new HashMap<String, ObrCounter>();
        for (ObrCounter counter : counterList) {
            counterMap.put(counter.getId(), counter);
        }
        for (DeviceConfig obr : obrList) {
            ObrMsg obrMsg = new ObrMsg();
            obrMsg.setDevId(obr.getDevId());
            obrMsg.setName(obr.getDevName());
            int count = 0;
            int readCount = 0;
            String key = "BalanceWheel".equals(machine.getType()) ? String.valueOf(obr.getLineNum()) : String.valueOf(obr.getSeqNo());
            ObrCounter counter = (ObrCounter)counterMap.get(key);
            if (counter != null) {
                count = counter.getTotalCount();
                readCount = counter.getRecognizedCount();
                if (readCount > count) {
                    readCount = count;
                }
            }
            obrMsg.setPassItemCount(Integer.valueOf(count));
            obrMsg.setReadItemCount(Integer.valueOf(readCount));
            float rate = 0.0f;
            if (count > 0) {
                rate = (float)readCount / (float)count;
            }
            obrMsg.setRecognitionRate(Float.valueOf(rate * 100.0f));
            list.add(obrMsg);
        }
        return list;
    }

    public TableSpaceInfo getTableSpaceInfo(String schema) {
        return this.statisticsMapper.getTableSpaceInfo(schema);
    }

    public StatisticsServiceImpl(StatisticsMapper statisticsMapper, SorterConfigService sorterConfigService, DeviceConfigService deviceConfigService) {
        this.statisticsMapper = statisticsMapper;
        this.sorterConfigService = sorterConfigService;
        this.deviceConfigService = deviceConfigService;
    }
}

