/*
 * Decompiled with CFR 0.152.
 */
package com.simba.services.service.impl;

import cn.hutool.core.util.StrUtil;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.simba.services.bean.domain.SorterConfig;
import com.simba.services.common.utils.DateUtils;
import com.simba.services.mapper.monitor.SorterConfigMapper;
import com.simba.services.service.SorterConfigService;
import java.io.Serializable;
import java.util.List;
import org.springframework.stereotype.Service;

@Service
public class SorterConfigServiceImpl
extends ServiceImpl<SorterConfigMapper, SorterConfig>
implements SorterConfigService {
    private SorterConfigMapper sorterConfigMapper;

    public SorterConfig findTmSorterConfigById(Long id) {
        return (SorterConfig)this.sorterConfigMapper.selectById((Serializable)id);
    }

    public List<SorterConfig> findTmSorterConfigList(SorterConfig findParams) {
        LambdaQueryWrapper wrapper = new LambdaQueryWrapper();
        wrapper.eq(StrUtil.isNotBlank((CharSequence)findParams.getSorterId()), SorterConfig::getSorterId, (Object)findParams.getSorterId());
        wrapper.eq(StrUtil.isNotBlank((CharSequence)findParams.getSorterName()), SorterConfig::getSorterName, (Object)findParams.getSorterName());
        wrapper.eq(StrUtil.isNotBlank((CharSequence)findParams.getType()), SorterConfig::getType, (Object)findParams.getType());
        wrapper.eq(findParams.getSeqNo() != null, SorterConfig::getSeqNo, (Object)findParams.getSeqNo());
        wrapper.eq(findParams.getLineNum() != null, SorterConfig::getLineNum, (Object)findParams.getLineNum());
        return this.sorterConfigMapper.selectList((Wrapper)wrapper);
    }

    public int saveTmSorterConfig(SorterConfig addParams) {
        SorterConfig tmSorterConfig = new SorterConfig();
        tmSorterConfig.setId(addParams.getId());
        tmSorterConfig.setMachineId(addParams.getMachineId());
        tmSorterConfig.setSorterId(addParams.getSorterId());
        tmSorterConfig.setSorterName(addParams.getSorterName());
        tmSorterConfig.setType(addParams.getType());
        tmSorterConfig.setSeqNo(addParams.getSeqNo());
        tmSorterConfig.setLineNum(addParams.getLineNum());
        tmSorterConfig.setRemark(addParams.getRemark());
        tmSorterConfig.setCreateTime(DateUtils.getNowDate());
        tmSorterConfig.setCreateTime(addParams.getCreateTime());
        tmSorterConfig.setUpdateTime(addParams.getUpdateTime());
        return this.sorterConfigMapper.insert((Object)tmSorterConfig);
    }

    public int editTmSorterConfig(SorterConfig tmSorterConfig) {
        tmSorterConfig.setUpdateTime(DateUtils.getNowDate());
        return this.sorterConfigMapper.updateById((Object)tmSorterConfig);
    }

    public int removeTmSorterConfigByIds(Long[] ids) {
        return this.sorterConfigMapper.deleteTmSorterConfigByIds(ids);
    }

    public int removeTmSorterConfigById(Long id) {
        return this.sorterConfigMapper.deleteById((Serializable)id);
    }

    public List<SorterConfig> listSorter(String machineId) {
        Wrapper warpper = (Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery().eq(SorterConfig::getMachineId, (Object)machineId)).gt(SorterConfig::getSeqNo, (Object)0)).orderByAsc(SorterConfig::getSeqNo);
        return this.list(warpper);
    }

    public List<SorterConfig> listSorter(String machineId, String lineType) {
        Wrapper warpper = (Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery().eq(SorterConfig::getMachineId, (Object)machineId)).eq(SorterConfig::getType, (Object)lineType)).gt(SorterConfig::getSeqNo, (Object)0)).orderByAsc(SorterConfig::getSeqNo);
        return this.list(warpper);
    }

    public SorterConfigServiceImpl(SorterConfigMapper sorterConfigMapper) {
        this.sorterConfigMapper = sorterConfigMapper;
    }
}

