/*
 * Decompiled with CFR 0.152.
 */
package com.simba.services.service.impl;

import cn.hutool.core.util.StrUtil;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.simba.services.bean.domain.MachineConfig;
import com.simba.services.common.utils.DateUtils;
import com.simba.services.mapper.monitor.MachineConfigMapper;
import com.simba.services.service.MachineConfigService;
import java.io.Serializable;
import java.util.List;
import org.springframework.stereotype.Service;

@Service
public class MachineConfigServiceImpl
extends ServiceImpl<MachineConfigMapper, MachineConfig>
implements MachineConfigService {
    private MachineConfigMapper machineConfigMapper;

    public MachineConfig findTmMachineConfigById(Long id) {
        return (MachineConfig)this.machineConfigMapper.selectById((Serializable)id);
    }

    public List<MachineConfig> findTmMachineConfigList(MachineConfig findParams) {
        LambdaQueryWrapper wrapper = new LambdaQueryWrapper();
        wrapper.eq(StrUtil.isNotBlank((CharSequence)findParams.getMachineId()), MachineConfig::getMachineId, (Object)findParams.getMachineId());
        wrapper.eq(StrUtil.isNotBlank((CharSequence)findParams.getMachineName()), MachineConfig::getMachineName, (Object)findParams.getMachineName());
        wrapper.eq(StrUtil.isNotBlank((CharSequence)findParams.getType()), MachineConfig::getType, (Object)findParams.getType());
        wrapper.eq(StrUtil.isNotBlank((CharSequence)findParams.getManufacturerId()), MachineConfig::getManufacturerId, (Object)findParams.getManufacturerId());
        wrapper.eq(StrUtil.isNotBlank((CharSequence)findParams.getReferenceSchema()), MachineConfig::getReferenceSchema, (Object)findParams.getReferenceSchema());
        wrapper.eq(StrUtil.isNotBlank((CharSequence)findParams.getExtraReferenceSchemas()), MachineConfig::getExtraReferenceSchemas, (Object)findParams.getExtraReferenceSchemas());
        wrapper.eq(StrUtil.isNotBlank((CharSequence)findParams.getPlcIp()), MachineConfig::getPlcIp, (Object)findParams.getPlcIp());
        return this.machineConfigMapper.selectList((Wrapper)wrapper);
    }

    public int saveTmMachineConfig(MachineConfig addParams) {
        MachineConfig tmMachineConfig = new MachineConfig();
        tmMachineConfig.setId(addParams.getId());
        tmMachineConfig.setMachineId(addParams.getMachineId());
        tmMachineConfig.setMachineName(addParams.getMachineName());
        tmMachineConfig.setType(addParams.getType());
        tmMachineConfig.setManufacturerId(addParams.getManufacturerId());
        tmMachineConfig.setReferenceSchema(addParams.getReferenceSchema());
        tmMachineConfig.setExtraReferenceSchemas(addParams.getExtraReferenceSchemas());
        tmMachineConfig.setReferenceId(addParams.getReferenceId());
        tmMachineConfig.setRunningSpeedLimit(addParams.getRunningSpeedLimit());
        tmMachineConfig.setDataSendingInterval(addParams.getDataSendingInterval());
        tmMachineConfig.setStatusSendingInterval(addParams.getStatusSendingInterval());
        tmMachineConfig.setEventSendingInterval(addParams.getEventSendingInterval());
        tmMachineConfig.setLogSendingInterval(addParams.getLogSendingInterval());
        tmMachineConfig.setPlcIp(addParams.getPlcIp());
        tmMachineConfig.setRemark(addParams.getRemark());
        tmMachineConfig.setCreateTime(DateUtils.getNowDate());
        tmMachineConfig.setCreateTime(addParams.getCreateTime());
        tmMachineConfig.setUpdateTime(addParams.getUpdateTime());
        return this.machineConfigMapper.insert((Object)tmMachineConfig);
    }

    public int editTmMachineConfig(MachineConfig tmMachineConfig) {
        tmMachineConfig.setUpdateTime(DateUtils.getNowDate());
        return this.machineConfigMapper.updateById((Object)tmMachineConfig);
    }

    public int removeTmMachineConfigByIds(Long[] ids) {
        return this.machineConfigMapper.deleteTmMachineConfigByIds(ids);
    }

    public int removeTmMachineConfigById(Long id) {
        return this.machineConfigMapper.deleteById((Serializable)id);
    }

    public MachineConfig getMachineConfigByMachineId(String machineId) {
        LambdaQueryWrapper wrapper = new LambdaQueryWrapper();
        wrapper.eq(MachineConfig::getMachineId, (Object)machineId);
        return (MachineConfig)this.machineConfigMapper.selectOne((Wrapper)wrapper);
    }

    public MachineConfigServiceImpl(MachineConfigMapper machineConfigMapper) {
        this.machineConfigMapper = machineConfigMapper;
    }
}

