/*
 * Decompiled with CFR 0.152.
 */
package com.simba.services.service.impl;

import cn.hutool.core.util.StrUtil;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.simba.services.bean.domain.DeviceConfig;
import com.simba.services.bean.domain.MachineConfig;
import com.simba.services.bean.domain.SorterConfig;
import com.simba.services.common.utils.DateUtils;
import com.simba.services.mapper.monitor.DeviceConfigMapper;
import com.simba.services.service.DeviceConfigService;
import java.io.Serializable;
import java.util.List;
import org.springframework.stereotype.Service;

@Service
public class DeviceConfigServiceImpl
extends ServiceImpl<DeviceConfigMapper, DeviceConfig>
implements DeviceConfigService {
    private DeviceConfigMapper deviceConfigMapper;

    public DeviceConfig findTmDeviceConfigById(Long id) {
        return (DeviceConfig)this.deviceConfigMapper.selectById((Serializable)id);
    }

    public List<DeviceConfig> findTmDeviceConfigList(DeviceConfig findParams) {
        LambdaQueryWrapper wrapper = new LambdaQueryWrapper();
        wrapper.eq(findParams.getMachineId() != null, DeviceConfig::getMachineId, (Object)findParams.getMachineId());
        wrapper.eq(StrUtil.isNotBlank((CharSequence)findParams.getSorterId()), DeviceConfig::getSorterId, (Object)findParams.getSorterId());
        wrapper.eq(StrUtil.isNotBlank((CharSequence)findParams.getDevId()), DeviceConfig::getDevId, (Object)findParams.getDevId());
        wrapper.eq(StrUtil.isNotBlank((CharSequence)findParams.getDevName()), DeviceConfig::getDevName, (Object)findParams.getDevName());
        wrapper.eq(StrUtil.isNotBlank((CharSequence)findParams.getDevType()), DeviceConfig::getDevType, (Object)findParams.getDevType());
        wrapper.eq(StrUtil.isNotBlank((CharSequence)findParams.getDevSubType()), DeviceConfig::getDevSubType, (Object)findParams.getDevSubType());
        wrapper.eq(findParams.getSeqNo() != null, DeviceConfig::getSeqNo, (Object)findParams.getSeqNo());
        return this.deviceConfigMapper.selectList((Wrapper)wrapper);
    }

    public int saveTmDeviceConfig(DeviceConfig addParams) {
        DeviceConfig tmDeviceConfig = new DeviceConfig();
        tmDeviceConfig.setId(addParams.getId());
        tmDeviceConfig.setMachineId(addParams.getMachineId());
        tmDeviceConfig.setSorterId(addParams.getSorterId());
        tmDeviceConfig.setLineNum(addParams.getLineNum());
        tmDeviceConfig.setDevId(addParams.getDevId());
        tmDeviceConfig.setDevName(addParams.getDevName());
        tmDeviceConfig.setDevType(addParams.getDevType());
        tmDeviceConfig.setDevSubType(addParams.getDevSubType());
        tmDeviceConfig.setSeqNo(addParams.getSeqNo());
        tmDeviceConfig.setRemark(addParams.getRemark());
        tmDeviceConfig.setCreateTime(DateUtils.getNowDate());
        tmDeviceConfig.setCreateTime(addParams.getCreateTime());
        tmDeviceConfig.setUpdateTime(addParams.getUpdateTime());
        return this.deviceConfigMapper.insert((Object)tmDeviceConfig);
    }

    public int editTmDeviceConfig(DeviceConfig tmDeviceConfig) {
        tmDeviceConfig.setUpdateTime(DateUtils.getNowDate());
        return this.deviceConfigMapper.updateById((Object)tmDeviceConfig);
    }

    public int removeTmDeviceConfigByIds(Long[] ids) {
        return this.deviceConfigMapper.deleteTmDeviceConfigByIds(ids);
    }

    public int removeTmDeviceConfigById(Long id) {
        return this.deviceConfigMapper.deleteById((Serializable)id);
    }

    public List<DeviceConfig> listCarrier(MachineConfig machine) {
        return this.deviceConfigMapper.listCarrier(machine.getMachineId());
    }

    public List<DeviceConfig> listSlot(MachineConfig machine) {
        return this.deviceConfigMapper.listSlot(machine.getMachineId());
    }

    public List<DeviceConfig> listSlot(SorterConfig sorter) {
        return this.deviceConfigMapper.listSlotByLineNum(String.valueOf(sorter.getMachineId()), sorter.getSeqNo());
    }

    public List<DeviceConfig> listInduct(MachineConfig machine) {
        return this.deviceConfigMapper.listInduct(machine.getMachineId());
    }

    public List<DeviceConfig> listObr(MachineConfig machine) {
        return this.deviceConfigMapper.listObr(machine.getMachineId());
    }

    public DeviceConfigServiceImpl(DeviceConfigMapper deviceConfigMapper) {
        this.deviceConfigMapper = deviceConfigMapper;
    }
}

