/*
 * Decompiled with CFR 0.152.
 */
package com.simba.services.service.impl;

import cn.hutool.core.util.StrUtil;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.simba.services.bean.domain.BasicConfig;
import com.simba.services.common.utils.DateUtils;
import com.simba.services.mapper.monitor.BasicConfigMapper;
import com.simba.services.service.BasicConfigService;
import com.simba.services.service.DeviceConfigService;
import com.simba.services.service.SorterConfigService;
import java.io.Serializable;
import java.util.List;
import javax.annotation.Resource;
import org.springframework.stereotype.Service;

@Service
public class BasicConfigServiceImpl
extends ServiceImpl<BasicConfigMapper, BasicConfig>
implements BasicConfigService {
    private BasicConfigMapper basicConfigMapper;
    @Resource
    private SorterConfigService sorterConfigService;
    @Resource
    private DeviceConfigService deviceConfigService;

    public BasicConfig findTmBasicConfigById(Long id) {
        return (BasicConfig)this.basicConfigMapper.selectById((Serializable)id);
    }

    public List<BasicConfig> findTmBasicConfigList(BasicConfig findParams) {
        LambdaQueryWrapper wrapper = new LambdaQueryWrapper();
        wrapper.eq(StrUtil.isNotBlank((CharSequence)findParams.getBasickey()), BasicConfig::getBasickey, (Object)findParams.getBasickey());
        wrapper.eq(StrUtil.isNotBlank((CharSequence)findParams.getBasicvalue()), BasicConfig::getBasicvalue, (Object)findParams.getBasicvalue());
        wrapper.eq(StrUtil.isNotBlank((CharSequence)findParams.getBasicdesc()), BasicConfig::getBasicdesc, (Object)findParams.getBasicdesc());
        return this.basicConfigMapper.selectList((Wrapper)wrapper);
    }

    public int saveTmBasicConfig(BasicConfig addParams) {
        BasicConfig tmBasicConfig = new BasicConfig();
        tmBasicConfig.setId(addParams.getId());
        tmBasicConfig.setBasickey(addParams.getBasickey());
        tmBasicConfig.setBasicvalue(addParams.getBasicvalue());
        tmBasicConfig.setBasicdesc(addParams.getBasicdesc());
        tmBasicConfig.setCreateTime(DateUtils.getNowDate());
        tmBasicConfig.setCreateTime(addParams.getCreateTime());
        tmBasicConfig.setUpdateTime(addParams.getUpdateTime());
        return this.basicConfigMapper.insert((Object)tmBasicConfig);
    }

    public int editTmBasicConfig(BasicConfig tmBasicConfig) {
        tmBasicConfig.setUpdateTime(DateUtils.getNowDate());
        return this.basicConfigMapper.updateById((Object)tmBasicConfig);
    }

    public int removeTmBasicConfigByIds(Long[] ids) {
        return this.basicConfigMapper.deleteTmBasicConfigByIds(ids);
    }

    public int removeTmBasicConfigById(Long id) {
        return this.basicConfigMapper.deleteTmBasicConfigById(id);
    }

    public BasicConfigServiceImpl(BasicConfigMapper basicConfigMapper, SorterConfigService sorterConfigService, DeviceConfigService deviceConfigService) {
        this.basicConfigMapper = basicConfigMapper;
        this.sorterConfigService = sorterConfigService;
        this.deviceConfigService = deviceConfigService;
    }
}

