/*
 * Decompiled with CFR 0.152.
 */
package com.simba.services.server;

import com.simba.services.common.utils.spring.SpringUtils;
import com.simba.services.handler.PlcMessageHandler;
import com.simba.services.message.AbstractDeviceMessage;
import com.simba.services.message.BalanceWheelDeviceMessage;
import com.simba.services.message.SorterDeviceMessage;
import com.simba.services.server.MyNettyServer;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufUtil;
import io.netty.buffer.Unpooled;
import io.netty.channel.ChannelFutureListener;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelId;
import io.netty.channel.SimpleChannelInboundHandler;
import io.netty.util.concurrent.GenericFutureListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
@ChannelHandler.Sharable
public class WinccMessageDecoder
extends SimpleChannelInboundHandler<ByteBuf> {
    private static final Logger log = LoggerFactory.getLogger(WinccMessageDecoder.class);

    protected void channelRead0(ChannelHandlerContext ctx, ByteBuf msg) throws Exception {
        PlcMessageHandler handler = (PlcMessageHandler)SpringUtils.getBean(PlcMessageHandler.class);
        BalanceWheelDeviceMessage data = null;
        ChannelId id = ctx.channel().id();
        int n = msg.readableBytes();
        if (n < 6) {
            log.error("\u8bfb\u5230\u7684\u5e27\u592a\u5c0f\uff0c\u65e0\u6cd5\u8bfb\u53d6\u547d\u4ee4\u5b57\u3002\u5b57\u8282\u6570: {}\u3002", (Object)n);
            return;
        }
        byte command = msg.getByte(4);
        byte[] bytes = new byte[n];
        msg.readBytes(bytes);
        if (this.isBalanceWheelService(id, command)) {
            data = new BalanceWheelDeviceMessage();
            if (!data.decode(bytes)) {
                log.error("\u89e3\u7801\u5931\u8d25: {}\u3002", (Object)ByteBufUtil.hexDump((byte[])bytes));
                return;
            }
        } else {
            data = new SorterDeviceMessage();
            if (!data.decode(bytes)) {
                log.error("\u89e3\u7801\u5931\u8d25: {}\u3002", (Object)ByteBufUtil.hexDump((byte[])bytes));
                return;
            }
        }
        handler.onDeviceMessageReceived((AbstractDeviceMessage)data, ctx);
    }

    public void channelInactive(ChannelHandlerContext ctx) throws Exception {
        ctx.writeAndFlush((Object)Unpooled.EMPTY_BUFFER).addListener((GenericFutureListener)ChannelFutureListener.CLOSE);
        ChannelId id = ctx.channel().id();
        MyNettyServer.CHANNEL_MAP.remove(id);
        log.info("\u8fde\u63a5\u5173\u95ed: {}\u3002", (Object)ctx.channel().remoteAddress());
        ctx.fireChannelInactive();
    }

    private boolean isBalanceWheelService(ChannelId channelId, byte command) {
        return command < 0;
    }
}

