/*
 * Decompiled with CFR 0.152.
 */
package com.simba.services.server;

import com.simba.services.server.MyNettyServer;
import com.simba.services.server.MyServerHandler;
import com.simba.services.server.WinccMessageDecoder;
import com.simba.services.server.WinccMessageEncoder;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelInitializer;
import io.netty.channel.ChannelPipeline;
import io.netty.channel.socket.SocketChannel;
import io.netty.handler.codec.DelimiterBasedFrameDecoder;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
@ChannelHandler.Sharable
public class WinccChannelInitHandler
extends ChannelInitializer<SocketChannel> {
    private static final Logger log = LoggerFactory.getLogger(WinccChannelInitHandler.class);
    @Resource
    private WinccMessageDecoder winccMessageDecoder;
    @Resource
    private MyServerHandler myServerHandler;

    protected void initChannel(SocketChannel socketChannel) throws Exception {
        ChannelPipeline pipeline = socketChannel.pipeline();
        MyNettyServer.CHANNEL_MAP.put(socketChannel.id(), pipeline);
        log.info("\u65b0\u8fde\u63a5: {}\u3002", (Object)socketChannel.remoteAddress());
        ByteBuf buf = Unpooled.copiedBuffer((byte[])new byte[]{13, 10});
        pipeline.addLast(new ChannelHandler[]{new DelimiterBasedFrameDecoder(65536, buf)});
        pipeline.addLast(new ChannelHandler[]{new WinccMessageDecoder()});
        pipeline.addLast(new ChannelHandler[]{new WinccMessageEncoder()});
    }
}

