/*
 * Decompiled with CFR 0.152.
 */
package com.simba.services.server;

import com.simba.services.server.MyNettyServer;
import io.netty.buffer.Unpooled;
import io.netty.channel.Channel;
import io.netty.channel.ChannelFutureListener;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelId;
import io.netty.channel.ChannelInboundHandlerAdapter;
import io.netty.channel.ChannelPipeline;
import io.netty.util.concurrent.GenericFutureListener;
import java.util.Collection;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
@ChannelHandler.Sharable
public class MyServerHandler
extends ChannelInboundHandlerAdapter {
    private static final Logger log = LoggerFactory.getLogger(MyServerHandler.class);
    public static final Map<String, ChannelId> CHANNEL_ID_MAP = new ConcurrentHashMap();

    public void channelActive(ChannelHandlerContext ctx) throws Exception {
        Channel channel = ctx.channel();
        log.info("\u65b0\u8fde\u63a5: {}\u3002", (Object)channel.remoteAddress());
    }

    public void channelRead(ChannelHandlerContext ctx, Object msg) throws Exception {
    }

    public void send(String code, String msg) {
        if (CHANNEL_ID_MAP.containsKey(code)) {
            ChannelPipeline pipeline = (ChannelPipeline)MyNettyServer.CHANNEL_MAP.get(CHANNEL_ID_MAP.get(code));
            if (pipeline == null) {
                MyNettyServer.CHANNEL_MAP.remove(CHANNEL_ID_MAP.get(code));
            }
            assert (pipeline != null);
            pipeline.writeAndFlush((Object)msg);
        } else {
            Collection pipelines = MyNettyServer.CHANNEL_MAP.values();
            if (pipelines.iterator().hasNext()) {
                ChannelPipeline pipeline = (ChannelPipeline)pipelines.iterator().next();
                pipeline.writeAndFlush((Object)msg);
            }
        }
    }

    public void channelInactive(ChannelHandlerContext ctx) throws Exception {
        ctx.writeAndFlush((Object)Unpooled.EMPTY_BUFFER).addListener((GenericFutureListener)ChannelFutureListener.CLOSE);
        ChannelId id = ctx.channel().id();
        CHANNEL_ID_MAP.remove(id);
        log.info("\u7f51\u5173: {} \u670d\u52a1\u7aef\u8fde\u63a5\u5173\u95ed...", (Object)ctx.channel().remoteAddress());
    }

    public void channelReadComplete(ChannelHandlerContext ctx) throws Exception {
        ctx.flush();
        log.info("\u4fe1\u606f\u63a5\u6536\u5b8c\u6bd5...");
    }

    public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) throws Exception {
        System.out.println("\u5f02\u5e38\u4fe1\u606f\uff1arn " + cause.getMessage());
    }
}

