/*
 * Decompiled with CFR 0.152.
 */
package com.simba.services.server;

import com.simba.services.server.WinccChannelInitHandler;
import io.netty.bootstrap.ServerBootstrap;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelId;
import io.netty.channel.ChannelOption;
import io.netty.channel.ChannelPipeline;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.nio.NioEventLoopGroup;
import io.netty.channel.socket.nio.NioServerSocketChannel;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Component;

@Component
public class MyNettyServer {
    private static final Logger log = LoggerFactory.getLogger(MyNettyServer.class);
    @Value(value="${netty.port}")
    private int port;
    public static NioServerSocketChannel nioServerSocketChannel;
    public static final Map<ChannelId, ChannelPipeline> CHANNEL_MAP;
    @Resource
    private WinccChannelInitHandler winccChannelInitHandler;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void start() {
        NioEventLoopGroup serverChannelEventGroup = new NioEventLoopGroup();
        NioEventLoopGroup workerChannelEventGroup = new NioEventLoopGroup();
        ServerBootstrap bootstrap = new ServerBootstrap();
        ((ServerBootstrap)((ServerBootstrap)bootstrap.group((EventLoopGroup)serverChannelEventGroup, (EventLoopGroup)workerChannelEventGroup).channel(NioServerSocketChannel.class)).option(ChannelOption.SO_BACKLOG, (Object)1024)).childOption(ChannelOption.TCP_NODELAY, (Object)true).childOption(ChannelOption.SO_SNDBUF, (Object)4096).childOption(ChannelOption.SO_KEEPALIVE, (Object)true).childHandler((ChannelHandler)this.winccChannelInitHandler);
        try {
            log.info("netty\u670d\u52a1\u5668\u5728[{}]\u7aef\u53e3\u542f\u52a8\u76d1\u542c", (Object)this.port);
            ChannelFuture future = bootstrap.bind(this.port).sync();
            if (future.isSuccess()) {
                nioServerSocketChannel = (NioServerSocketChannel)future.channel();
                log.info("netty\u670d\u52a1\u5f00\u542f\u6210\u529f" + nioServerSocketChannel);
            } else {
                log.info("netty\u670d\u52a1\u5f00\u542f\u5931\u8d25");
            }
            future.channel().closeFuture().sync();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            serverChannelEventGroup.shutdownGracefully();
            workerChannelEventGroup.shutdownGracefully();
        }
    }

    static {
        CHANNEL_MAP = new ConcurrentHashMap();
    }
}

