/*
 * Decompiled with CFR 0.152.
 */
package com.simba.services.push.manager.status;

import com.alibaba.fastjson2.JSONArray;
import com.alibaba.fastjson2.JSONObject;
import com.simba.services.bean.domain.MachineConfig;
import com.simba.services.bean.model.BalanceWheelDeviceInfo;
import com.simba.services.bean.model.DeviceInfoManager;
import com.simba.services.common.utils.DateUtils;
import com.simba.services.enums.RequestType;
import com.simba.services.helper.DatabaseHelper;
import com.simba.services.helper.StatusTranslatorHelper;
import com.simba.services.message.balancewheel.GridPosStatus;
import com.simba.services.message.balancewheel.HeartBreak;
import com.simba.services.message.balancewheel.LineStatus;
import com.simba.services.push.data.MachineData;
import com.simba.services.push.database.ConfigDevice.entity.ConfigDeviceEntity;
import com.simba.services.push.database.ConfigSorter.entity.ConfigSorterEntity;
import com.simba.services.push.database.DatabaseManagerBySorterConfig;
import com.simba.services.push.manager.status.UploadDataSaveToDB;
import com.simba.services.service.IStatusTranslator;
import com.simba.services.upload.status.SorterDatabaseMsg;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;
import javax.annotation.PostConstruct;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class WheelStatusManager {
    private static final Logger log = LoggerFactory.getLogger(WheelStatusManager.class);
    @Resource
    private DeviceInfoManager deviceInfoManager;
    @Resource
    private StatusTranslatorHelper statusTranslatorHelper;
    @Resource
    private DatabaseHelper databaseStatusHelper;
    @Resource
    private UploadDataSaveToDB uploadDataSaveToDB;
    @Resource
    private DatabaseManagerBySorterConfig databaseManagerBySorterConfig;
    private final ConcurrentHashMap<String, ConfigSorterEntity> sorterDeviceInfoMap = new ConcurrentHashMap();

    @PostConstruct
    private void init() {
        try {
            ArrayList<ConfigSorterEntity> newList = new ArrayList<ConfigSorterEntity>();
            List list = this.databaseManagerBySorterConfig.queryAllConfig(null);
            for (ConfigSorterEntity sorterEntity : list) {
                String sorterId = sorterEntity.getSorterId();
                String sortType = sorterEntity.getType();
                if (!sortType.equals("SL") && !sortType.equals("IL")) continue;
                newList.add(sorterEntity);
            }
            if (!newList.isEmpty()) {
                this.sorterDeviceInfoMap.clear();
                this.sorterDeviceInfoMap.putAll(newList.stream().collect(Collectors.toMap(ConfigSorterEntity::getSorterId, item -> item)));
            }
            log.info("[WheelStatusManager.init] sorterDeviceInfoMap size: {}", (Object)this.sorterDeviceInfoMap.size());
        }
        catch (Exception e) {
            log.error("[WheelStatusManager.init] Database query error: {}", (Object)e.getMessage());
        }
    }

    public void reReload() {
        this.init();
    }

    private void handlerRelationDeviceMessage(MachineData data, JSONArray jsonArray) {
        String[][] devices;
        String sorterId = "IL";
        int evenFlag = 1;
        int sorterStatus = 1;
        for (String[] device : devices = new String[][]{{"RD001", "\u4e3bPLC\u8fde\u63a5"}, {"RD002", "\u901a\u8baf\u673a\u8fde\u63a5"}, {"RD003", "\u6570\u636e\u5e93\u8fde\u63a5"}, {"RD004", "\u65b0\u4e00\u4ee3\u5bc4\u9012\u5e73\u53f0\u8fde\u63a5"}, {"RD005", "\u4e0e\u63a7\u5236\u4e2d\u5fc3(ADM)\u7684\u8fde\u63a5\u72b6\u6001"}}) {
            JSONObject itemJson = new JSONObject();
            itemJson.put((Object)"name", (Object)device[1]);
            itemJson.put((Object)"devId", (Object)(sorterId + "." + device[0]));
            itemJson.put((Object)"evenFlag", (Object)evenFlag);
            itemJson.put((Object)"sorterStatus", (Object)sorterStatus);
            jsonArray.add((Object)itemJson);
        }
    }

    public void handleStatusMessage(MachineData data, List<ConfigDeviceEntity> listValues) {
        List ILList = listValues.stream().filter(item -> item.getSorterId().startsWith("IL.")).collect(Collectors.toList());
        List SLList = listValues.stream().filter(item -> item.getSorterId().startsWith("SL.")).collect(Collectors.toList());
        this.handleMessage(data, ILList, "IL");
        this.handleMessage(data, SLList, "SL");
    }

    private void handleMessage(MachineData data, List<ConfigDeviceEntity> listValues, String lineType) {
        if (data == null) {
            return;
        }
        if (listValues == null || listValues.isEmpty()) {
            return;
        }
        int requestInterval = data.getStatusSendingInterval();
        JSONArray obrListMsg = new JSONArray();
        JSONArray carrierListMsg = new JSONArray();
        JSONArray inductListMsg = new JSONArray();
        JSONArray grayscaleListMsg = new JSONArray();
        JSONArray physicalPosListMsg = new JSONArray();
        JSONArray dynamicScaleListMsg = new JSONArray();
        JSONArray electricMotorListMsg = new JSONArray();
        JSONArray relationDeviceListMsg = new JSONArray();
        JSONArray sorterListMsg = new JSONArray();
        JSONArray sorterDatabaseListMsg = new JSONArray();
        JSONArray wheelBeltListMsg = new JSONArray();
        JSONArray linesListMsg = new JSONArray();
        ConcurrentHashMap map = listValues.stream().collect(Collectors.groupingBy(ConfigDeviceEntity::getDevType, ConcurrentHashMap::new, Collectors.toList()));
        for (String devType : map.keySet()) {
            List list = (List)map.get(devType);
            switch (devType) {
                case "DynamicScale": {
                    int defaultStatus = 0;
                    String deviceType = "6";
                    this.CreateJson(data, list, defaultStatus, deviceType, dynamicScaleListMsg);
                    break;
                }
                case "Obr": {
                    int defaultStatus = 0;
                    String deviceType = "4";
                    this.CreateJson(data, list, defaultStatus, deviceType, obrListMsg);
                    break;
                }
                case "PhysicalPos": {
                    int defaultStatus = 0;
                    String deviceType = "5";
                    this.CreateJson(data, list, defaultStatus, deviceType, physicalPosListMsg);
                    break;
                }
                case "WheelBelt": {
                    int defaultStatus = 0;
                    String deviceType = "14";
                    this.CreateJson(data, list, defaultStatus, deviceType, wheelBeltListMsg);
                    break;
                }
            }
        }
        this.handleSorterStatusMessage(data, sorterListMsg, lineType);
        this.handleSorterDatabaseMessage(data, sorterDatabaseListMsg);
        this.handlerRelationDeviceMessage(data, relationDeviceListMsg);
        this.handleLineListMessage(data, linesListMsg, lineType);
        String sorterId = data.getMachineId();
        String sorterName = data.getMachineName();
        String collectTime = DateUtils.getTime();
        JSONObject jsonObject = new JSONObject();
        jsonObject.put((Object)"sorterId", (Object)sorterId);
        jsonObject.put((Object)"sorterName", (Object)sorterName);
        jsonObject.put((Object)"collectTime", (Object)collectTime);
        jsonObject.put((Object)"requestInterval", (Object)requestInterval);
        jsonObject.put((Object)"obrListMsg", (Object)obrListMsg);
        jsonObject.put((Object)"carrierListMsg", (Object)carrierListMsg);
        jsonObject.put((Object)"inductListMsg", (Object)inductListMsg);
        jsonObject.put((Object)"grayscaleListMsg", (Object)grayscaleListMsg);
        jsonObject.put((Object)"physicalPosListMsg", (Object)physicalPosListMsg);
        jsonObject.put((Object)"dynamicScaleListMsg", (Object)dynamicScaleListMsg);
        jsonObject.put((Object)"electricMotorListMsg", (Object)electricMotorListMsg);
        jsonObject.put((Object)"relationDeviceListMsg", (Object)relationDeviceListMsg);
        jsonObject.put((Object)"wheelBeltListMsg", (Object)wheelBeltListMsg);
        jsonObject.put((Object)"linesListMsg", (Object)linesListMsg);
        jsonObject.put((Object)"sorterListMsg", (Object)sorterListMsg);
        jsonObject.put((Object)"sorterDatabaseListMsg", (Object)sorterDatabaseListMsg);
        this.uploadDataSaveToDB.saveToDb(data, jsonObject, RequestType.DEVICE_STATUS.getCode());
    }

    private void handleLineListMessage(MachineData data, JSONArray jsonArray, String lineType) {
        try {
            int defaultStatus = 5;
            String deviceType = "1";
            IStatusTranslator translator = this.statusTranslatorHelper.getTranslator(deviceType);
            String sorterStatus = translator.translate("1", defaultStatus);
            for (Map.Entry entry : this.sorterDeviceInfoMap.entrySet()) {
                String sorterId = (String)entry.getKey();
                ConfigSorterEntity sorter = (ConfigSorterEntity)entry.getValue();
                String sorterType = sorter.getType();
                if (!sorterType.equals(lineType)) continue;
                HeartBreak heartBreak = (HeartBreak)this.deviceInfoManager.getBalanceWheelDeviceInfo().getHeartBreakMap().get(String.valueOf(sorter.getLineNum()));
                if (heartBreak != null) {
                    int fixedStatus = heartBreak.getSystemStatus();
                    if (fixedStatus == 1) {
                        fixedStatus = 5;
                    }
                    sorterStatus = translator.translate("1", fixedStatus);
                }
                JSONObject itemJson = new JSONObject();
                itemJson.put((Object)"name", (Object)sorter.getSorterName());
                itemJson.put((Object)"devId", (Object)sorter.getSorterId());
                itemJson.put((Object)"evenFlag", (Object)1);
                itemJson.put((Object)"sorterStatus", (Object)sorterStatus);
                jsonArray.add((Object)itemJson);
            }
        }
        catch (Exception e) {
            log.error("[WheelStatusManager.handleLineListMessage] error:{}", (Object)e.getMessage());
        }
    }

    private void handleSorterDatabaseMessage(MachineData data, JSONArray sorterDatabaseListMsg) {
        try {
            MachineConfig machine = new MachineConfig();
            machine.setMachineName(data.getMachineName());
            machine.setReferenceSchema(data.getReferenceSchema());
            SorterDatabaseMsg msg = this.databaseStatusHelper.createDatabaseMsg(machine);
            if (msg == null) {
                return;
            }
            JSONObject msgJson = new JSONObject();
            msgJson.put((Object)"ipAddr", (Object)msg.getIpAddr());
            msgJson.put((Object)"tablespaceName", (Object)msg.getTablespaceName());
            msgJson.put((Object)"totalSize", (Object)msg.getTotalSize());
            msgJson.put((Object)"usedSize", (Object)msg.getUsedSize());
            msgJson.put((Object)"usedRate", (Object)msg.getUsedRate());
            sorterDatabaseListMsg.add((Object)msgJson);
        }
        catch (Exception e) {
            log.error("[WheelStatusManager.handleSorterDatabaseMessage] error:{}", (Object)e.getMessage());
        }
    }

    private void CreateJson(MachineData data, List<ConfigDeviceEntity> list, int defaultStatus, String deviceType, JSONArray jsonArray) {
        if (data == null) {
            return;
        }
        try {
            for (ConfigDeviceEntity entity : list) {
                String newDeviceType = entity.getDevType();
                if ("WheelBelt".equals(newDeviceType)) {
                    String subType = entity.getDevSubType();
                    deviceType = "BalanceWheel".equals(subType) ? "13" : "14";
                }
                int seqNo = entity.getSeqNo();
                String sorterStatus = "";
                IStatusTranslator translator = this.statusTranslatorHelper.getTranslator(deviceType);
                if (translator == null) {
                    return;
                }
                String defaultPostStatus = translator.translate("1", defaultStatus);
                String ip = data.getPlcIp();
                BalanceWheelDeviceInfo info = this.deviceInfoManager.getBalanceWheelDeviceInfo();
                if (info != null) {
                    int index = seqNo - 1;
                    if (index < 0) {
                        index = 0;
                    }
                    short length = 0;
                    Object status = null;
                    String lineNumStr = String.valueOf(entity.getLineNum());
                    switch (deviceType) {
                        case "4": {
                            HeartBreak heartBreak = (HeartBreak)info.getHeartBreakMap().get(lineNumStr);
                            if (heartBreak == null) break;
                            sorterStatus = translator.translate("1", (int)heartBreak.getCameraStatus());
                            break;
                        }
                        case "5": {
                            GridPosStatus oldOne = (GridPosStatus)info.getGridPosStatusMap().get(lineNumStr);
                            if (oldOne == null || index > (length = oldOne.getCount())) break;
                            byte newStatus = oldOne.getStatusArr()[index];
                            sorterStatus = translator.translate("1", (int)newStatus);
                            break;
                        }
                        case "6": {
                            LineStatus lineStatus = (LineStatus)info.getLineStatusMap().get(lineNumStr);
                            if (lineStatus == null || index > (length = lineStatus.getCount())) break;
                            byte newStatus = lineStatus.getStatusArr()[index];
                            sorterStatus = translator.translate("1", (int)newStatus);
                            break;
                        }
                        case "13": {
                            LineStatus status1 = (LineStatus)info.getLineStatusMap().get(lineNumStr);
                            if (status1 == null || index > (length = status1.getCount())) break;
                            byte newStatus = status1.getStatusArr()[index];
                            sorterStatus = translator.translate("1", (int)newStatus);
                            break;
                        }
                    }
                }
                JSONObject itemJson = new JSONObject();
                itemJson.put((Object)"name", (Object)entity.getDevName());
                itemJson.put((Object)"devId", (Object)entity.getDevId());
                itemJson.put((Object)"evenFlag", (Object)1);
                itemJson.put((Object)"sorterStatus", (Object)sorterStatus);
                if (sorterStatus == null || sorterStatus.isEmpty()) {
                    itemJson.put((Object)"sorterStatus", (Object)defaultPostStatus);
                }
                jsonArray.add((Object)itemJson);
            }
        }
        catch (Exception e) {
            jsonArray = new JSONArray();
            log.error("[WheelStatusManager.CreateJson] Catch on exception:{}", (Object)e.getMessage());
        }
    }

    private void handleSorterStatusMessage(MachineData data, JSONArray jsonArray, String lineType) {
        IStatusTranslator translator = this.statusTranslatorHelper.getTranslator("1");
        String sorterStatus = translator.translate("1", 0);
        JSONObject itemJson = new JSONObject();
        String name = lineType.equals("IL") ? "\u77e9\u9635\u5206\u62e3\u673a\u521d\u5206\u7ebf" : "\u77e9\u9635\u5206\u62e3\u673a\u7ec6\u5206\u7ebf";
        itemJson.put((Object)"name", (Object)name);
        itemJson.put((Object)"devId", (Object)lineType);
        itemJson.put((Object)"evenFlag", (Object)1);
        itemJson.put((Object)"sorterStatus", (Object)sorterStatus);
        jsonArray.add((Object)itemJson);
    }
}

