/*
 * Decompiled with CFR 0.152.
 */
package com.simba.services.push.manager.status;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson2.JSONObject;
import com.simba.services.bean.domain.UploadData;
import com.simba.services.common.utils.DateUtils;
import com.simba.services.common.utils.uuid.UUID;
import com.simba.services.config.WinccConfig;
import com.simba.services.enums.UploadDataStatus;
import com.simba.services.helper.UploadDataHelper;
import com.simba.services.push.data.MachineData;
import com.simba.services.util.TokenUtils;
import java.util.Date;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class UploadDataSaveToDB {
    private static final Logger log = LoggerFactory.getLogger(UploadDataSaveToDB.class);
    @Resource
    private UploadDataHelper uploadDataHelper;
    @Resource
    private WinccConfig.ManufacturerConfig manufacturerConfig;

    public void saveToDb(MachineData data, JSONObject jsonObject, String type) {
        try {
            UploadData uploadData = new UploadData();
            uploadData.setRequestBody(JSON.toJSONString((Object)jsonObject));
            uploadData.setFormat("JSON");
            uploadData.setMachineId(data.getMachineId());
            uploadData.setManufacturerId(this.manufacturerConfig.getId());
            String requestId = UUID.randomUUID((boolean)true).toString(true);
            Date now = new Date();
            String requestTimeStr = TokenUtils.formatDate((Date)now);
            uploadData.setRequestId(requestId);
            uploadData.setRequestTime(DateUtils.dateTime((String)DateUtils.YYYY_MM_DD_HH_MM_SS, (String)requestTimeStr));
            uploadData.setStatus(UploadDataStatus.INIT.getCode());
            String token = TokenUtils.getToken((String)requestId, (String)requestTimeStr, (String)this.manufacturerConfig.getSecretKey());
            uploadData.setToken(token);
            uploadData.setType(type);
            uploadData.setResponse("{}");
            this.uploadDataHelper.saveUploadData(uploadData);
        }
        catch (Exception e) {
            log.error("[UploadDataSaveToDB.saveToDb] Catch on exception:{}", (Object)e.getMessage());
        }
    }
}

