/*
 * Decompiled with CFR 0.152.
 */
package com.simba.services.push.manager.status;

import com.alibaba.fastjson2.JSONArray;
import com.alibaba.fastjson2.JSONObject;
import com.simba.services.bean.domain.MachineConfig;
import com.simba.services.bean.model.DeviceInfoManager;
import com.simba.services.bean.model.SorterDeviceInfo;
import com.simba.services.common.utils.DateUtils;
import com.simba.services.enums.RequestType;
import com.simba.services.helper.DatabaseHelper;
import com.simba.services.helper.MachineHelper;
import com.simba.services.helper.StatusTranslatorHelper;
import com.simba.services.message.sorter.HeartBreak;
import com.simba.services.push.data.MachineData;
import com.simba.services.push.database.ConfigDevice.entity.ConfigDeviceEntity;
import com.simba.services.push.manager.status.UploadDataSaveToDB;
import com.simba.services.service.IStatusTranslator;
import com.simba.services.upload.status.SorterDatabaseMsg;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class SorterStatusManager {
    private static final Logger log = LoggerFactory.getLogger(SorterStatusManager.class);
    @Resource
    private DeviceInfoManager deviceInfoManager;
    @Resource
    private StatusTranslatorHelper statusTranslatorHelper;
    @Resource
    private UploadDataSaveToDB uploadDataSaveToDB;
    @Resource
    private DatabaseHelper databaseStatusHelper;
    @Resource
    private MachineHelper machineHelper;

    private void handlerRelationDeviceMessage(MachineData data, List<ConfigDeviceEntity> listValues, JSONArray jsonArray) {
        String[][] devices;
        String sorterId = "ST01";
        int evenFlag = 1;
        int sorterStatus = 1;
        for (String[] device : devices = new String[][]{{"RD001", "\u4e3bPLC\u8fde\u63a5"}, {"RD002", "\u901a\u8baf\u673a\u8fde\u63a5"}, {"RD003", "\u6570\u636e\u5e93\u8fde\u63a5"}, {"RD004", "\u65b0\u4e00\u4ee3\u5bc4\u9012\u5e73\u53f0\u8fde\u63a5"}, {"RD005", "\u4e0e\u63a7\u5236\u4e2d\u5fc3(ADM)\u7684\u8fde\u63a5\u72b6\u6001"}}) {
            JSONObject itemJson = new JSONObject();
            itemJson.put((Object)"name", (Object)device[1]);
            itemJson.put((Object)"devId", (Object)(sorterId + "." + device[0]));
            itemJson.put((Object)"evenFlag", (Object)evenFlag);
            itemJson.put((Object)"sorterStatus", (Object)sorterStatus);
            jsonArray.add((Object)itemJson);
        }
    }

    public void handleStatusMessage(MachineData data, List<ConfigDeviceEntity> listValues) {
        this.handleMessage(data, listValues);
    }

    private void handleMessage(MachineData data, List<ConfigDeviceEntity> listValues) {
        if (data == null || listValues == null || listValues.isEmpty()) {
            return;
        }
        JSONArray obrListMsg = new JSONArray();
        JSONArray carrierListMsg = new JSONArray();
        JSONArray inductListMsg = new JSONArray();
        JSONArray grayscaleListMsg = new JSONArray();
        JSONArray physicalPosListMsg = new JSONArray();
        JSONArray dynamicScaleListMsg = new JSONArray();
        JSONArray electricMotorListMsg = new JSONArray();
        JSONArray relationDeviceListMsg = new JSONArray();
        JSONArray sorterListMsg = new JSONArray();
        JSONArray sorterDatabaseListMsg = new JSONArray();
        ConcurrentHashMap map = listValues.stream().collect(Collectors.groupingBy(ConfigDeviceEntity::getDevType, ConcurrentHashMap::new, Collectors.toList()));
        for (String devType : map.keySet()) {
            List list = (List)map.get(devType);
            switch (devType) {
                case "Obr": {
                    String deviceType = "4";
                    int defaultStatus = 0;
                    this.CreateJson(data, list, defaultStatus, deviceType, obrListMsg);
                    break;
                }
                case "PlatObr": {
                    String deviceType = "17";
                    int defaultStatus = 0;
                    this.CreateJson(data, list, defaultStatus, deviceType, obrListMsg);
                    break;
                }
                case "Induct": {
                    String deviceType = "2";
                    int defaultStatus = 0;
                    this.CreateJson(data, list, defaultStatus, deviceType, inductListMsg);
                    break;
                }
                case "PhysicalPos": {
                    int defaultStatus = 0;
                    String deviceType = "5";
                    this.CreateJson(data, list, defaultStatus, deviceType, physicalPosListMsg);
                    break;
                }
                case "Carrier": {
                    int defaultStatus = 0;
                    String deviceType = "3";
                    this.CreateJson(data, list, defaultStatus, deviceType, carrierListMsg);
                    break;
                }
                case "DynamicScale": {
                    int defaultStatus = 0;
                    String deviceType = "6";
                    this.CreateJson(data, list, defaultStatus, deviceType, dynamicScaleListMsg);
                    break;
                }
                case "ElectricMotor": {
                    int defaultStatus = 0;
                    String deviceType = "8";
                    this.CreateJson(data, list, defaultStatus, deviceType, electricMotorListMsg);
                    break;
                }
                case "Gray": {
                    int defaultStatus = 0;
                    String deviceType = "7";
                    this.CreateJson(data, list, defaultStatus, deviceType, grayscaleListMsg);
                    break;
                }
            }
        }
        this.handleSorterStatusMessage(data, listValues, sorterListMsg);
        this.handlerRelationDeviceMessage(data, listValues, relationDeviceListMsg);
        this.handleSorterDatabaseMessage(data, listValues, sorterDatabaseListMsg);
        String sorterId = data.getMachineId();
        String sorterName = data.getMachineName();
        String collectTime = DateUtils.getTime();
        int requestInterval = data.getStatusSendingInterval();
        JSONObject jsonObject = new JSONObject();
        jsonObject.put((Object)"sorterId", (Object)sorterId);
        jsonObject.put((Object)"sorterName", (Object)sorterName);
        jsonObject.put((Object)"collectTime", (Object)collectTime);
        jsonObject.put((Object)"requestInterval", (Object)requestInterval);
        jsonObject.put((Object)"obrListMsg", (Object)obrListMsg);
        jsonObject.put((Object)"carrierListMsg", (Object)carrierListMsg);
        jsonObject.put((Object)"inductListMsg", (Object)inductListMsg);
        jsonObject.put((Object)"grayscaleListMsg", (Object)grayscaleListMsg);
        jsonObject.put((Object)"physicalPosListMsg", (Object)physicalPosListMsg);
        jsonObject.put((Object)"dynamicScaleListMsg", (Object)dynamicScaleListMsg);
        jsonObject.put((Object)"electricMotorListMsg", (Object)electricMotorListMsg);
        jsonObject.put((Object)"relationDeviceListMsg", (Object)relationDeviceListMsg);
        jsonObject.put((Object)"sorterListMsg", (Object)sorterListMsg);
        jsonObject.put((Object)"sorterDatabaseListMsg", (Object)sorterDatabaseListMsg);
        log.info("[SorterStatusManager.handleStatusMessage] all message push! sorterId:{} sorterName:{} json:{}", new Object[]{sorterId, sorterName, jsonObject});
        this.uploadDataSaveToDB.saveToDb(data, jsonObject, RequestType.DEVICE_STATUS.getCode());
        this.createEvents(data, jsonObject);
    }

    private void createEvents(MachineData data, JSONObject jsonObject) {
        List machineList = this.machineHelper.getMachineList();
        for (MachineConfig machine : machineList) {
            String machineId = machine.getMachineId();
            if (!machineId.equals(data.getMachineId())) continue;
        }
    }

    private void handleSorterStatusMessage(MachineData data, List<ConfigDeviceEntity> listValues, JSONArray jsonArray) {
        HeartBreak heartBreak;
        String deviceType = "1";
        IStatusTranslator translator = this.statusTranslatorHelper.getTranslator(deviceType);
        if (translator == null) {
            log.info("[SorterStatusManager.handleSorterMessage] no translator");
            return;
        }
        String sorterStatus = translator.translate("1", 0);
        String runningSpeed = "0";
        String sorterId = "ST01";
        String name = "\u5355\u5c42\u5206\u62e3\u673a";
        JSONObject itemJson = new JSONObject();
        itemJson.put((Object)"name", (Object)name);
        itemJson.put((Object)"devId", (Object)sorterId);
        itemJson.put((Object)"evenFlag", (Object)1);
        itemJson.put((Object)"runningSpeed", (Object)runningSpeed);
        itemJson.put((Object)"sorterStatus", (Object)sorterStatus);
        String ip = data.getPlcIp();
        SorterDeviceInfo info = (SorterDeviceInfo)this.deviceInfoManager.getSorterDeviceInfoMap().get(ip);
        if (info != null && (heartBreak = info.getHeartBreak()) != null) {
            sorterStatus = translator.translate("1", (int)heartBreak.getSystemStatus());
            runningSpeed = String.format("%.3f", Float.valueOf((float)heartBreak.getSystemSpeed() / 1000.0f));
            itemJson.put((Object)"runningSpeed", (Object)runningSpeed);
            itemJson.put((Object)"sorterStatus", (Object)sorterStatus);
        }
        jsonArray.add((Object)itemJson);
    }

    private void handleSorterDatabaseMessage(MachineData data, List<ConfigDeviceEntity> listValues, JSONArray sorterDatabaseListMsg) {
        try {
            MachineConfig machine = new MachineConfig();
            machine.setMachineName(data.getMachineName());
            machine.setReferenceSchema(data.getReferenceSchema());
            SorterDatabaseMsg msg = this.databaseStatusHelper.createDatabaseMsg(machine);
            if (msg == null) {
                return;
            }
            JSONObject msgJson = new JSONObject();
            msgJson.put((Object)"ipAddr", (Object)msg.getIpAddr());
            msgJson.put((Object)"tablespaceName", (Object)msg.getTablespaceName());
            msgJson.put((Object)"totalSize", (Object)msg.getTotalSize());
            msgJson.put((Object)"usedSize", (Object)msg.getUsedSize());
            msgJson.put((Object)"usedRate", (Object)msg.getUsedRate());
            sorterDatabaseListMsg.add((Object)msgJson);
        }
        catch (Exception e) {
            log.error("[WheelStatusManager.handleSorterDatabaseMessage] error:{}", (Object)e.getMessage());
        }
    }

    private void CreateJson(MachineData data, List<ConfigDeviceEntity> list, int defaultStatus, String deviceType, JSONArray jsonArray) {
        if (data == null) {
            return;
        }
        try {
            for (ConfigDeviceEntity entity : list) {
                int seqNo = entity.getSeqNo();
                String sorterStatus = "";
                IStatusTranslator translator = this.statusTranslatorHelper.getTranslator(deviceType);
                if (translator == null) {
                    log.info("[SorterStatusManager.handleSorterMessage] no translator");
                    return;
                }
                String defaultPostStatus = translator.translate("1", defaultStatus);
                String ip = data.getPlcIp();
                SorterDeviceInfo info = (SorterDeviceInfo)this.deviceInfoManager.getSorterDeviceInfoMap().get(ip);
                if (info != null) {
                    int index = seqNo - 1;
                    if (index < 0) {
                        index = 0;
                    }
                    int length = 0;
                    switch (deviceType) {
                        case "4": {
                            sorterStatus = translator.translate("1", 0);
                            break;
                        }
                        case "17": {
                            sorterStatus = translator.translate("1", 0);
                            break;
                        }
                        case "3": {
                            length = info.getCarrierStatus().length();
                            if (index > length) break;
                            byte newStatus = info.getCarrierStatus().getStatusArr()[index];
                            sorterStatus = translator.translate("1", (int)newStatus);
                            break;
                        }
                        case "5": {
                            length = info.getGridPosStatus().length();
                            if (index > length) break;
                            byte newStatus = info.getGridPosStatus().getStatusArr()[index];
                            sorterStatus = translator.translate("1", (int)newStatus);
                            break;
                        }
                        case "2": {
                            length = info.getInductStatus().length();
                            if (index > length) break;
                            byte newStatus = info.getInductStatus().getStatusArr()[index];
                            sorterStatus = translator.translate("1", (int)newStatus);
                            break;
                        }
                        case "8": {
                            length = info.getElectricMotorStatus().length();
                            if (index > length) break;
                            byte newStatus = info.getElectricMotorStatus().getStatusArr()[index];
                            sorterStatus = translator.translate("1", (int)newStatus);
                            break;
                        }
                        case "7": {
                            if (info.getPlcStatus() == null || index > (length = info.getPlcStatus().getGrayscale().length())) break;
                            byte newStatus = info.getPlcStatus().getGrayscale().getStatusArr()[index];
                            sorterStatus = translator.translate("1", (int)newStatus);
                            break;
                        }
                        case "6": {
                            length = info.getInductStatus().length();
                            if (index > length) break;
                            byte newStatus = info.getInductStatus().getStatusArr()[index];
                            int intStatus = newStatus == 3 ? 1 : 2;
                            sorterStatus = translator.translate("1", intStatus);
                            break;
                        }
                    }
                }
                JSONObject itemJson = new JSONObject();
                itemJson.put((Object)"name", (Object)entity.getDevName());
                itemJson.put((Object)"devId", (Object)entity.getDevId());
                itemJson.put((Object)"evenFlag", (Object)1);
                itemJson.put((Object)"sorterStatus", (Object)sorterStatus);
                if (sorterStatus == null || sorterStatus.isEmpty()) {
                    itemJson.put((Object)"sorterStatus", (Object)defaultPostStatus);
                }
                jsonArray.add((Object)itemJson);
            }
        }
        catch (Exception e) {
            jsonArray = new JSONArray();
            log.error("[SorterStatusManager.CreateJson] Catch on exception:{}", (Object)e.getMessage());
        }
    }
}

