/*
 * Decompiled with CFR 0.152.
 */
package com.simba.services.push.manager;

import com.simba.services.bean.domain.UploadData;
import com.simba.services.common.utils.bean.BeanUtils;
import com.simba.services.common.utils.spring.SpringUtils;
import com.simba.services.enums.UploadDataStatus;
import com.simba.services.push.database.DatabaseManagerByUploadData;
import com.simba.services.push.database.RecordUpload.entity.RecordUploadEntity;
import com.simba.services.push.manager.NewStatusManager;
import com.simba.services.push.manager.SendMessageManager;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class UploadDataManager {
    private static final Logger log = LoggerFactory.getLogger(UploadDataManager.class);
    @Resource
    private NewStatusManager newStatusManager;
    @Resource
    private SendMessageManager sendMessageManager;

    public void handleUploadMessage() {
        try {
            List list = ((DatabaseManagerByUploadData)SpringUtils.getBean(DatabaseManagerByUploadData.class)).queryAllData(null);
            ConcurrentHashMap map = list.stream().collect(Collectors.groupingBy(RecordUploadEntity::getMachineId, ConcurrentHashMap::new, Collectors.toList()));
            for (String machineId : map.keySet()) {
                List groupList = (List)map.get(machineId);
                this.handleMachineData(machineId, groupList);
            }
        }
        catch (Exception e) {
            log.error("[UploadStatusManager.handleUploadMessage] Catch on exception:{}", (Object)e.getMessage());
        }
    }

    private void handleMachineData(String machineId, List<RecordUploadEntity> groupList) {
        log.info("[UploadStatusManager.handleMachineData] \u5f00\u59cb\u5904\u7406machineId:{}\u7684\u6570\u636e", (Object)machineId);
        try {
            for (RecordUploadEntity entity : groupList) {
                UploadData data = new UploadData();
                BeanUtils.copyProperties((Object)entity, (Object)data);
                boolean sent = this.sendMessageManager.sendMessage(data);
                if (sent) {
                    entity.setStatus(UploadDataStatus.FINISHED.getCode());
                    entity.setResponse(data.getResponse());
                } else {
                    entity.setStatus(UploadDataStatus.FAILED.getCode());
                    entity.setResponse("\u8bf7\u6c42\u5931\u8d25! " + data.getResponse());
                }
                entity.setRetryCount(Integer.valueOf(entity.getRetryCount() + 1));
                boolean bl = ((DatabaseManagerByUploadData)SpringUtils.getBean(DatabaseManagerByUploadData.class)).updateDataById(entity);
            }
        }
        catch (Exception e) {
            log.error("[UploadStatusManager.handleMachineData] Catch on exception:{}", (Object)e.getMessage());
        }
    }
}

