/*
 * Decompiled with CFR 0.152.
 */
package com.simba.services.push.manager;

import com.simba.services.bean.domain.MachineConfig;
import com.simba.services.helper.BalanceWheelDeviceStatusHelper;
import com.simba.services.helper.DeviceStatusHelper;
import com.simba.services.helper.MachineHelper;
import com.simba.services.helper.SortDataHelper;
import com.simba.services.helper.SorterDeviceStatusHelper;
import com.simba.services.push.manager.NewStatusManager;
import java.util.List;
import java.util.UUID;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class UploadDataGenerateManager {
    private static final Logger log = LoggerFactory.getLogger(UploadDataGenerateManager.class);
    @Resource
    private MachineHelper machineHelper;
    @Resource
    private DeviceStatusHelper deviceStatusHelper;
    @Resource
    private BalanceWheelDeviceStatusHelper balanceWheelDeviceStatusHelper;
    @Resource
    private SorterDeviceStatusHelper sorterDeviceStatusHelper;
    @Resource
    private SortDataHelper sortDataHelper;
    @Resource
    private NewStatusManager newStatusManager;

    public void handleGenerateData() {
        String uuid = UUID.randomUUID().toString();
        this.handleGenerateDataOld(uuid);
        this.handleGenerateSortingData();
    }

    private void handleGenerateSortingData() {
        log.info("[UploadDataGenerateManager.handleGenerateSortingData] \u751f\u6210\u5206\u62e3\u6570\u636e...");
        List machineList = this.machineHelper.getMachineList();
        for (MachineConfig machine : machineList) {
            if (machine.getDataSendingInterval() > 0L) {
                this.sortDataHelper.createForMachine(machine);
                continue;
            }
            log.info("[UploadDataGenerateManager.handleGenerateSortingData] \u5206\u62e3\u673a\u7684\u5206\u62e3\u6570\u636e\u4e0a\u62a5\u5f00\u5173\u672a\u6253\u5f00\uff0c\u8df3\u8fc7\u6b64\u5206\u62e3\u673a: {}({})\u3002", (Object)machine.getMachineId(), (Object)machine.getMachineName());
        }
    }

    public void handleGenerateDataOld(String uuid) {
        try {
            List machineList = this.machineHelper.getMachineList();
            for (MachineConfig machine : machineList) {
                if (machine.getStatusSendingInterval() <= 0L) continue;
                if (this.machineHelper.isSorterTypeOfWheel(machine)) {
                    this.balanceWheelDeviceStatusHelper.createDeviceStatusUploadData(machine);
                    continue;
                }
                this.sorterDeviceStatusHelper.createDeviceStatusUploadData(machine);
            }
            log.info("[UploadDataGenerateManager.handleGenerateData][old][uuid:{}] \u7ed3\u675f\u751f\u6210\u5168\u91cf\u6570\u636e!", (Object)uuid);
        }
        catch (Exception e) {
            log.error("[UploadStatusManager.handleGenerateData] Catch on exception:{}", (Object)e.getMessage());
        }
    }

    public void handleGenerateDataNew(String uuid) {
        log.info("[UploadDataGenerateManager.handleGenerateDataNew][uuid:{}] \u5f00\u59cb\u751f\u6210\u5168\u91cf\u6570\u636e!", (Object)uuid);
        this.newStatusManager.handleAutoUploadMessage();
        log.info("[UploadDataGenerateManager.handleGenerateDataNew][uuid:{}] \u7ed3\u675f\u751f\u6210\u5168\u91cf\u6570\u636e!", (Object)uuid);
    }
}

