/*
 * Decompiled with CFR 0.152.
 */
package com.simba.services.push.manager;

import com.alibaba.fastjson.JSON;
import com.simba.services.bean.domain.UploadData;
import com.simba.services.bean.response.CommonRes;
import com.simba.services.common.utils.okhttp.OkHttpUtil;
import com.simba.services.common.utils.spring.SpringUtils;
import com.simba.services.config.WinccConfig;
import com.simba.services.enums.RequestType;
import com.simba.services.helper.UploadDataHelper;
import com.simba.services.util.HttpUtils;
import com.simba.services.util.TokenUtils;
import java.util.Date;
import java.util.HashMap;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class SendMessageManager {
    private static final Logger log = LoggerFactory.getLogger(SendMessageManager.class);
    @Resource
    private WinccConfig.DeviceStatusUploadConfig statusConfig;
    @Resource
    private WinccConfig.DeviceEventUploadConfig eventConfig;
    @Resource
    private WinccConfig.SortDataUploadConfig dataConfig;
    @Resource
    private OkHttpUtil okHttpUtil;
    @Resource
    private HttpUtils httpUtils;

    public boolean sendMessage(UploadData data) {
        try {
            UploadData disappearData;
            log.info("[SendMessageManager.sendMessage] \u5f00\u59cb\u53d1\u9001\u6d88\u606f\u7ed9\u90ae\u653f");
            if (RequestType.DEVICE_STATUS.getCode().equals(data.getType())) {
                UploadData disappearData2 = ((UploadDataHelper)SpringUtils.getBean(UploadDataHelper.class)).createUploadDataForDisappear(data);
                if (disappearData2 != null) {
                    boolean bl = this.forSendData(disappearData2, (byte)0);
                }
            } else if (RequestType.DEVICE_EVENT.getCode().equals(data.getType()) && (disappearData = ((UploadDataHelper)SpringUtils.getBean(UploadDataHelper.class)).createUploadDataForDisappear(data)) != null) {
                boolean bl = this.forSendData(disappearData, (byte)0);
            }
            return this.forSendData(data, (byte)1);
        }
        catch (Exception e) {
            return false;
        }
    }

    private boolean forSendData(UploadData data, byte happen) {
        try {
            HashMap<String, String> params = new HashMap<String, String>();
            params.put("request_id", data.getRequestId());
            params.put("manufacturer_id", data.getManufacturerId());
            params.put("token", data.getToken());
            params.put("format", data.getFormat());
            params.put("request_body", data.getRequestBody());
            String requestTimeStr = TokenUtils.formatDate((Date)data.getRequestTime());
            params.put("request_time", requestTimeStr);
            String url = RequestType.DEVICE_STATUS.getCode().equals(data.getType()) ? this.statusConfig.getUrl() : (RequestType.DEVICE_EVENT.getCode().equals(data.getType()) ? this.eventConfig.getUrl() : this.dataConfig.getUrl());
            String response = this.okHttpUtil.forwardPostFormUrlEncoded(url, params, true);
            if (response != null) {
                data.setResponse(response);
                CommonRes res = (CommonRes)JSON.parseObject((String)response, CommonRes.class);
                return res.getStatus() == 0;
            }
            data.setResponse("No Response!");
            return false;
        }
        catch (Exception e) {
            return false;
        }
    }
}

