/*
 * Decompiled with CFR 0.152.
 */
package com.simba.services.push.manager;

import com.simba.services.push.data.MachineData;
import com.simba.services.push.database.ConfigDevice.entity.ConfigDeviceEntity;
import com.simba.services.push.database.ConfigMachine.entity.ConfigMachineEntity;
import com.simba.services.push.database.DatabaseManagerByDeviceConfig;
import com.simba.services.push.database.DatabaseManagerByMachineConfig;
import com.simba.services.push.manager.status.SorterStatusManager;
import com.simba.services.push.manager.status.WheelStatusManager;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;
import javax.annotation.PostConstruct;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeansException;
import org.springframework.stereotype.Service;

@Service
public class NewStatusManager {
    private static final Logger log = LoggerFactory.getLogger(NewStatusManager.class);
    @Resource
    private SorterStatusManager sorterStatusManager;
    @Resource
    private WheelStatusManager wheelStatusManager;
    @Resource
    private DatabaseManagerByMachineConfig databaseManagerByMachineConfig;
    @Resource
    private DatabaseManagerByDeviceConfig databaseManagerByDeviceConfig;
    private final ConcurrentHashMap<Integer, MachineData> machineIdMap = new ConcurrentHashMap();
    private final ConcurrentHashMap<Integer, List<ConfigDeviceEntity>> sorterList = new ConcurrentHashMap();
    private final ConcurrentHashMap<Integer, List<ConfigDeviceEntity>> deviceList = new ConcurrentHashMap();

    @PostConstruct
    private void init() {
        this.initMachineList();
        this.initDeviceList();
    }

    public boolean reReload() {
        try {
            this.initMachineList();
            this.initDeviceList();
            this.wheelStatusManager.reReload();
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    private void initMachineList() {
        try {
            List queryAllConfig = this.databaseManagerByMachineConfig.queryAllConfig(null);
            if (queryAllConfig == null) {
                log.error("[SyncUploadTask.init] queryAllConfig is null");
                return;
            }
            for (ConfigMachineEntity machineEntity : queryAllConfig) {
                String machineId = machineEntity.getMachineId();
                MachineData machineData = new MachineData();
                machineData.setMachineId(machineEntity.getMachineId());
                machineData.setMachineName(machineEntity.getMachineName());
                machineData.setMachineType(machineEntity.getType());
                machineData.setManufacturer_id(machineEntity.getManufacturerId());
                machineData.setMachineLocation("SHDJ");
                machineData.setPlcIp(machineEntity.getPlcIp());
                machineData.setReferenceSchema(machineEntity.getReferenceSchema());
                machineData.setStatusSendingInterval(machineEntity.getStatusSendingInterval());
                this.machineIdMap.put(Integer.valueOf(machineId), machineData);
            }
            log.info("[SyncUploadTask.init] Start to init sync task. list size:{}", (Object)this.machineIdMap.size());
        }
        catch (Exception e) {
            log.error("[SyncUploadTask.init] Catch on exception:{}", (Object)e.getMessage());
        }
    }

    private void initDeviceList() {
        try {
            List list = this.databaseManagerByDeviceConfig.queryAllConfig(null);
            if (list == null) {
                log.error("[SyncUploadTask.initDeviceList] list is null");
                return;
            }
            ConcurrentHashMap map = list.stream().collect(Collectors.groupingBy(ConfigDeviceEntity::getMachineId, ConcurrentHashMap::new, Collectors.toList()));
            int allCount = list.size();
            int sorterCount = 0;
            int wheelCount = 0;
            for (Integer machineId : map.keySet()) {
                List listValues;
                MachineData machineData = (MachineData)this.machineIdMap.get(machineId);
                if (machineData == null) continue;
                String machineType = machineData.getMachineType();
                if ("Sorter".equals(machineType)) {
                    listValues = (List)map.get(machineId);
                    this.sorterList.put(machineId, listValues);
                    continue;
                }
                if (!"BalanceWheel".equals(machineType)) continue;
                listValues = (List)map.get(machineId);
                this.deviceList.put(machineId, listValues);
            }
            ArrayList<String> stringList = new ArrayList<String>();
            for (ConfigDeviceEntity entity : list) {
                String sorterName = entity.getDevName();
                int seqNo = entity.getSeqNo();
                if (seqNo > 0) continue;
                stringList.add(sorterName);
            }
            if (!stringList.isEmpty()) {
                log.error("[SyncUploadTask.initDeviceList] SeqNo is 0! NameList:{}", stringList);
                log.info("[SyncUploadTask.initDeviceList] SeqNo is 0! NameList:{}", stringList);
            }
            log.info("[SyncUploadTask.initDeviceList] Sync task finished. Total:{}, Sorter:{}, Wheel:{}", new Object[]{allCount, sorterCount, wheelCount});
            log.info("[SyncUploadTask.initDeviceList] Start to init sync task. list size:{}", (Object)this.machineIdMap.size());
        }
        catch (Exception e) {
            log.error("[SyncUploadTask.initDeviceList] Catch on exception:{}", (Object)e.getMessage());
        }
    }

    public ConcurrentHashMap<Integer, MachineData> getMachineDataList() {
        return this.machineIdMap;
    }

    public boolean handleUploadMessage() {
        try {
            boolean isAuto = false;
            this.handleUploadSorter(isAuto);
            this.handleUploadWheel(isAuto);
            return true;
        }
        catch (BeansException e) {
            log.error("[SyncUploadTask.handleUploadMessage] Catch on exception:{}", (Object)e.getMessage());
            return false;
        }
    }

    public void handleAutoUploadMessage() {
        try {
            boolean isAuto = true;
            this.handleUploadSorter(isAuto);
            this.handleUploadWheel(isAuto);
        }
        catch (BeansException e) {
            log.error("[SyncUploadTask.handleAutoUploadMessage] Catch on exception:{}", (Object)e.getMessage());
        }
    }

    private void handleUploadWheel(boolean isAuto) {
        try {
            for (Map.Entry entry : this.deviceList.entrySet()) {
                Integer machineId = (Integer)entry.getKey();
                List listValues = (List)entry.getValue();
                MachineData machineData = (MachineData)this.machineIdMap.get(machineId);
                if (machineData == null || machineData.getStatusSendingInterval() <= 0) continue;
                boolean isTimePassed = this.isTimePassed(machineData);
                if (isAuto && !isTimePassed) continue;
                this.wheelStatusManager.handleStatusMessage(machineData, listValues);
                if (!isAuto) continue;
                machineData.setLastUpdateTime(System.currentTimeMillis());
            }
        }
        catch (Exception e) {
            log.error("[SyncUploadTask.handleUploadWheel] Catch on exception:{}", (Object)e.getMessage());
        }
    }

    private void handleUploadSorter(boolean isAuto) {
        try {
            for (Map.Entry entry : this.sorterList.entrySet()) {
                Integer machineId = (Integer)entry.getKey();
                List listValues = (List)entry.getValue();
                MachineData machineData = (MachineData)this.machineIdMap.get(machineId);
                if (machineData == null || machineData.getStatusSendingInterval() <= 0) continue;
                boolean isTimePassed = this.isTimePassed(machineData);
                if (isAuto && !isTimePassed) continue;
                this.sorterStatusManager.handleStatusMessage(machineData, listValues);
                if (!isAuto) continue;
                machineData.setLastUpdateTime(System.currentTimeMillis());
            }
        }
        catch (Exception e) {
            log.error("[SyncUploadTask.handleUploadSorter] Catch on exception:{}", (Object)e.getMessage());
        }
    }

    private boolean isTimePassed(MachineData machineData) {
        if (machineData == null) {
            return false;
        }
        long expiredSeconds = machineData.getStatusSendingInterval().intValue();
        long diffMillSeconds = System.currentTimeMillis() - machineData.getLastUpdateTime();
        return diffMillSeconds >= expiredSeconds * 1000L;
    }
}

