/*
 * Decompiled with CFR 0.152.
 */
package com.simba.services.push.database;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.simba.services.enums.UploadDataStatus;
import com.simba.services.push.database.RecordUpload.entity.RecordUploadEntity;
import com.simba.services.push.database.RecordUpload.services.IRecordUploadService;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import javax.annotation.Resource;
import org.springframework.stereotype.Component;

@Component
public class DatabaseManagerByUploadData {
    @Resource
    private IRecordUploadService iRecordUploadService;

    public List<RecordUploadEntity> queryAllData(String machineId) {
        LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
        List<String> statusList = Arrays.asList(UploadDataStatus.INIT.getCode(), UploadDataStatus.RETRYING.getCode());
        queryWrapper.in(RecordUploadEntity::getStatus, statusList);
        if (machineId != null) {
            queryWrapper.eq(RecordUploadEntity::getMachineId, (Object)machineId);
        }
        queryWrapper.orderByAsc(RecordUploadEntity::getId);
        queryWrapper.last(" limit 100");
        return this.iRecordUploadService.list((Wrapper)queryWrapper);
    }

    public boolean updateDataById(RecordUploadEntity data) {
        if (data == null) {
            return false;
        }
        long id = data.getId();
        String status = data.getStatus();
        if (id == 0L || status == null) {
            return false;
        }
        LambdaUpdateWrapper updateWrapper = new LambdaUpdateWrapper();
        updateWrapper.eq(RecordUploadEntity::getId, (Object)id);
        RecordUploadEntity entity = new RecordUploadEntity();
        entity.setStatus(status);
        entity.setUpdateTime(new Date());
        entity.setRetryCount(data.getRetryCount());
        entity.setResponse(data.getResponse());
        return this.iRecordUploadService.update((Object)entity, (Wrapper)updateWrapper);
    }
}

