/*
 * Decompiled with CFR 0.152.
 */
package com.simba.services.message.sorter;

import com.simba.services.message.IPayload;
import com.simba.services.message.SorterDeviceMessage;
import com.simba.services.message.sorter.AbstractDeviceStatus;
import com.simba.services.util.ByteUtils;
import java.nio.ByteBuffer;

public class TimeSyncOp
extends AbstractDeviceStatus {
    private byte command = (byte)98;
    private int year;
    private short month;
    private short day;
    private short hour;
    private short minute;
    private short second;
    private int milliSecond;

    public ByteBuffer encode() {
        ByteBuffer buf = ByteBuffer.allocate(this.length());
        buf.putInt(this.year);
        buf.putShort(this.month);
        buf.putShort(this.day);
        buf.putShort(this.hour);
        buf.putShort(this.minute);
        buf.putShort(this.second);
        buf.put(ByteUtils.fromInt((int)this.milliSecond, (int)3));
        return buf;
    }

    public void decode(byte[] bytes) {
        ByteBuffer buf = ByteBuffer.wrap(bytes);
        this.year = buf.getInt();
        this.month = buf.getShort();
        this.day = buf.getShort();
        this.hour = buf.getShort();
        this.minute = buf.getShort();
        this.second = buf.getShort();
        this.milliSecond = buf.getShort();
        this.milliSecond <<= 16;
        this.milliSecond += buf.get();
    }

    public int length() {
        int n = 4;
        n += 2;
        n += 2;
        n += 2;
        n += 2;
        n += 2;
        return n += 3;
    }

    public static void main(String[] argv) {
        TimeSyncOp payload = new TimeSyncOp();
        payload.setYear(2025);
        payload.setMonth((short)2);
        payload.setDay((short)19);
        payload.setHour((short)11);
        payload.setMinute((short)30);
        payload.setSecond((short)45);
        payload.setMilliSecond(700);
        SorterDeviceMessage message = new SorterDeviceMessage((IPayload)payload);
        message.setSender((byte)1);
        message.setReceiver((byte)3);
        message.setTimestamp(System.currentTimeMillis());
        message.setSeqNo((byte)64);
        ByteBuffer buf = message.encode();
        System.out.println(buf.position());
    }

    public byte getCommand() {
        return this.command;
    }

    public void setYear(int year) {
        this.year = year;
    }

    public int getYear() {
        return this.year;
    }

    public void setMonth(short month) {
        this.month = month;
    }

    public short getMonth() {
        return this.month;
    }

    public void setDay(short day) {
        this.day = day;
    }

    public short getDay() {
        return this.day;
    }

    public void setHour(short hour) {
        this.hour = hour;
    }

    public short getHour() {
        return this.hour;
    }

    public void setMinute(short minute) {
        this.minute = minute;
    }

    public short getMinute() {
        return this.minute;
    }

    public void setSecond(short second) {
        this.second = second;
    }

    public short getSecond() {
        return this.second;
    }

    public void setMilliSecond(int milliSecond) {
        this.milliSecond = milliSecond;
    }

    public int getMilliSecond() {
        return this.milliSecond;
    }

    static {
        IPayload.registerDecoder((String)String.valueOf(98), TimeSyncOp.class);
    }
}

