/*
 * Decompiled with CFR 0.152.
 */
package com.simba.services.message.sorter;

import com.simba.services.message.IPayload;
import com.simba.services.message.SorterDeviceMessage;
import com.simba.services.message.sorter.AbstractDeviceStatus;
import com.simba.services.message.sorter.StatusArrWithNum;
import java.nio.ByteBuffer;

public class PlcStatus
extends AbstractDeviceStatus {
    private byte command = (byte)53;
    byte mainPlcStatus;
    byte backEndCommStatus;
    StatusArrWithNum ap = new StatusArrWithNum();
    StatusArrWithNum client = new StatusArrWithNum();
    StatusArrWithNum carrierPlc = new StatusArrWithNum();
    StatusArrWithNum gridPositionPlc = new StatusArrWithNum();
    StatusArrWithNum inductPlc = new StatusArrWithNum();
    StatusArrWithNum scanner = new StatusArrWithNum();
    StatusArrWithNum grayscale = new StatusArrWithNum();

    public ByteBuffer encode() {
        ByteBuffer buf = ByteBuffer.allocate(this.length());
        buf.put(this.mainPlcStatus);
        buf.put(this.backEndCommStatus);
        buf.put((ByteBuffer)this.ap.encode().flip());
        buf.put((ByteBuffer)this.client.encode().flip());
        buf.put((ByteBuffer)this.carrierPlc.encode().flip());
        buf.put((ByteBuffer)this.gridPositionPlc.encode().flip());
        buf.put((ByteBuffer)this.inductPlc.encode().flip());
        buf.put((ByteBuffer)this.scanner.encode().flip());
        buf.put((ByteBuffer)this.grayscale.encode().flip());
        return buf;
    }

    public void decode(byte[] bytes) {
        ByteBuffer buf = ByteBuffer.wrap(bytes);
        this.mainPlcStatus = buf.get();
        this.backEndCommStatus = buf.get();
        this.ap = this.getStatusArrWithNum(buf);
        this.client = this.getStatusArrWithNum(buf);
        this.carrierPlc = this.getStatusArrWithNum(buf);
        this.gridPositionPlc = this.getStatusArrWithNum(buf);
        this.inductPlc = this.getStatusArrWithNum(buf);
        this.scanner = this.getStatusArrWithNum(buf);
        this.grayscale = this.getStatusArrWithNum(buf);
    }

    private StatusArrWithNum getStatusArrWithNum(ByteBuffer buf) {
        byte n = buf.get();
        byte[] bytes = new byte[n];
        buf.get(bytes);
        StatusArrWithNum statusArrWithNum = new StatusArrWithNum(bytes);
        return statusArrWithNum;
    }

    public int length() {
        int n = 1;
        ++n;
        n += this.ap.length();
        n += this.client.length();
        n += this.carrierPlc.length();
        n += this.gridPositionPlc.length();
        n += this.inductPlc.length();
        n += this.scanner.length();
        return n += this.grayscale.length();
    }

    public static void main(String[] argv) {
        PlcStatus payload = new PlcStatus();
        payload.setAp(new StatusArrWithNum(new byte[]{0, 1, 0, 1, 0, 1, 0, 1, 0, 1}));
        SorterDeviceMessage message = new SorterDeviceMessage((IPayload)payload);
        message.setSender((byte)1);
        message.setReceiver((byte)3);
        message.setTimestamp(System.currentTimeMillis());
        message.setSeqNo((byte)64);
        ByteBuffer buf = message.encode();
        System.out.println(buf.position());
    }

    public byte getCommand() {
        return this.command;
    }

    public void setMainPlcStatus(byte mainPlcStatus) {
        this.mainPlcStatus = mainPlcStatus;
    }

    public byte getMainPlcStatus() {
        return this.mainPlcStatus;
    }

    public void setBackEndCommStatus(byte backEndCommStatus) {
        this.backEndCommStatus = backEndCommStatus;
    }

    public byte getBackEndCommStatus() {
        return this.backEndCommStatus;
    }

    public void setAp(StatusArrWithNum ap) {
        this.ap = ap;
    }

    public StatusArrWithNum getAp() {
        return this.ap;
    }

    public void setClient(StatusArrWithNum client) {
        this.client = client;
    }

    public StatusArrWithNum getClient() {
        return this.client;
    }

    public void setCarrierPlc(StatusArrWithNum carrierPlc) {
        this.carrierPlc = carrierPlc;
    }

    public StatusArrWithNum getCarrierPlc() {
        return this.carrierPlc;
    }

    public void setGridPositionPlc(StatusArrWithNum gridPositionPlc) {
        this.gridPositionPlc = gridPositionPlc;
    }

    public StatusArrWithNum getGridPositionPlc() {
        return this.gridPositionPlc;
    }

    public void setInductPlc(StatusArrWithNum inductPlc) {
        this.inductPlc = inductPlc;
    }

    public StatusArrWithNum getInductPlc() {
        return this.inductPlc;
    }

    public void setScanner(StatusArrWithNum scanner) {
        this.scanner = scanner;
    }

    public StatusArrWithNum getScanner() {
        return this.scanner;
    }

    public void setGrayscale(StatusArrWithNum grayscale) {
        this.grayscale = grayscale;
    }

    public StatusArrWithNum getGrayscale() {
        return this.grayscale;
    }

    static {
        IPayload.registerDecoder((String)String.valueOf(53), PlcStatus.class);
    }
}

