/*
 * Decompiled with CFR 0.152.
 */
package com.simba.services.message.sorter;

import com.simba.services.message.IPayload;
import com.simba.services.message.SorterDeviceMessage;
import com.simba.services.message.sorter.AbstractDeviceStatus;
import java.nio.ByteBuffer;

public class HeartBreak
extends AbstractDeviceStatus {
    private byte command = (byte)54;
    private byte systemStatus;
    private byte systemMode;
    private short systemSpeed;
    private short electricBrushDistance;

    public ByteBuffer encode() {
        ByteBuffer buf = ByteBuffer.allocate(this.length());
        buf.put(this.systemStatus);
        buf.put(this.systemMode);
        buf.putShort(this.systemSpeed);
        buf.putShort(this.electricBrushDistance);
        return buf;
    }

    public void decode(byte[] bytes) {
        ByteBuffer buf = ByteBuffer.wrap(bytes);
        this.systemStatus = buf.get();
        this.systemMode = buf.get();
        this.systemSpeed = buf.getShort();
        this.electricBrushDistance = buf.getShort();
    }

    public int length() {
        int n = 0;
        ++n;
        ++n;
        n += 2;
        n += 2;
        n += 6;
        return n += 2;
    }

    public static void main(String[] argv) {
        HeartBreak payload = new HeartBreak();
        payload.setSystemStatus((byte)4);
        payload.setSystemMode((byte)2);
        payload.setSystemSpeed((short)20);
        payload.setElectricBrushDistance((short)40);
        SorterDeviceMessage message = new SorterDeviceMessage((IPayload)payload);
        message.setSender((byte)1);
        message.setReceiver((byte)3);
        message.setTimestamp(System.currentTimeMillis());
        message.setSeqNo((byte)64);
        ByteBuffer buf = message.encode();
        System.out.println(buf.position());
    }

    public byte getCommand() {
        return this.command;
    }

    public void setSystemStatus(byte systemStatus) {
        this.systemStatus = systemStatus;
    }

    public byte getSystemStatus() {
        return this.systemStatus;
    }

    public void setSystemMode(byte systemMode) {
        this.systemMode = systemMode;
    }

    public byte getSystemMode() {
        return this.systemMode;
    }

    public void setSystemSpeed(short systemSpeed) {
        this.systemSpeed = systemSpeed;
    }

    public short getSystemSpeed() {
        return this.systemSpeed;
    }

    public void setElectricBrushDistance(short electricBrushDistance) {
        this.electricBrushDistance = electricBrushDistance;
    }

    public short getElectricBrushDistance() {
        return this.electricBrushDistance;
    }

    static {
        IPayload.registerDecoder((String)String.valueOf(54), HeartBreak.class);
    }
}

