/*
 * Decompiled with CFR 0.152.
 */
package com.simba.services.message.sorter;

import com.simba.services.message.IPayload;
import com.simba.services.message.SorterDeviceMessage;
import com.simba.services.message.sorter.AbstractDeviceStatus;
import java.nio.ByteBuffer;

public class ElectricMotorStatus
extends AbstractDeviceStatus {
    private byte command = (byte)52;
    protected short count;
    protected byte[] statusArr = new byte[0];

    public ByteBuffer encode() {
        ByteBuffer buf = ByteBuffer.allocate(this.length());
        buf.putShort(this.count);
        buf.put(this.statusArr);
        return buf;
    }

    public void decode(byte[] bytes) {
        ByteBuffer buf = ByteBuffer.wrap(bytes);
        this.count = buf.getShort();
        this.statusArr = new byte[this.count * 4];
        buf.get(this.statusArr);
    }

    public int length() {
        int n = 0;
        n += 2;
        return n += this.statusArr.length;
    }

    public static void main(String[] argv) {
        ElectricMotorStatus payload = new ElectricMotorStatus();
        payload.setCount((short)6);
        payload.setStatusArr(new byte[]{0, 1, 0, 1, 0, 1, 0, 1, 0, 1});
        SorterDeviceMessage message = new SorterDeviceMessage((IPayload)payload);
        message.setSender((byte)1);
        message.setReceiver((byte)3);
        message.setTimestamp(System.currentTimeMillis());
        message.setSeqNo((byte)64);
        ByteBuffer buf = message.encode();
        System.out.println(buf.position());
    }

    public byte getCommand() {
        return this.command;
    }

    public void setCount(short count) {
        this.count = count;
    }

    public short getCount() {
        return this.count;
    }

    public void setStatusArr(byte[] statusArr) {
        this.statusArr = statusArr;
    }

    public byte[] getStatusArr() {
        return this.statusArr;
    }

    static {
        IPayload.registerDecoder((String)String.valueOf(52), ElectricMotorStatus.class);
    }
}

