/*
 * Decompiled with CFR 0.152.
 */
package com.simba.services.message.balancewheel;

import com.alibaba.fastjson.JSON;
import com.simba.services.message.balancewheel.AbstractLineDeviceStatus;
import io.netty.buffer.ByteBufUtil;
import java.nio.ByteBuffer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractLineTypeDeviceStatus
extends AbstractLineDeviceStatus {
    private static final Logger log = LoggerFactory.getLogger(AbstractLineTypeDeviceStatus.class);
    private byte lineType;

    public ByteBuffer encode() {
        ByteBuffer buf = ByteBuffer.allocate(this.length());
        buf.putShort(this.lineNum);
        buf.put(this.lineType);
        buf.putShort(this.count);
        buf.put(this.statusArr);
        return buf;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void decode(byte[] bytes) {
        boolean ok = false;
        try {
            ByteBuffer buf = ByteBuffer.wrap(bytes);
            this.lineNum = buf.getShort();
            this.lineType = buf.get();
            this.count = buf.getShort();
            this.statusArr = new byte[this.count];
            buf.get(this.statusArr);
            ok = true;
        }
        finally {
            if (!ok) {
                log.warn("\u89e3\u7801\u5931\u8d25(LineType): {}\u3002", (Object)ByteBufUtil.hexDump((byte[])bytes));
                log.warn("\u5df2\u89e3\u7801: {}\u3002", (Object)JSON.toJSONString((Object)this));
            }
        }
    }

    public int length() {
        int n = 2;
        ++n;
        n += 2;
        return n += this.statusArr.length;
    }

    public void setLineType(byte lineType) {
        this.lineType = lineType;
    }

    public byte getLineType() {
        return this.lineType;
    }
}

