/*
 * Decompiled with CFR 0.152.
 */
package com.simba.services.message.balancewheel;

import com.alibaba.fastjson.JSON;
import com.simba.services.message.IPayload;
import io.netty.buffer.ByteBufUtil;
import java.nio.ByteBuffer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractLineDeviceStatus
implements IPayload {
    private static final Logger log = LoggerFactory.getLogger(AbstractLineDeviceStatus.class);
    protected short lineNum;
    protected short count;
    protected byte[] statusArr = new byte[0];

    public ByteBuffer encode() {
        ByteBuffer buf = ByteBuffer.allocate(this.length());
        buf.putShort(this.lineNum);
        buf.putShort(this.count);
        buf.put(this.statusArr);
        return buf;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void decode(byte[] bytes) {
        ByteBuffer buf = ByteBuffer.wrap(bytes);
        boolean ok = false;
        try {
            this.lineNum = buf.getShort();
            this.count = buf.getShort();
            this.statusArr = new byte[this.count];
            buf.get(this.statusArr);
            ok = true;
        }
        finally {
            if (!ok) {
                log.warn("\u89e3\u7801\u5931\u8d25(Line): {}\u3002", (Object)ByteBufUtil.hexDump((byte[])bytes));
                log.warn("\u5df2\u89e3\u7801: {}\u3002", (Object)JSON.toJSONString((Object)this));
            }
        }
    }

    public int length() {
        int n = 2;
        n += 2;
        return n += this.statusArr.length;
    }

    public void setLineNum(short lineNum) {
        this.lineNum = lineNum;
    }

    public short getLineNum() {
        return this.lineNum;
    }

    public void setCount(short count) {
        this.count = count;
    }

    public short getCount() {
        return this.count;
    }

    public void setStatusArr(byte[] statusArr) {
        this.statusArr = statusArr;
    }

    public byte[] getStatusArr() {
        return this.statusArr;
    }
}

