/*
 * Decompiled with CFR 0.152.
 */
package com.simba.services.message;

import com.alibaba.fastjson.JSON;
import com.simba.services.message.AbstractDeviceMessage;
import com.simba.services.message.IPayload;
import com.simba.services.message.sorter.PlcStatus;
import com.simba.services.message.sorter.StatusArrWithNum;
import io.netty.buffer.ByteBufUtil;
import java.nio.ByteBuffer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * Exception performing whole class analysis ignored.
 */
public class SorterDeviceMessage
extends AbstractDeviceMessage {
    private static final Logger log = LoggerFactory.getLogger(SorterDeviceMessage.class);
    protected long timestamp;
    protected byte seqNo;

    public SorterDeviceMessage() {
    }

    public SorterDeviceMessage(IPayload payload) {
        super(payload);
    }

    public ByteBuffer encode() {
        short n = this.length();
        ByteBuffer buf = ByteBuffer.allocate(2 + this.length());
        buf.putShort(n);
        buf.put(this.sender);
        buf.put(this.receiver);
        buf.put(this.command);
        buf.put((ByteBuffer)this.payload.encode().flip());
        buf.putLong(this.timestamp);
        buf.put(this.seqNo);
        buf.putShort(this.eof);
        return buf;
    }

    public short length() {
        int n = 1;
        n = (byte)(n + 1);
        n = (byte)(n + 1);
        n = (byte)(n + this.payload.length());
        n = (byte)(n + 8);
        n = (byte)(n + 1);
        n = (byte)(n + 2);
        return (short)n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean decode(byte[] buf) {
        if (buf.length < 14) {
            log.error("\u5b57\u8282\u957f\u5ea6\u4e0d\u8db3: " + buf.length);
            return false;
        }
        ByteBuffer bb = ByteBuffer.wrap(buf);
        short length = bb.getShort();
        if (length + 0 != buf.length) {
            log.error("\u5b57\u8282\u957f\u5ea6\u4e0d\u8db3\u3002\u671f\u671b\u957f\u5ea6: " + (length + 0) + ", \u5b9e\u9645\u957f\u5ea6: " + buf.length);
            return false;
        }
        short i = length;
        this.sender = bb.get();
        this.receiver = bb.get();
        this.command = bb.get();
        int payloadLength = i - (bb.position() - 2) - 8 - 1 - 2;
        byte[] payloadBytes = new byte[payloadLength];
        bb.get(payloadBytes);
        boolean ok = false;
        try {
            this.payload = this.parsePayload((short)this.command, payloadBytes);
            ok = true;
        }
        finally {
            if (!ok) {
                log.warn("\u89e3\u7801\u5931\u8d25(Sorter): {}\u3002", (Object)ByteBufUtil.hexDump((byte[])buf));
                log.warn("\u5df2\u89e3\u7801: {}\u3002", (Object)JSON.toJSONString((Object)this));
            }
        }
        if (this.payload == null) {
            return false;
        }
        this.timestamp = bb.getLong();
        this.seqNo = bb.get();
        return true;
    }

    public static void main(String[] argv) {
        String[] payloadClassList;
        PlcStatus plcStatus = new PlcStatus();
        plcStatus.setAp(new StatusArrWithNum(new byte[]{0, 1, 0, 1, 0, 1, 0, 1, 0, 1}));
        plcStatus.setClient(new StatusArrWithNum(new byte[]{0, 1, 0, 1}));
        SorterDeviceMessage.testCodec((IPayload)plcStatus);
        for (String className : payloadClassList = new String[]{"CarrierLocation", "CarrierLockOp", "CarrierMoveOp", "CarrierStatus", "ElectricMotorStatus", "EmergencyStopStatus", "GridPositionOp", "GridPosStatus", "HeartBreak", "InductChcek", "InductChcekResultOp", "InductDeletion", "InductStatus", "PlcStatus", "SysControlOp", "SysStatusChangeOp", "SysStatusUploadConfigOp", "TimeSyncOp"}) {
            try {
                className = "com.simba.services.message.sorter." + className;
                log.debug("Payload class name: {}.", (Object)className);
                IPayload payload = (IPayload)Class.forName(className).newInstance();
                SorterDeviceMessage.testCodec((IPayload)payload);
            }
            catch (ClassNotFoundException | IllegalAccessException | InstantiationException e) {
                log.debug(e.getMessage(), (Throwable)e);
                log.error("\u65e0\u6cd5\u751f\u6210\u6d88\u606f\u5b9e\u4f8b: {}\u3002", (Object)e.getMessage());
            }
        }
    }

    private static void testCodec(IPayload payload) {
        SorterDeviceMessage message = new SorterDeviceMessage(payload);
        message.setSender((byte)1);
        message.setReceiver((byte)3);
        message.setTimestamp(System.currentTimeMillis());
        message.setSeqNo((byte)64);
        ByteBuffer buf = message.encode();
        byte[] bytes = new byte[buf.position()];
        buf.flip();
        buf.get(bytes);
        log.debug("\u7f16\u7801\u7ed3\u679c: {}.", (Object)ByteBufUtil.hexDump((byte[])bytes));
        SorterDeviceMessage msg = new SorterDeviceMessage();
        if (msg.decode(bytes)) {
            log.info("\u89e3\u7801\u7ed3\u679c: {}.", (Object)JSON.toJSONString((Object)msg));
        } else {
            log.error("\u89e3\u7801\u5931\u8d25.");
        }
    }

    public void setTimestamp(long timestamp) {
        this.timestamp = timestamp;
    }

    public long getTimestamp() {
        return this.timestamp;
    }

    public void setSeqNo(byte seqNo) {
        this.seqNo = seqNo;
    }

    public byte getSeqNo() {
        return this.seqNo;
    }
}

