/*
 * Decompiled with CFR 0.152.
 */
package com.simba.services.message;

import com.alibaba.fastjson.JSON;
import com.simba.services.message.AbstractDeviceMessage;
import com.simba.services.message.IPayload;
import com.simba.services.message.balancewheel.HeartBreak;
import io.netty.buffer.ByteBufUtil;
import java.nio.ByteBuffer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * Exception performing whole class analysis ignored.
 */
public class BalanceWheelDeviceMessage
extends AbstractDeviceMessage {
    private static final Logger log = LoggerFactory.getLogger(BalanceWheelDeviceMessage.class);

    public BalanceWheelDeviceMessage() {
    }

    public BalanceWheelDeviceMessage(IPayload payload) {
        super(payload);
    }

    public ByteBuffer encode() {
        short n = this.length();
        ByteBuffer buf = ByteBuffer.allocate(2 + this.length());
        buf.putShort(n);
        buf.put(this.sender);
        buf.put(this.receiver);
        buf.put(this.command);
        buf.put((ByteBuffer)this.payload.encode().flip());
        buf.putShort(this.eof);
        return buf;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean decode(byte[] buf) {
        if (buf.length < 5) {
            log.error("\u5b57\u8282\u957f\u5ea6\u4e0d\u8db3: " + buf.length);
            return false;
        }
        ByteBuffer bb = ByteBuffer.wrap(buf);
        short length = bb.getShort();
        if (length + 0 != buf.length) {
            log.error("\u5b57\u8282\u957f\u5ea6\u4e0d\u8db3\u3002\u671f\u671b\u957f\u5ea6: " + (length + 0) + ", \u5b9e\u9645\u957f\u5ea6: " + buf.length);
            return false;
        }
        short i = length;
        this.sender = bb.get();
        this.receiver = bb.get();
        this.command = bb.get();
        int payloadLength = i - (bb.position() - 2) - 2;
        byte[] payloadBytes = new byte[payloadLength];
        bb.get(payloadBytes);
        boolean ok = false;
        try {
            this.payload = this.parsePayload((short)this.command, payloadBytes);
            ok = true;
        }
        finally {
            if (!ok) {
                log.warn("\u89e3\u7801\u5931\u8d25(BalanceWheel): {}\u3002", (Object)ByteBufUtil.hexDump((byte[])buf));
                log.warn("\u5df2\u89e3\u7801: {}\u3002", (Object)JSON.toJSONString((Object)this));
            }
        }
        return this.payload != null;
    }

    public short length() {
        int n = 1;
        n = (byte)(n + 1);
        n = (byte)(n + 1);
        n = (byte)(n + this.payload.length());
        n = (byte)(n + 2);
        return (short)n;
    }

    public static void main(String[] argv) {
        String[] payloadClassList;
        HeartBreak hearyBreak = new HeartBreak();
        hearyBreak.setLineNum((short)24);
        hearyBreak.setCameraStatus((byte)1);
        BalanceWheelDeviceMessage.testCodec((IPayload)hearyBreak);
        for (String className : payloadClassList = new String[]{"EmergencyStopStatus", "GridPosStatus", "HeartBreak", "LineStatus", "OverheadDoorStatus", "PhotoEletricStatus", "RemoteIoCommStatus", "SysStatusChange"}) {
            try {
                className = "com.simba.services.message.balancewheel." + className;
                log.debug("Payload class name: {}.", (Object)className);
                IPayload payload = (IPayload)Class.forName(className).newInstance();
                BalanceWheelDeviceMessage.testCodec((IPayload)payload);
            }
            catch (ClassNotFoundException | IllegalAccessException | InstantiationException e) {
                log.debug(e.getMessage(), (Throwable)e);
                log.error("\u65e0\u6cd5\u751f\u6210\u6d88\u606f\u5b9e\u4f8b: {}\u3002", (Object)e.getMessage());
            }
        }
    }

    private static void testCodec(IPayload payload) {
        BalanceWheelDeviceMessage message = new BalanceWheelDeviceMessage(payload);
        message.setSender((byte)1);
        message.setReceiver((byte)3);
        ByteBuffer buf = message.encode();
        byte[] bytes = new byte[buf.position()];
        buf.flip();
        buf.get(bytes);
        log.debug("\u7f16\u7801\u7ed3\u679c: {}.", (Object)ByteBufUtil.hexDump((byte[])bytes));
        BalanceWheelDeviceMessage msg = new BalanceWheelDeviceMessage();
        if (msg.decode(bytes)) {
            log.info("\u89e3\u7801\u7ed3\u679c: {}.", (Object)JSON.toJSONString((Object)msg));
        } else {
            log.error("\u89e3\u7801\u5931\u8d25.");
        }
    }
}

