/*
 * Decompiled with CFR 0.152.
 */
package com.simba.services.message;

import com.simba.services.message.IPayload;
import com.simba.services.message.balancewheel.RemoteIoCommStatus;
import java.io.File;
import java.io.IOException;
import java.net.JarURLConnection;
import java.net.URL;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * Exception performing whole class analysis ignored.
 */
public abstract class AbstractDeviceMessage {
    private static final Logger log = LoggerFactory.getLogger(AbstractDeviceMessage.class);
    protected byte sender;
    protected byte receiver;
    protected byte command;
    protected IPayload payload;
    protected short eof = (short)3338;

    public AbstractDeviceMessage() {
    }

    public static void registerPayloads() {
        Package pkg = AbstractDeviceMessage.class.getPackage();
        AbstractDeviceMessage.registerPayloads((String)(pkg.getName() + ".balancewheel"));
        AbstractDeviceMessage.registerPayloads((String)(pkg.getName() + ".sorter"));
    }

    private static void registerPayloads(String packageName) {
        log.info("Loads payload classes in the package of {}.", (Object)packageName);
        List classNames = AbstractDeviceMessage.getClassesPro((String)packageName);
        for (String className : classNames) {
            try {
                log.info("Loads the payload class for {}.", (Object)className);
                Class.forName(className);
            }
            catch (ClassNotFoundException e) {
                log.debug("Failed to load the payload class with the name of {}.", (Object)className);
            }
        }
    }

    public static List<String> getClassesPro(String packageName) {
        ArrayList<String> classNames = new ArrayList<String>();
        ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
        String path = packageName.replace(".", "/");
        try {
            Enumeration<URL> resources = classLoader.getResources(path);
            while (resources.hasMoreElements()) {
                URL resource = resources.nextElement();
                if (resource.getProtocol().equals("file")) {
                    File file = new File(resource.getFile());
                    File[] files = file.listFiles();
                    if (files == null) continue;
                    for (File f : files) {
                        String className = f.getName().replace(".class", "");
                        classNames.add(packageName + "." + className);
                    }
                    continue;
                }
                if (!resource.getProtocol().equals("jar")) continue;
                JarURLConnection jarURLConnection = (JarURLConnection)resource.openConnection();
                JarFile jarFile = jarURLConnection.getJarFile();
                Enumeration<JarEntry> entries = jarFile.entries();
                while (entries.hasMoreElements()) {
                    JarEntry jarEntry = entries.nextElement();
                    String className = jarEntry.getName().replace("/", ".");
                    if (!className.startsWith(packageName) || !className.endsWith(".class")) continue;
                    classNames.add(className.substring(0, className.length() - 6));
                }
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return classNames;
    }

    public static List<String> getClasses(String packageName) {
        ArrayList<String> classNames = new ArrayList<String>();
        String path = AbstractDeviceMessage.class.getResource("/" + packageName.replace(".", "/")).getPath();
        log.info("hi:" + RemoteIoCommStatus.class.getResource("/").getPath());
        log.info("path: {}.", (Object)path);
        path = path.replaceAll("classes!", "classes");
        path = path.replaceAll("file:/", "/");
        log.info("path: {}.", (Object)path);
        File file = new File(path);
        log.info("file.exists(): {}", (Object)file.exists());
        File[] files = file.listFiles();
        if (files != null) {
            for (File f : files) {
                if (f.isDirectory()) {
                    classNames.addAll(AbstractDeviceMessage.getClasses((String)(packageName + "." + f.getName())));
                    continue;
                }
                if (!f.getName().endsWith(".class")) continue;
                classNames.add(packageName + "." + f.getName().replace(".class", ""));
            }
        }
        return classNames;
    }

    public AbstractDeviceMessage(IPayload payload) {
        this.payload = payload;
        this.command = payload.getCommand();
    }

    public abstract ByteBuffer encode();

    public abstract boolean decode(byte[] var1);

    public abstract short length();

    protected IPayload parsePayload(short command, byte[] bytes) {
        Class decoderClass = (Class)IPayload.decoderMap.get(String.valueOf(command));
        try {
            IPayload paylooad = (IPayload)decoderClass.newInstance();
            paylooad.decode(bytes);
            return paylooad;
        }
        catch (IllegalAccessException | InstantiationException e) {
            log.debug(e.getMessage(), (Throwable)e);
            log.error("\u89e3\u7801\u9519\u8bef: " + e.getMessage());
            return null;
        }
    }

    public void setSender(byte sender) {
        this.sender = sender;
    }

    public byte getSender() {
        return this.sender;
    }

    public void setReceiver(byte receiver) {
        this.receiver = receiver;
    }

    public byte getReceiver() {
        return this.receiver;
    }

    public void setCommand(byte command) {
        this.command = command;
    }

    public byte getCommand() {
        return this.command;
    }

    public void setPayload(IPayload payload) {
        this.payload = payload;
    }

    public IPayload getPayload() {
        return this.payload;
    }

    public short getEof() {
        return this.eof;
    }
}

