/*
 * Decompiled with CFR 0.152.
 */
package com.simba.services.mapper.sorter;

import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.simba.services.bean.domain.Statistics;
import com.simba.services.bean.statistics.Counter;
import com.simba.services.bean.statistics.CounterExt;
import com.simba.services.bean.statistics.ObrCounter;
import com.simba.services.bean.statistics.TableSpaceInfo;
import java.util.Date;
import java.util.List;
import org.apache.ibatis.annotations.Param;
import org.apache.ibatis.annotations.Select;

public interface StatisticsMapper
extends BaseMapper<Statistics> {
    public Statistics selectTmStatisticsById(Long var1);

    public List<Statistics> selectTmStatisticsList(Statistics var1);

    public int insertTmStatistics(Statistics var1);

    public int updateTmStatistics(Statistics var1);

    public int deleteTmStatisticsById(Long var1);

    public int deleteTmStatisticsByIds(Long[] var1);

    @Select(value={"select 1 id, count(*) count from `${schema}`.tt_packet_on_info where packetOnTime>=#{timeFrom} and packetOnTime<#{timeTo};"})
    public List<Counter> listSorterPassSortData(@Param(value="schema") String var1, @Param(value="timeFrom") Date var2, @Param(value="timeTo") Date var3);

    @Select(value={"select 1 id, count(*) count from `${schema}`.tt_packet_off_info where packetOffTime>=#{timeFrom} and packetOffTime<#{timeTo};"})
    public List<Counter> listSorterFallSortData(@Param(value="schema") String var1, @Param(value="timeFrom") Date var2, @Param(value="timeTo") Date var3);

    @Select(value={"select 1 id, count(*) count from `${schema}`.tt_packet_off_info where packetOffTime>=#{timeFrom} and packetOffTime<#{timeTo} and turnNumber=0;"})
    public List<Counter> listSorterFallHalfSortData(@Param(value="schema") String var1, @Param(value="timeFrom") Date var2, @Param(value="timeTo") Date var3);

    @Select(value={"select DATE_FORMAT(packetOnTime, '%Y-%m-%d %H:%i') id, count(*) count from `${schema}`.tt_packet_on_info where packetOnTime>=#{timeFrom} and packetOnTime<#{timeTo} group by DATE_FORMAT(packetOnTime, '%Y-%m-%d %H:%i');"})
    public List<CounterExt> listPacketOffInMinuteSortData(@Param(value="schema") String var1, @Param(value="timeFrom") Date var2, @Param(value="timeTo") Date var3);

    @Select(value={"select sorterId id, count(*) count from `${schema}`.tt_packet_on_info where packetOnTime>=#{timeFrom} and packetOnTime<#{timeTo} group by sorterId order by sorterId;"})
    public List<Counter> listSorterPassSortDataForWheel(@Param(value="schema") String var1, @Param(value="timeFrom") Date var2, @Param(value="timeTo") Date var3);

    @Select(value={"select sorterId id, count(*) count from `${schema}`.tt_packet_off_info where packetOffTime>=#{timeFrom} and packetOffTime<#{timeTo} group by sorterId order by sorterId;"})
    public List<Counter> listSorterFallSortDataForWheel(@Param(value="schema") String var1, @Param(value="timeFrom") Date var2, @Param(value="timeTo") Date var3);

    @Select(value={"select sorterId id, count(*) count from `${schema}`.tt_packet_off_info where packetOffTime>=#{timeFrom} and packetOffTime<#{timeTo} group by sorterId order by sorterId;"})
    public List<Counter> listSorterObrPassSortData(@Param(value="schema") String var1, @Param(value="timeFrom") Date var2, @Param(value="timeTo") Date var3);

    @Select(value={"select sorterId id, count(*) count from `${schema}`.tt_packet_off_info where packetOffTime>=#{timeFrom} and packetOffTime<#{timeTo} and errorCodePLC!='3' group by sorterId order by sorterId;"})
    public List<Counter> listSorterObrRecognizedSortData(@Param(value="schema") String var1, @Param(value="timeFrom") Date var2, @Param(value="timeTo") Date var3);

    @Select(value={"select sorterId id, count(*) count from `${schema}`.tt_packet_off_info where packetOffTime>=#{timeFrom} and packetOffTime<#{timeTo} and errorCodePLC='3' group by sorterId order by sorterId;"})
    public List<Counter> listSorterObrRejectedSortData(@Param(value="schema") String var1, @Param(value="timeFrom") Date var2, @Param(value="timeTo") Date var3);

    @Select(value={"select carId id, count(*) count from `${schema}`.tt_packet_on_info where packetOnTime>=#{timeFrom} and packetOnTime<#{timeTo} group by carId order by carId;"})
    public List<Counter> listCarrierSortData(@Param(value="schema") String var1, @Param(value="timeFrom") Date var2, @Param(value="timeTo") Date var3);

    @Select(value={"select droppedSlot id,count(*) count from `${schema}`.tt_packet_off_info where packetOffTime>=#{timeFrom} and packetOffTime<#{timeTo} group by droppedSlot order by convert(droppedSlot, UNSIGNED);"})
    public List<Counter> listSlotSortData(@Param(value="schema") String var1, @Param(value="timeFrom") Date var2, @Param(value="timeTo") Date var3);

    @Select(value={"select platId id,count(*) count from `${schema}`.tt_packet_on_info where packetOnTime>=#{timeFrom}  and packetOnTime<#{timeTo}  group by platId order by platId;"})
    public List<Counter> listInductSortData(@Param(value="schema") String var1, @Param(value="timeFrom") Date var2, @Param(value="timeTo") Date var3);

    @Select(value={"select platId id,count(*) count from `${schema}`.tt_packet_on_info where packetOnTime>=#{timeFrom} and packetOnTime<#{timeTo}  group by platId order by convert(platId, UNSIGNED);"})
    public List<Counter> listObrPassSortData(@Param(value="schema") String var1, @Param(value="timeFrom") Date var2, @Param(value="timeTo") Date var3);

    @Select(value={"SELECT A.a id, A.b totalCount, A.c rejectedCount, A.d recognizedCount from(SELECT IFNULL(sorterId,'allSum') a, COUNT(sorterId) b, sum((CASE WHEN errorCodePLC  = '3' THEN 1 ELSE 0  END)) AS c, sum((CASE WHEN errorCodePLC != '3' THEN 1 ELSE 0  END)) AS d FROM `${schema}`.tt_packet_off_info WHERE  packetOffTime>=#{timeFrom} and packetOffTime<#{timeTo} group by sorterId WITH ROLLUP) A;"})
    public List<ObrCounter> listObrPassSortDataForBalanceWheel(@Param(value="schema") String var1, @Param(value="timeFrom") Date var2, @Param(value="timeTo") Date var3);

    @Select(value={"SELECT A.a id, A.b totalCount, A.c rejectedCount, A.d recognizedCount from(SELECT IFNULL(platId,'allSum') a, COUNT(platId) b, sum((CASE WHEN errorCodePLC  = '3' THEN 1 ELSE 0  END)) AS c, sum((CASE WHEN errorCodePLC != '3' THEN 1 ELSE 0  END)) AS d FROM `${schema}`.tt_packet_off_info WHERE  packetOffTime>=#{timeFrom} and packetOffTime<#{timeTo} group by platId WITH ROLLUP) A;"})
    public List<ObrCounter> listObrPassSortDataForSorter(@Param(value="schema") String var1, @Param(value="timeFrom") Date var2, @Param(value="timeTo") Date var3);

    @Select(value={"select platId id,count(*) count from `${schema}`.tt_scanned_info where scannedTime>=#{timeFrom} and scannedTime<#{timeTo}  group by platId order by convert(platId, UNSIGNED);"})
    public List<Counter> listObrReadSortData(@Param(value="schema") String var1, @Param(value="timeFrom") Date var2, @Param(value="timeTo") Date var3);

    @Select(value={"SELECT ifnull(SUM(data_length + index_length) / 1024 / 1024, 0) usedSize, ifnull(SUM(data_free) / 1024 / 1024,0) freeSize FROM information_schema.tables where table_schema=#{schema} group by table_schema"})
    public TableSpaceInfo getTableSpaceInfo(String var1);

    @Select(value={"select opsType from `${schema}`.tt_machine_ops_info order by opsTime desc limit 1"})
    public int getMachineLastOps(@Param(value="schema") String var1);

    @Select(value={"select opsTime from `${schema}`.tt_machine_ops_info where opsType=1 order by opsTime desc limit 1"})
    public Date getMachineStartedTime(@Param(value="schema") String var1);

    @Select(value={"select opsTime from `${schema}`.tt_machine_ops_info where opsType=#{opsType} order by opsTime desc limit 1"})
    public Date getMachineStartedTimePro(@Param(value="schema") String var1, @Param(value="opsType") Integer var2);

    @Select(value={"select errorCodePLC id, count(*) count from `${schema}`.tt_packet_off_info where packetOffTime>=#{timeFrom}  and packetOffTime<#{timeTo} group by errorCodePLC"})
    public List<Counter> listPacketOffSortData(@Param(value="schema") String var1, @Param(value="timeFrom") Date var2, @Param(value="timeTo") Date var3);
}

