/*
 * Decompiled with CFR 0.152.
 */
package com.simba.services.helper;

import com.alibaba.fastjson.JSON;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.simba.services.bean.domain.MachineConfig;
import com.simba.services.bean.domain.UploadData;
import com.simba.services.bean.model.DeviceInfoManager;
import com.simba.services.bean.response.CommonRes;
import com.simba.services.common.utils.DateUtils;
import com.simba.services.common.utils.StringUtils;
import com.simba.services.common.utils.uuid.UUID;
import com.simba.services.config.WinccConfig;
import com.simba.services.enums.DeviceClass;
import com.simba.services.enums.RequestType;
import com.simba.services.enums.UploadDataStatus;
import com.simba.services.service.BasicConfigService;
import com.simba.services.service.UploadDataService;
import com.simba.services.upload.event.DeviceEvent;
import com.simba.services.upload.event.FaultMsg;
import com.simba.services.upload.status.AbstractDeviceMsg;
import com.simba.services.upload.status.CarrierMsg;
import com.simba.services.upload.status.DeviceStatus;
import com.simba.services.upload.status.DynamicScaleMsg;
import com.simba.services.upload.status.ElectricMotorMsg;
import com.simba.services.upload.status.GrayscaleMsg;
import com.simba.services.upload.status.InductMsg;
import com.simba.services.upload.status.LinesMsg;
import com.simba.services.upload.status.ObrMsg;
import com.simba.services.upload.status.PhysicalPosMsg;
import com.simba.services.upload.status.SorterMsg;
import com.simba.services.upload.status.WheelBeltMsg;
import com.simba.services.util.HttpUtils;
import com.simba.services.util.TokenUtils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class UploadDataHelper {
    private static final Logger log = LoggerFactory.getLogger(UploadDataHelper.class);
    @Resource
    private WinccConfig.DeviceStatusUploadConfig statusConfig;
    @Resource
    private WinccConfig.DeviceEventUploadConfig eventConfig;
    @Resource
    private WinccConfig.SortDataUploadConfig dataConfig;
    @Resource
    private WinccConfig.ManufacturerConfig manufacturerConfig;
    @Resource
    private BasicConfigService basicConfigService;
    @Resource
    private UploadDataService uploadDataService;
    @Resource
    private HttpUtils httpUtils;
    @Resource
    private DeviceInfoManager deviceInfoManager;

    public void sendData(UploadData data) {
        if (RequestType.DEVICE_STATUS.getCode().equals(data.getType())) {
            UploadData disappearData = this.createUploadDataForDisappear(data);
            if (disappearData != null) {
                this.forSendData(disappearData, (byte)0);
            } else {
                log.debug("\u8df3\u8fc7\u4e00\u4e2a\u72b6\u6001\u6ce8\u9500\u7684\u4e0a\u62a5\u3002\u65b0\u72b6\u6001\u6d88\u606f: {}", (Object)JSON.toJSONString((Object)data));
            }
        } else if (RequestType.DEVICE_EVENT.getCode().equals(data.getType())) {
            UploadData disappearData = this.createUploadDataForDisappear(data);
            if (disappearData != null) {
                this.forSendData(disappearData, (byte)0);
            } else {
                log.debug("\u8df3\u8fc7\u4e00\u4e2a\u6545\u969c\u6ce8\u9500\u7684\u4e0a\u62a5\u3002\u65b0\u6545\u969c\u6d88\u606f: {}", (Object)JSON.toJSONString((Object)data));
            }
        }
        this.forSendData(data, (byte)1);
    }

    public UploadData createUploadDataForDisappear(UploadData data) {
        UploadData disappearData = new UploadData();
        disappearData.setCreateTime(data.getCreateTime());
        disappearData.setFormat(data.getFormat());
        disappearData.setId(Long.valueOf(0L));
        disappearData.setMachineId(data.getMachineId());
        disappearData.setManufacturerId(data.getManufacturerId());
        disappearData.setRequestId(UUID.randomUUID((boolean)true).toString(true));
        Date now = new Date();
        String requestTimeStr = TokenUtils.formatDate((Date)now);
        disappearData.setRequestTime(DateUtils.dateTime((String)DateUtils.YYYY_MM_DD_HH_MM_SS, (String)requestTimeStr));
        disappearData.setRetryCount(data.getRetryCount());
        disappearData.setStatus(UploadDataStatus.INIT.getCode());
        if (RequestType.DEVICE_STATUS.getCode().equals(data.getType())) {
            DeviceStatus deviceStatus = this.createStatusDataForDisappear(data);
            if (!this.hasAnyMessage(deviceStatus)) {
                return null;
            }
            disappearData.setRequestBody(JSON.toJSONString((Object)deviceStatus));
        } else {
            DeviceEvent deviceEvent = this.createEventDataForDisappear(data);
            if (!this.hasAnyMessage(deviceEvent)) {
                return null;
            }
            disappearData.setRequestBody(JSON.toJSONString((Object)deviceEvent));
        }
        String token = TokenUtils.getToken((String)disappearData.getRequestId(), (String)requestTimeStr, (String)this.manufacturerConfig.getSecretKey());
        disappearData.setToken(token);
        disappearData.setType(data.getType());
        return disappearData;
    }

    private DeviceStatus createStatusDataForDisappear(UploadData data) {
        DeviceStatus deviceStatus = (DeviceStatus)JSON.parseObject((String)data.getRequestBody(), DeviceStatus.class);
        DeviceStatus disappearStatus = new DeviceStatus();
        disappearStatus.setCarrierListMsg(this.createCarrierListMsgForDisappear(deviceStatus.getCarrierListMsg()));
        disappearStatus.setDynamicScaleListMsg(this.createDynamicScaleListMsgForDisappear(deviceStatus.getDynamicScaleListMsg()));
        disappearStatus.setElectricMotorListMsg(this.createElectricMotorListMsgForDisappear(deviceStatus.getElectricMotorListMsg()));
        disappearStatus.setGrayscaleListMsg(this.createGrayscaleListMsgForDisappear(deviceStatus.getGrayscaleListMsg()));
        disappearStatus.setInductListMsg(this.createtInductListMsgForDisappear(deviceStatus.getInductListMsg()));
        disappearStatus.setLinesListMsg(this.createLinesListMsgForDisappear(deviceStatus.getLinesListMsg()));
        disappearStatus.setObrListMsg(this.createObrListMsgForDisappear(deviceStatus.getObrListMsg()));
        disappearStatus.setPhysicalPosListMsg(this.createPhysicalPosListMsgForDisappear(deviceStatus.getPhysicalPosListMsg()));
        disappearStatus.setSorterListMsg(this.createSorterListMsgForDisappear(deviceStatus.getSorterListMsg()));
        disappearStatus.setWheelBeltListMsg(this.createWheelBeltListMsgForDisappear(deviceStatus.getWheelBeltListMsg()));
        return disappearStatus;
    }

    private List<CarrierMsg> createCarrierListMsgForDisappear(List<CarrierMsg> carrierListMsg) {
        if (carrierListMsg == null) {
            return null;
        }
        ArrayList<CarrierMsg> list = new ArrayList<CarrierMsg>();
        for (CarrierMsg msg : carrierListMsg) {
            String key = DeviceClass.CARRIER.getCode() + "-" + msg.getDevId();
            CarrierMsg lastMsg = (CarrierMsg)this.deviceInfoManager.getLastStatusMap().get(key);
            if (lastMsg != null) {
                lastMsg.setEvenFlag(new Integer(0));
                list.add(lastMsg);
                continue;
            }
            log.debug("{} {} \u6ca1\u6709\u65e7\u72b6\u6001\u3002", (Object)DeviceClass.CARRIER.getDesc(), (Object)msg.getDevId());
        }
        return list;
    }

    private List<DynamicScaleMsg> createDynamicScaleListMsgForDisappear(List<DynamicScaleMsg> dynamicScaleListMsg) {
        if (dynamicScaleListMsg == null) {
            return null;
        }
        ArrayList<DynamicScaleMsg> list = new ArrayList<DynamicScaleMsg>();
        for (DynamicScaleMsg msg : dynamicScaleListMsg) {
            String key = DeviceClass.DYNAMICSCALE.getCode() + "-" + msg.getDevId();
            DynamicScaleMsg lastMsg = (DynamicScaleMsg)this.deviceInfoManager.getLastStatusMap().get(key);
            if (lastMsg != null) {
                lastMsg.setEvenFlag(new Integer(0));
                list.add(lastMsg);
                continue;
            }
            log.debug("{} {} \u6ca1\u6709\u65e7\u72b6\u6001\u3002", (Object)DeviceClass.DYNAMICSCALE.getDesc(), (Object)msg.getDevId());
        }
        return list;
    }

    private List<ElectricMotorMsg> createElectricMotorListMsgForDisappear(List<ElectricMotorMsg> electricMotorListMsg) {
        if (electricMotorListMsg == null) {
            return null;
        }
        ArrayList<ElectricMotorMsg> list = new ArrayList<ElectricMotorMsg>();
        for (ElectricMotorMsg msg : electricMotorListMsg) {
            String key = DeviceClass.ELECTRICMOTOR.getCode() + "-" + msg.getDevId();
            ElectricMotorMsg lastMsg = (ElectricMotorMsg)this.deviceInfoManager.getLastStatusMap().get(key);
            if (lastMsg != null) {
                lastMsg.setEvenFlag(new Integer(0));
                list.add(lastMsg);
                continue;
            }
            log.debug("{} {} \u6ca1\u6709\u65e7\u72b6\u6001\u3002", (Object)DeviceClass.ELECTRICMOTOR.getDesc(), (Object)msg.getDevId());
        }
        return list;
    }

    private List<GrayscaleMsg> createGrayscaleListMsgForDisappear(List<GrayscaleMsg> grayscaleListMsg) {
        if (grayscaleListMsg == null) {
            return null;
        }
        ArrayList<GrayscaleMsg> list = new ArrayList<GrayscaleMsg>();
        for (GrayscaleMsg msg : grayscaleListMsg) {
            String key = DeviceClass.GRAYSCALE.getCode() + "-" + msg.getDevId();
            GrayscaleMsg lastMsg = (GrayscaleMsg)this.deviceInfoManager.getLastStatusMap().get(key);
            if (lastMsg != null) {
                lastMsg.setEvenFlag(new Integer(0));
                list.add(lastMsg);
                continue;
            }
            log.debug("{} {} \u6ca1\u6709\u65e7\u72b6\u6001\u3002", (Object)DeviceClass.GRAYSCALE.getDesc(), (Object)msg.getDevId());
        }
        return list;
    }

    private List<InductMsg> createtInductListMsgForDisappear(List<InductMsg> inductListMsg) {
        if (inductListMsg == null) {
            return null;
        }
        ArrayList<InductMsg> list = new ArrayList<InductMsg>();
        for (InductMsg msg : inductListMsg) {
            String key = DeviceClass.INDUCT.getCode() + "-" + msg.getDevId();
            InductMsg lastMsg = (InductMsg)this.deviceInfoManager.getLastStatusMap().get(key);
            if (lastMsg != null) {
                lastMsg.setEvenFlag(new Integer(0));
                list.add(lastMsg);
                continue;
            }
            log.debug("{} {} \u6ca1\u6709\u65e7\u72b6\u6001\u3002", (Object)DeviceClass.INDUCT.getDesc(), (Object)msg.getDevId());
        }
        return list;
    }

    private List<LinesMsg> createLinesListMsgForDisappear(List<LinesMsg> linesListMsg) {
        if (linesListMsg == null) {
            return null;
        }
        ArrayList<LinesMsg> list = new ArrayList<LinesMsg>();
        for (LinesMsg msg : linesListMsg) {
            String key = DeviceClass.LINESDEVICE.getCode() + "-" + msg.getDevId();
            LinesMsg lastMsg = (LinesMsg)this.deviceInfoManager.getLastStatusMap().get(key);
            if (lastMsg != null) {
                lastMsg.setEvenFlag(new Integer(0));
                list.add(lastMsg);
                continue;
            }
            log.debug("{} {} \u6ca1\u6709\u65e7\u72b6\u6001\u3002", (Object)DeviceClass.LINESDEVICE.getDesc(), (Object)msg.getDevId());
        }
        return list;
    }

    private List<ObrMsg> createObrListMsgForDisappear(List<ObrMsg> obrListMsg) {
        if (obrListMsg == null) {
            return null;
        }
        ArrayList<ObrMsg> list = new ArrayList<ObrMsg>();
        for (ObrMsg msg : obrListMsg) {
            String key = DeviceClass.OBR.getCode() + "-" + msg.getDevId();
            ObrMsg lastMsg = (ObrMsg)this.deviceInfoManager.getLastStatusMap().get(key);
            if (lastMsg != null) {
                lastMsg.setEvenFlag(new Integer(0));
                list.add(lastMsg);
                continue;
            }
            log.debug("{} {} \u6ca1\u6709\u65e7\u72b6\u6001\u3002", (Object)DeviceClass.OBR.getDesc(), (Object)msg.getDevId());
        }
        return list;
    }

    private List<PhysicalPosMsg> createPhysicalPosListMsgForDisappear(List<PhysicalPosMsg> physicalPosListMsg) {
        if (physicalPosListMsg == null) {
            return null;
        }
        ArrayList<PhysicalPosMsg> list = new ArrayList<PhysicalPosMsg>();
        for (PhysicalPosMsg msg : physicalPosListMsg) {
            String key = DeviceClass.PHYSICALPOS.getCode() + "-" + msg.getDevId();
            PhysicalPosMsg lastMsg = (PhysicalPosMsg)this.deviceInfoManager.getLastStatusMap().get(key);
            if (lastMsg != null) {
                lastMsg.setEvenFlag(new Integer(0));
                list.add(lastMsg);
                continue;
            }
            log.debug("{} {} \u6ca1\u6709\u65e7\u72b6\u6001\u3002", (Object)DeviceClass.PHYSICALPOS.getDesc(), (Object)msg.getDevId());
        }
        return list;
    }

    private List<SorterMsg> createSorterListMsgForDisappear(List<SorterMsg> sorterListMsg) {
        if (sorterListMsg == null) {
            return null;
        }
        ArrayList<SorterMsg> list = new ArrayList<SorterMsg>();
        for (SorterMsg msg : sorterListMsg) {
            if (msg.getSorterStatus().endsWith("10100008")) {
                log.info("\u5206\u62e3\u673a\u5728\u7ebf\u72b6\u6001\u4e0d\u9700\u8981\u81ea\u52a8\u6ce8\u9500\u3002\u72b6\u6001: {}\u3002", (Object)JSON.toJSONString((Object)msg));
                continue;
            }
            String key = DeviceClass.SORTER.getCode() + "-" + msg.getDevId();
            SorterMsg lastMsg = (SorterMsg)this.deviceInfoManager.getLastStatusMap().get(key);
            if (lastMsg != null) {
                lastMsg.setEvenFlag(new Integer(0));
                list.add(lastMsg);
                continue;
            }
            log.debug("{} {} \u6ca1\u6709\u65e7\u72b6\u6001\u3002", (Object)DeviceClass.SORTER.getDesc(), (Object)msg.getDevId());
        }
        return list;
    }

    private List<WheelBeltMsg> createWheelBeltListMsgForDisappear(List<WheelBeltMsg> wheelBeltListMsg) {
        if (wheelBeltListMsg == null) {
            return null;
        }
        ArrayList<WheelBeltMsg> list = new ArrayList<WheelBeltMsg>();
        for (WheelBeltMsg msg : wheelBeltListMsg) {
            String key = DeviceClass.WHEELBELT.getCode() + "-" + msg.getDevId();
            WheelBeltMsg lastMsg = (WheelBeltMsg)this.deviceInfoManager.getLastStatusMap().get(key);
            if (lastMsg != null) {
                lastMsg.setEvenFlag(new Integer(0));
                list.add(lastMsg);
                continue;
            }
            log.debug("{} {} \u6ca1\u6709\u65e7\u72b6\u6001\u3002", (Object)DeviceClass.WHEELBELT.getDesc(), (Object)msg.getDevId());
        }
        return list;
    }

    private DeviceEvent createEventDataForDisappear(UploadData data) {
        DeviceEvent deviceEvent = (DeviceEvent)JSON.parseObject((String)data.getRequestBody(), DeviceEvent.class);
        DeviceEvent disappearEvent = new DeviceEvent();
        disappearEvent.setCollectTime(deviceEvent.getCollectTime());
        disappearEvent.setInstructionListMsg(new ArrayList());
        disappearEvent.setSorterId(deviceEvent.getSorterId());
        disappearEvent.setSorterName(deviceEvent.getSorterName());
        disappearEvent.setFaultListMsg(this.createFaultListMsgForDisappear(deviceEvent.getFaultListMsg()));
        return disappearEvent;
    }

    private List<FaultMsg> createFaultListMsgForDisappear(List<FaultMsg> faultListMsg) {
        if (faultListMsg == null) {
            return null;
        }
        ArrayList<FaultMsg> list = new ArrayList<FaultMsg>();
        for (FaultMsg msg : faultListMsg) {
            String key = msg.getDeviceClass() + "-" + msg.getDevId();
            FaultMsg lastMsg = (FaultMsg)this.deviceInfoManager.getLastEventMap().get(key);
            if (lastMsg != null) {
                lastMsg.setEvenFlag(new Integer(0));
                list.add(lastMsg);
                continue;
            }
            log.debug("{} {} \u6ca1\u6709\u65e7\u72b6\u6001\u3002", (Object)msg.getDeviceClass(), (Object)msg.getDevId());
        }
        return list;
    }

    private void forSendData(UploadData data, byte happenOrDisappear) {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("request_id", data.getRequestId());
        params.put("manufacturer_id", data.getManufacturerId());
        params.put("token", data.getToken());
        params.put("format", data.getFormat());
        params.put("request_body", data.getRequestBody());
        String requestTimeStr = TokenUtils.formatDate((Date)data.getRequestTime());
        params.put("request_time", requestTimeStr);
        String url = RequestType.DEVICE_STATUS.getCode().equals(data.getType()) ? this.statusConfig.getUrl() : (RequestType.DEVICE_EVENT.getCode().equals(data.getType()) ? this.eventConfig.getUrl() : this.dataConfig.getUrl());
        if (0 == happenOrDisappear) {
            log.debug("\u8bbe\u5907\u72b6\u6001\u6216\u6545\u969c\u6d88\u5931\u4e0a\u62a5\u3002");
        }
        log.info("\u6570\u636e\u4e0a\u62a5\u7c7b\u578b: {}, \u4e0a\u62a5\u5730\u5740: {}\u3002", (Object)data.getType(), (Object)url);
        String responseStr = this.httpUtils.post(url, params);
        log.debug("\u54cd\u5e94\u5185\u5bb9: {}\u3002", (Object)responseStr);
        if (StringUtils.isEmpty((String)responseStr)) {
            log.warn("\u4e0a\u4f20\u65e0\u54cd\u5e94\u540e\u66f4\u65b0\u8bb0\u5f55: {}\u3002", (Object)responseStr);
            if (1 == happenOrDisappear) {
                this.updateForRetry(data);
            }
            return;
        }
        CommonRes res = this.parseCommonRes(responseStr);
        if (res == null) {
            if (1 == happenOrDisappear) {
                log.warn("\u4e0a\u4f20\u5931\u8d25\u540e\u66f4\u65b0\u8bb0\u5f55\u3002");
                this.updateForRetry(data);
            }
        } else if (res.getStatus() == 0) {
            if (happenOrDisappear == 1) {
                if (RequestType.DEVICE_STATUS.getCode().equals(data.getType())) {
                    log.debug("\u4e0a\u4f20\u6210\u529f\u540e\u66f4\u65b0\u6700\u540e\u72b6\u6001");
                    this.updateLastStatusCache(data);
                } else if (RequestType.DEVICE_EVENT.getCode().equals(data.getType())) {
                    log.debug("\u4e0a\u4f20\u6210\u529f\u540e\u66f4\u65b0\u6700\u540e\u6545\u969c");
                    this.updateLastEventCache(data);
                }
                log.debug("\u4e0a\u4f20\u6210\u529f\u540e\u66f4\u65b0\u8bb0\u5f55\u3002");
                data.setResponse(responseStr);
                this.updateStatusForSuccess(data);
            } else {
                log.debug("\u8bbe\u5907\u72b6\u6001\u6216\u6545\u969c\u6d88\u5931\u4e0a\u62a5\u6210\u529f");
            }
        } else if (happenOrDisappear == 1) {
            this.updateForRetry(data);
        }
    }

    private void updateLastStatusCache(UploadData data) {
        String jsonStr = data.getRequestBody();
        DeviceStatus deviceStatus = (DeviceStatus)JSON.parseObject((String)jsonStr, DeviceStatus.class);
        this.updateLastStatusCache(deviceStatus.getCarrierListMsg(), DeviceClass.CARRIER.getCode());
        this.updateLastStatusCache(deviceStatus.getChuteListMsg(), DeviceClass.CHUTE.getCode());
        this.updateLastStatusCache(deviceStatus.getDynamicScaleListMsg(), DeviceClass.DYNAMICSCALE.getCode());
        this.updateLastStatusCache(deviceStatus.getElectricMotorListMsg(), DeviceClass.ELECTRICMOTOR.getCode());
        this.updateLastStatusCache(deviceStatus.getGrayscaleListMsg(), DeviceClass.GRAYSCALE.getCode());
        this.updateLastStatusCache(deviceStatus.getInductListMsg(), DeviceClass.INDUCT.getCode());
        this.updateLastStatusCache(deviceStatus.getLinesListMsg(), DeviceClass.LINESDEVICE.getCode());
        this.updateLastStatusCache(deviceStatus.getObrListMsg(), DeviceClass.OBR.getCode());
        this.updateLastStatusCache(deviceStatus.getPhysicalPosListMsg(), DeviceClass.PHYSICALPOS.getCode());
        this.updateLastStatusCache(deviceStatus.getWheelBeltListMsg(), DeviceClass.WHEELBELT.getCode());
    }

    private void updateLastStatusCache(List<? extends AbstractDeviceMsg> msgList, String deviceClass) {
        if (CollectionUtils.isEmpty(msgList)) {
            return;
        }
        for (AbstractDeviceMsg abstractDeviceMsg : msgList) {
            String key = deviceClass + "-" + abstractDeviceMsg.getDevId();
            this.deviceInfoManager.getLastStatusMap().put(key, abstractDeviceMsg);
        }
    }

    private void updateLastEventCache(UploadData data) {
        String jsonStr = data.getRequestBody();
        DeviceEvent deviceEvent = (DeviceEvent)JSON.parseObject((String)jsonStr, DeviceEvent.class);
        this.updateLastEventCache(deviceEvent.getFaultListMsg());
    }

    private void updateLastEventCache(List<FaultMsg> msgList) {
        if (CollectionUtils.isEmpty(msgList)) {
            return;
        }
        for (FaultMsg msg : msgList) {
            String key = msg.getDeviceClass() + "-" + msg.getDevId();
            this.deviceInfoManager.getLastEventMap().put(key, msg);
        }
    }

    private CommonRes parseCommonRes(String responseStr) {
        try {
            log.debug("\u89e3\u6790\u54cd\u5e94: {}\u3002", (Object)responseStr);
            CommonRes res = (CommonRes)JSON.parseObject((String)responseStr, CommonRes.class);
            log.debug("\u89e3\u6790\u6210\u529f: {}\u3002", (Object)JSON.toJSONString((Object)res));
            return res;
        }
        catch (Throwable t) {
            log.debug(t.getMessage(), t);
            log.error("\u89e3\u6790\u54cd\u5e94\u5931\u8d25\u3002\u9519\u8bef\u4fe1\u606f: {}\u3002\u54cd\u5e94\u5185\u5bb9: {}\u3002", (Object)t.getMessage(), (Object)responseStr);
            return null;
        }
    }

    private void updateStatusForSuccess(UploadData data) {
        data.setStatus(UploadDataStatus.FINISHED.getCode());
        data.setUpdateTime(new Date());
        this.uploadDataService.updateById((Object)data);
    }

    private void updateForRetry(UploadData data) {
        int intervalSecond = this.calcRetryInterval(data);
        if (intervalSecond > 0) {
            log.debug("\u66f4\u65b0\u62a5\u6587\u91cd\u9001\u95f4\u9694\u79d2\u6570\u3002\u62a5\u6587\u8bf7\u6c42ID: {}, \u95f4\u9694: {}\u3002", (Object)data.getRequestId(), (Object)intervalSecond);
            Date requestTime = new Date(System.currentTimeMillis() + (long)intervalSecond * 1000L);
            String requestTimeStr = TokenUtils.formatDate((Date)requestTime);
            data.setRequestTime(DateUtils.dateTime((String)DateUtils.YYYY_MM_DD_HH_MM_SS, (String)requestTimeStr));
            log.info("requestId: {}. request_time: {}, secretKey: {}\u3002", new Object[]{data.getRequestId(), requestTimeStr, this.manufacturerConfig.getSecretKey()});
            String token = TokenUtils.getToken((String)data.getRequestId(), (String)requestTimeStr, (String)this.manufacturerConfig.getSecretKey());
            log.info("\u66f4\u65b0\u8ba1\u7b97\u7684token: {}\u3002", (Object)token);
            data.setToken(token);
            data.setRetryCount(Integer.valueOf(data.getRetryCount() + 1));
            data.setStatus(UploadDataStatus.RETRYING.getCode());
        } else {
            data.setStatus(UploadDataStatus.FAILED.getCode());
        }
        data.setUpdateTime(new Date());
        this.uploadDataService.updateById((Object)data);
    }

    private int calcRetryInterval(UploadData data) {
        int maxRetryCount;
        int maxInterval;
        int intervalSecond = 1;
        int retryCount = data.getRetryCount();
        ++retryCount;
        if (RequestType.DEVICE_STATUS.getCode().equals(data.getType())) {
            maxInterval = this.statusConfig.getMaxInterval();
            maxRetryCount = this.statusConfig.getMaxRetryCount();
        } else if (RequestType.DEVICE_EVENT.getCode().equals(data.getType())) {
            maxInterval = this.eventConfig.getMaxInterval();
            maxRetryCount = this.eventConfig.getMaxRetryCount();
        } else {
            maxInterval = this.dataConfig.getMaxInterval();
            maxRetryCount = this.dataConfig.getMaxRetryCount();
        }
        if (retryCount > maxRetryCount) {
            log.error("\u62a5\u6587\u8d85\u8fc7\u91cd\u9001\u6b21\u6570\u3002\u62a5\u6587\u8bf7\u6c42ID: {}, \u7d2f\u8ba1\u5c1d\u8bd5\u6b21\u6570: {}\u3002", (Object)data.getRequestId(), (Object)retryCount);
            return 0;
        }
        for (int i = 0; i < retryCount; ++i) {
            if (intervalSecond < maxInterval) {
                intervalSecond *= 2;
                continue;
            }
            intervalSecond = maxInterval;
            break;
        }
        return intervalSecond;
    }

    public List<UploadData> getDeviceStatusList(MachineConfig machine) {
        List<String> statusList = Arrays.asList(UploadDataStatus.INIT.getCode(), UploadDataStatus.RETRYING.getCode());
        Wrapper query = (Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery().in(UploadData::getStatus, statusList)).eq(UploadData::getMachineId, (Object)machine.getMachineId())).eq(UploadData::getType, (Object)RequestType.DEVICE_STATUS.getCode())).orderByAsc(UploadData::getStatus)).orderByAsc(UploadData::getId)).last(" limit 100");
        List list = this.uploadDataService.list(query);
        return list;
    }

    public void saveUploadData(UploadData data) {
        this.uploadDataService.saveTmUploadData(data);
    }

    public boolean hasAnyMessage(DeviceStatus status) {
        if (status == null) {
            return false;
        }
        if (CollectionUtils.isNotEmpty((Collection)status.getCarrierListMsg())) {
            return true;
        }
        if (CollectionUtils.isNotEmpty((Collection)status.getChuteListMsg())) {
            return true;
        }
        if (CollectionUtils.isNotEmpty((Collection)status.getDynamicScaleListMsg())) {
            return true;
        }
        if (CollectionUtils.isNotEmpty((Collection)status.getElectricMotorListMsg())) {
            return true;
        }
        if (CollectionUtils.isNotEmpty((Collection)status.getGrayscaleListMsg())) {
            return true;
        }
        if (CollectionUtils.isNotEmpty((Collection)status.getInductListMsg())) {
            return true;
        }
        if (CollectionUtils.isNotEmpty((Collection)status.getLinesListMsg())) {
            return true;
        }
        if (CollectionUtils.isNotEmpty((Collection)status.getObrListMsg())) {
            return true;
        }
        if (CollectionUtils.isNotEmpty((Collection)status.getPhotoelectricListMsg())) {
            return true;
        }
        if (CollectionUtils.isNotEmpty((Collection)status.getPhysicalPosListMsg())) {
            return true;
        }
        if (CollectionUtils.isNotEmpty((Collection)status.getRelationDeviceListMsg())) {
            return true;
        }
        if (CollectionUtils.isNotEmpty((Collection)status.getSorterListMsg())) {
            return true;
        }
        return CollectionUtils.isNotEmpty((Collection)status.getWheelBeltListMsg());
    }

    public boolean hasAnyMessage(DeviceEvent event) {
        if (event == null) {
            return false;
        }
        if (CollectionUtils.isNotEmpty((Collection)event.getFaultListMsg())) {
            return true;
        }
        return CollectionUtils.isNotEmpty((Collection)event.getInstructionListMsg());
    }
}

