/*
 * Decompiled with CFR 0.152.
 */
package com.simba.services.helper;

import com.alibaba.fastjson.JSON;
import com.simba.services.bean.domain.MachineConfig;
import com.simba.services.bean.domain.ReceivedData;
import com.simba.services.bean.model.DeviceInfoManager;
import com.simba.services.bean.request.CommonReq;
import com.simba.services.bean.request.SysConfig;
import com.simba.services.bean.response.CommonRes;
import com.simba.services.bean.setting.Parameter;
import com.simba.services.common.utils.DateUtils;
import com.simba.services.common.utils.StringUtils;
import com.simba.services.enums.ParameterClass;
import com.simba.services.enums.ReceivedDataStatus;
import com.simba.services.enums.RequestType;
import com.simba.services.exception.ParameterCheckException;
import com.simba.services.service.MachineConfigService;
import com.simba.services.service.ReceivedDataService;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class SysSettingHelper {
    private static final Logger log = LoggerFactory.getLogger(SysSettingHelper.class);
    @Resource
    private MachineConfigService machineConfigService;
    @Resource
    private ReceivedDataService receivedDataService;
    @Resource
    private DeviceInfoManager deviceInfoManager;

    /*
     * Enabled aggressive block sorting
     */
    public void changeSysSetting(SysConfig sysSettingParameter) {
        this.checkParameters(sysSettingParameter);
        String machineId = sysSettingParameter.getSorterId();
        MachineConfig config = this.machineConfigService.getMachineConfigByMachineId(machineId);
        if (config == null) {
            throw new ParameterCheckException(null);
        }
        List parameterList = sysSettingParameter.getConfigDataListMsg();
        log.info("\u53c2\u6570\u914d\u7f6e\u4e2a\u6570\u4e3a: {}\u3002", (Object)parameterList.size());
        boolean atleastOneSuccess = false;
        for (Parameter param : parameterList) {
            String paramName;
            block18: {
                block17: {
                    long interval;
                    String paramClass;
                    block19: {
                        log.debug("\u5f53\u524d\u53c2\u6570: {}\u3002", (Object)JSON.toJSONString((Object)param));
                        this.checkParameters(param);
                        paramClass = param.getParamClass().trim();
                        paramName = param.getParamName().trim();
                        String paramValue = param.getParamValue().trim();
                        if (!"\u63a8\u9001\u95f4\u9694".equals(paramName) && !"\u6545\u969c\u63d0\u9192\u5468\u671f".equals(paramName)) break block18;
                        interval = Long.parseLong(paramValue);
                        if (interval < 10L) {
                            log.error("\u53d1\u9001\u95f4\u9694\u592a\u5c0f\uff0c\u5ffd\u7565\u6b64\u914d\u7f6e\u3002\u914d\u7f6e\u4fe1\u606f: {}\u3002", (Object)JSON.toJSONString((Object)param));
                            continue;
                        }
                        if (ParameterClass.SORT_DATA.getDesc().equals(paramClass)) {
                            if ("\u63a8\u9001\u95f4\u9694".equals(paramName)) {
                                config.setDataSendingInterval(Long.valueOf(interval));
                                break block17;
                            } else {
                                log.warn("\u4e0d\u652f\u6301\u7684\u53c2\u6570\u8bbe\u7f6e: {}\u3002", (Object)JSON.toJSONString((Object)param));
                                continue;
                            }
                        }
                        if (!ParameterClass.DEVICE_STATE.getDesc().equals(paramClass)) break block19;
                        if ("\u63a8\u9001\u95f4\u9694".equals(paramName)) {
                            config.setStatusSendingInterval(Long.valueOf(interval));
                            break block17;
                        } else if ("reset".equals(paramName)) {
                            this.deviceInfoManager.reset();
                            break block17;
                        } else {
                            log.warn("\u4e0d\u652f\u6301\u7684\u53c2\u6570\u8bbe\u7f6e: {}\u3002", (Object)JSON.toJSONString((Object)param));
                            continue;
                        }
                    }
                    if (ParameterClass.DEVICE_EVENT.getDesc().equals(paramClass)) {
                        if ("\u6545\u969c\u63d0\u9192\u5468\u671f".equals(paramName)) {
                            config.setStatusSendingInterval(Long.valueOf(interval));
                            break block17;
                        } else {
                            log.warn("\u4e0d\u652f\u6301\u7684\u53c2\u6570\u8bbe\u7f6e: {}\u3002", (Object)JSON.toJSONString((Object)param));
                            continue;
                        }
                    }
                    if (ParameterClass.LOG_MSG.getDesc().equals(paramClass)) {
                        if ("\u63a8\u9001\u95f4\u9694".equals(paramName)) {
                            config.setLogSendingInterval(Long.valueOf(interval));
                            break block17;
                        } else {
                            log.warn("\u4e0d\u652f\u6301\u7684\u53c2\u6570\u8bbe\u7f6e: {}\u3002", (Object)JSON.toJSONString((Object)param));
                            continue;
                        }
                    }
                    List supportedParamClasses = Arrays.asList(ParameterClass.values()).stream().map(e -> e.getDesc()).collect(Collectors.toList());
                    log.error("\u4e0d\u652f\u6301\u7684\u53c2\u6570\u914d\u7f6e\u79cd\u522b\u3002\u652f\u6301\u7684\u79cd\u522b\u5217\u8868\u4e3a: {}, \u5b9e\u9645\u7684\u79cd\u522b\u4e3a: {}\u3002", supportedParamClasses, (Object)paramClass);
                    continue;
                }
                this.machineConfigService.updateById((Object)config);
                atleastOneSuccess = true;
                continue;
            }
            String[] supportedParamNames = new String[]{"\u63a8\u9001\u95f4\u9694", "\u6545\u969c\u63d0\u9192\u5468\u671f"};
            log.error("\u4e0d\u652f\u6301\u7684\u53c2\u6570\u914d\u7f6e\u540d\u3002\u652f\u6301\u7684\u53c2\u6570\u540d\u5217\u8868\u4e3a: {}, \u5b9e\u9645\u7684\u53c2\u6570\u540d\u4e3a: {}\u3002", (Object)supportedParamNames, (Object)paramName);
        }
        if (!atleastOneSuccess) {
            log.error("\u53c2\u6570\u914d\u7f6e\u5168\u90e8\u5931\u8d25\u3002");
            this.throwCheckException(4900, "\u6ca1\u6709\u4efb\u4f55\u53c2\u6570\u914d\u7f6e\u8bbe\u7f6e\u6210\u529f");
        }
    }

    public void throwCheckException(int errorCode, String errorMsg) {
        throw new ParameterCheckException(errorCode, errorMsg);
    }

    private void checkParameters(Parameter param) {
        String paramClass = param.getParamClass();
        if (StringUtils.isEmpty((String)paramClass)) {
            log.error("\u53c2\u6570\u79cd\u522b\u4e3a\u7a7a\u3002");
            throw new ParameterCheckException(1001, "\u7f3a\u5c11\u53c2\u6570\u6216\u53c2\u6570\u4e3a\u7a7a\u3002\u53c2\u6570\u540d: paramClass\u3002");
        }
        String paramName = param.getParamName();
        if (StringUtils.isEmpty((String)paramName)) {
            log.error("\u53c2\u6570\u540d\u4e3a\u7a7a\u3002");
            throw new ParameterCheckException(1001, "\u7f3a\u5c11\u53c2\u6570\u6216\u53c2\u6570\u4e3a\u7a7a\u3002\u53c2\u6570\u540d: paramName\u3002");
        }
        String paramValue = param.getParamValue();
        if (StringUtils.isEmpty((String)paramValue)) {
            log.error("\u53c2\u6570\u503c\u4e3a\u7a7a\u3002");
            throw new ParameterCheckException(1001, "\u7f3a\u5c11\u53c2\u6570\u6216\u53c2\u6570\u4e3a\u7a7a\u3002\u53c2\u6570\u540d: paramValue\u3002");
        }
    }

    private void checkParameters(SysConfig sysSettingParameter) {
        String sorterId = sysSettingParameter.getSorterId();
        if (StringUtils.isEmpty((String)sorterId)) {
            log.error("\u5206\u62e3\u673aID\u4e0d\u5b58\u5728\u6216\u4e3a\u7a7a: {}\u3002", (Object)sorterId);
            throw new ParameterCheckException(1001, "\u7f3a\u5c11\u53c2\u6570\u6216\u53c2\u6570\u4e3a\u7a7a\u3002\u53c2\u6570\u540d: sorterId\u3002");
        }
        String orgCode = sysSettingParameter.getOrgCode();
        if (StringUtils.isEmpty((String)orgCode)) {
            log.error("\u7ec4\u7ec7\u4ee3\u7801\u4e0d\u5b58\u5728\u6216\u4e3a\u7a7a: {}\u3002", (Object)orgCode);
            throw new ParameterCheckException(1001, "\u7f3a\u5c11\u53c2\u6570\u6216\u53c2\u6570\u4e3a\u7a7a\u3002\u53c2\u6570\u540d: sorterId\u3002");
        }
        List configDataList = sysSettingParameter.getConfigDataListMsg();
        if (CollectionUtils.isEmpty((Collection)configDataList)) {
            log.error("\u914d\u7f6e\u6570\u636e\u5217\u8868\u4e0d\u5b58\u5728\u6216\u4e3a\u7a7a: {}\u3002", (Object)configDataList);
            throw new ParameterCheckException(1001, "\u7f3a\u5c11\u53c2\u6570\u6216\u53c2\u6570\u4e3a\u7a7a\u3002\u53c2\u6570\u540d: configDataListMsg\u3002");
        }
    }

    public boolean saveRequest(CommonReq req) {
        log.info("\u4fdd\u5b58\u63a5\u6536\u5230\u7684\u8bf7\u6c42: {}", (Object)JSON.toJSONString((Object)req));
        ReceivedData data = this.receivedDataService.getByRequestId(req.getRequest_id());
        if (data != null) {
            data.setRetryCount(Integer.valueOf(data.getRetryCount() + 1));
            this.receivedDataService.updateById((Object)data);
            if (StringUtils.isEmpty((String)data.getResponse()) || "{}".equals(data.getResponse())) {
                log.info("\u63a5\u6536\u5230\u91cd\u9001\u7684\u8bf7\u6c42\uff0c\u91cd\u65b0\u5904\u7406\u3002");
                return false;
            }
            log.info("\u63a5\u6536\u5230\u91cd\u9001\u7684\u8bf7\u6c42\uff0c\u76f4\u63a5\u8fd4\u56de\u6210\u529f\u54cd\u5e94\u3002");
            return true;
        }
        data = new ReceivedData();
        data.setFormat(req.getFormat());
        data.setManufacturerId(req.getManufacturer_id());
        data.setType(RequestType.SYS_SETTING.getCode());
        data.setRequestBody("{}");
        data.setResponse("{}");
        data.setRequestId(req.getRequest_id());
        data.setRequestTime(DateUtils.dateTime((String)"yyyy-MM-dd HH:mm:ss.SSS", (String)req.getRequest_time()));
        data.setToken(req.getToken());
        data.setStatus(ReceivedDataStatus.RECEIVED.getCode());
        this.receivedDataService.save((Object)data);
        return false;
    }

    public void saveResponse(String requestId, CommonRes res) {
        log.info("\u4fdd\u5b58\u54cd\u5e94: {}, \u539f\u8bf7\u6c42ID: {}\u3002", (Object)JSON.toJSONString((Object)res), (Object)requestId);
        ReceivedData data = this.receivedDataService.getByRequestId(requestId);
        if (data == null) {
            log.error("\u627e\u4e0d\u5230\u539f\u8bf7\u6c42\u3002\u8bf7\u6c42ID: {}\u3002", (Object)requestId);
            return;
        }
        data.setResponse(JSON.toJSONString((Object)res));
        data.setStatus(ReceivedDataStatus.RESPONSED.getCode());
        this.receivedDataService.updateById((Object)data);
    }
}

